/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.reward.gui;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.reward.gui.GuiConfig;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class GuiConfigLoader {
    private final UniverseJobs plugin;
    private final Map<String, GuiConfig> guiConfigs;

    public GuiConfigLoader(UniverseJobs plugin) {
        this.plugin = plugin;
        this.guiConfigs = new ConcurrentHashMap<String, GuiConfig>();
    }

    public void loadGuiConfigs() {
        this.guiConfigs.clear();
        File guiFolder = new File(this.plugin.getDataFolder(), "gui");
        if (!guiFolder.exists() && !guiFolder.mkdirs()) {
            this.plugin.getLogger().severe("Failed to create gui folder: " + guiFolder.getPath());
            return;
        }
        this.createExampleGuiFiles();
        File[] files = guiFolder.listFiles((dir, name) -> name.endsWith(".yml"));
        if (files == null) {
            this.plugin.getLogger().warning("No GUI files found in gui folder");
            return;
        }
        for (File file : files) {
            this.loadGuiFile(file);
        }
    }

    private void loadGuiFile(File file) {
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            String fileName = file.getName().replace(".yml", "");
            GuiConfig guiConfig = new GuiConfig((ConfigurationSection)config);
            this.guiConfigs.put(fileName, guiConfig);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to load GUI file " + file.getName() + ": " + e.getMessage());
        }
    }

    public GuiConfig getGuiConfig(String name) {
        GuiConfig config = this.guiConfigs.get(name);
        if (config == null) {
            this.plugin.getLogger().warning("GUI configuration '" + name + "' not found");
        }
        return config;
    }

    public Map<String, GuiConfig> getAllGuiConfigs() {
        return new ConcurrentHashMap<String, GuiConfig>(this.guiConfigs);
    }

    private void createExampleGuiFiles() {
        this.createExampleRewardsGuiFile();
    }

    private void createExampleRewardsGuiFile() {
        File guiFile = new File(this.plugin.getDataFolder(), "gui/example_rewards_gui.yml");
        if (guiFile.exists()) {
            return;
        }
        try {
            this.plugin.saveResource("gui/example_rewards_gui.yml", false);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to create example GUI file from resources", e);
        }
    }

    public void reloadGuiConfigs() {
        this.loadGuiConfigs();
    }
}

