/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.storage;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class DataCompressor {
    private static final int MIN_COMPRESSION_SIZE = 512;
    private static final ConcurrentHashMap<String, String> compressionCache = new ConcurrentHashMap();
    private static final int MAX_CACHE_SIZE = 1000;
    private static final AtomicLong compressionTime = new AtomicLong(0L);
    private static final AtomicLong decompressionTime = new AtomicLong(0L);
    private static final AtomicLong bytesCompressed = new AtomicLong(0L);
    private static final AtomicLong bytesDecompressed = new AtomicLong(0L);
    private static final AtomicLong compressionCacheHits = new AtomicLong(0L);

    public static String compress(String data) {
        if (data == null || data.length() < 512) {
            return data;
        }
        String cached = compressionCache.get(data);
        if (cached != null) {
            compressionCacheHits.incrementAndGet();
            return cached;
        }
        long startTime = System.nanoTime();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (GZIPOutputStream gzipOut = new GZIPOutputStream(baos);){
                gzipOut.write(data.getBytes(StandardCharsets.UTF_8));
            }
            byte[] compressed = baos.toByteArray();
            String result = Base64.getEncoder().encodeToString(compressed);
            compressionTime.addAndGet(System.nanoTime() - startTime);
            bytesCompressed.addAndGet(data.length());
            if ((double)compressed.length < (double)data.length() * 0.8) {
                DataCompressor.cacheCompression(data, result);
            }
            return result;
        }
        catch (IOException e) {
            return data;
        }
    }

    public static String decompress(String compressedData) {
        String string;
        if (compressedData == null) {
            return null;
        }
        if (!DataCompressor.isCompressed(compressedData)) {
            return compressedData;
        }
        long startTime = System.nanoTime();
        byte[] compressed = Base64.getDecoder().decode(compressedData);
        ByteArrayInputStream bais = new ByteArrayInputStream(compressed);
        GZIPInputStream gzipIn = new GZIPInputStream(bais);
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = gzipIn.read(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            String result = baos.toString(StandardCharsets.UTF_8);
            decompressionTime.addAndGet(System.nanoTime() - startTime);
            bytesDecompressed.addAndGet(result.length());
            string = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    gzipIn.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return compressedData;
            }
        }
        gzipIn.close();
        return string;
    }

    private static boolean isCompressed(String data) {
        if (data.length() < 4) {
            return false;
        }
        return data.matches("^[A-Za-z0-9+/]*={0,2}$") && data.length() % 4 == 0;
    }

    private static void cacheCompression(String original, String compressed) {
        if (compressionCache.size() >= 1000) {
            String firstKey = compressionCache.keys().nextElement();
            compressionCache.remove(firstKey);
        }
        compressionCache.put(original, compressed);
    }

    public static Map<String, Object> getStats() {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        stats.put("compression_time_ms", (double)compressionTime.get() / 1000000.0);
        stats.put("decompression_time_ms", (double)decompressionTime.get() / 1000000.0);
        stats.put("bytes_compressed", bytesCompressed.get());
        stats.put("bytes_decompressed", bytesDecompressed.get());
        stats.put("cache_hits", compressionCacheHits.get());
        stats.put("cache_size", compressionCache.size());
        stats.put("cache_max_size", 1000);
        long totalIn = bytesCompressed.get();
        long totalOut = bytesDecompressed.get();
        if (totalIn > 0L && totalOut > 0L) {
            stats.put("compression_ratio", (double)totalOut / (double)totalIn);
        } else {
            stats.put("compression_ratio", 1.0);
        }
        return stats;
    }

    public static void resetStats() {
        compressionTime.set(0L);
        decompressionTime.set(0L);
        bytesCompressed.set(0L);
        bytesDecompressed.set(0L);
        compressionCacheHits.set(0L);
    }

    public static void clearCache() {
        compressionCache.clear();
    }

    public static Map<String, Object> testCompression(String sampleData) {
        HashMap<String, Object> report = new HashMap<String, Object>();
        if (sampleData == null) {
            report.put("error", "Sample data is null");
            return report;
        }
        long originalSize = sampleData.length();
        report.put("original_size", originalSize);
        if (originalSize < 512L) {
            report.put("compressed", false);
            report.put("reason", "Below minimum compression size");
            return report;
        }
        long startTime = System.nanoTime();
        String compressed = DataCompressor.compress(sampleData);
        long compressionTimeNs = System.nanoTime() - startTime;
        startTime = System.nanoTime();
        String decompressed = DataCompressor.decompress(compressed);
        long decompressionTimeNs = System.nanoTime() - startTime;
        report.put("compressed_size", compressed.length());
        report.put("compression_ratio", (double)originalSize / (double)compressed.length());
        report.put("space_saved_percent", (double)(originalSize - (long)compressed.length()) / (double)originalSize * 100.0);
        report.put("compression_time_ms", (double)compressionTimeNs / 1000000.0);
        report.put("decompression_time_ms", (double)decompressionTimeNs / 1000000.0);
        report.put("data_integrity", sampleData.equals(decompressed));
        return report;
    }
}

