/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.utils;

import fr.ax_dev.universejobs.utils.LegacyToMiniMessageConverter;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MessageUtils {
    private static final MiniMessage miniMessage = MiniMessage.miniMessage();
    private static final LegacyComponentSerializer legacySerializer = LegacyComponentSerializer.legacySection();
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\{([^}]+)}");

    public static Component parseMessage(String message) {
        if (message == null || message.isEmpty()) {
            return Component.empty();
        }
        String processedMessage = LegacyToMiniMessageConverter.containsLegacyCodes(message) ? LegacyToMiniMessageConverter.convert(message) : message;
        try {
            return miniMessage.deserialize((Object)processedMessage);
        }
        catch (Exception e) {
            return Component.text((String)message);
        }
    }

    public static Component parseMessage(String message, Map<String, String> placeholders) {
        if (message == null || message.isEmpty()) {
            return Component.empty();
        }
        String processedMessage = MessageUtils.replacePlaceholders(message, placeholders);
        return MessageUtils.parseMessage(processedMessage);
    }

    public static Component parseMessage(String message, String placeholder, String value) {
        return MessageUtils.parseMessage(message, Map.of(placeholder, value));
    }

    public static void sendMessage(Player player, String message) {
        if (player != null && message != null && !message.isEmpty()) {
            player.sendMessage(MessageUtils.parseMessage(message));
        }
    }

    public static void sendMessage(CommandSender sender, String message) {
        if (sender != null && message != null && !message.isEmpty()) {
            sender.sendMessage(MessageUtils.parseMessage(message));
        }
    }

    public static void sendMessage(Player player, String message, Map<String, String> placeholders) {
        if (player != null && message != null && !message.isEmpty()) {
            player.sendMessage(MessageUtils.parseMessage(message, placeholders));
        }
    }

    public static void sendMessage(Player player, String message, String placeholder, String value) {
        MessageUtils.sendMessage(player, message, Map.of(placeholder, value));
    }

    public static String translateLegacyColorCodes(String message) {
        if (message == null || message.isEmpty()) {
            return message;
        }
        return LegacyToMiniMessageConverter.convert(message);
    }

    private static String replacePlaceholders(String message, Map<String, String> placeholders) {
        if (placeholders == null || placeholders.isEmpty()) {
            return message;
        }
        StringBuffer result = new StringBuffer();
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(message);
        while (matcher.find()) {
            String key = matcher.group(1);
            String replacement = placeholders.getOrDefault(key, "{" + key + "}");
            matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static String stripFormatting(String message) {
        if (message == null || message.isEmpty()) {
            return message;
        }
        Component component = MessageUtils.parseMessage(message);
        return PlainTextComponentSerializer.plainText().serialize(component);
    }

    public static void sendActionBar(Player player, String message) {
        if (player != null && message != null) {
            player.sendActionBar(MessageUtils.parseMessage(message));
        }
    }

    public static void sendActionBar(Player player, String message, Map<String, String> placeholders) {
        if (player != null && message != null) {
            player.sendActionBar(MessageUtils.parseMessage(message, placeholders));
        }
    }

    public static String colorize(String message) {
        if (message == null || message.isEmpty()) {
            return message;
        }
        String processed = MessageUtils.translateLegacyColorCodes(message);
        Component component = MessageUtils.parseMessage(processed);
        return legacySerializer.serialize(component);
    }
}

