/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.utils;

import fr.ax_dev.universejobs.utils.MessageUtils;
import java.time.Duration;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;

public class PacketUtils {
    private static final ScheduledExecutorService ASYNC_EXECUTOR = Executors.newScheduledThreadPool(2, r -> {
        Thread thread = new Thread(r, "UniverseJobs-PacketSender");
        thread.setDaemon(true);
        return thread;
    });
    private static final Map<UUID, BossBar> ACTIVE_BOSSBARS = new ConcurrentHashMap<UUID, BossBar>();
    private static final Map<UUID, CompletableFuture<Void>> BOSSBAR_CLEANUPS = new ConcurrentHashMap<UUID, CompletableFuture<Void>>();
    private static final Object BOSSBAR_LOCK = new Object();

    public static void sendActionBarAsync(Player player, String message, int durationTicks) {
        PacketUtils.sendActionBarAsync(player, message, durationTicks, 20);
    }

    public static void sendActionBarAsync(Player player, String message, int durationTicks, int tickUpdateInterval) {
        if (!player.isOnline()) {
            return;
        }
        player.sendActionBar(MessageUtils.parseMessage(message));
        if (durationTicks > 0) {
            long delayMs = (long)durationTicks * 50L;
            long tickIntervalMs = (long)tickUpdateInterval * 50L;
            if (tickUpdateInterval != 20 && tickIntervalMs < delayMs) {
                ASYNC_EXECUTOR.schedule(() -> {
                    try {
                        long endTime = System.currentTimeMillis() + delayMs;
                        while (System.currentTimeMillis() < endTime && player.isOnline()) {
                            Thread.sleep(tickIntervalMs);
                            if (!player.isOnline()) break;
                            player.sendActionBar(MessageUtils.parseMessage(message));
                        }
                        if (player.isOnline()) {
                            player.sendActionBar(MessageUtils.parseMessage(""));
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }, 0L, TimeUnit.MILLISECONDS);
            } else {
                ASYNC_EXECUTOR.schedule(() -> {
                    if (player.isOnline()) {
                        player.sendActionBar(MessageUtils.parseMessage(""));
                    }
                }, delayMs, TimeUnit.MILLISECONDS);
            }
        }
    }

    public static void sendBossBarAsync(Player player, String message, BarColor color, BarStyle style, double progress, int durationTicks) {
        PacketUtils.sendBossBarAsync(player, message, color, style, progress, durationTicks, 20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendBossBarAsync(Player player, String message, BarColor color, BarStyle style, double progress, int durationTicks, int tickUpdateInterval) {
        BossBar bossBar;
        if (!player.isOnline()) {
            return;
        }
        UUID playerId = player.getUniqueId();
        Object object = BOSSBAR_LOCK;
        synchronized (object) {
            BossBar existingBar;
            CompletableFuture<Void> existingCleanup = BOSSBAR_CLEANUPS.remove(playerId);
            if (existingCleanup != null) {
                existingCleanup.cancel(true);
            }
            if ((existingBar = ACTIVE_BOSSBARS.remove(playerId)) != null) {
                try {
                    existingBar.removePlayer(player);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            bossBar = Bukkit.createBossBar((String)MessageUtils.stripFormatting(message), (BarColor)color, (BarStyle)style, (BarFlag[])new BarFlag[0]);
            bossBar.setProgress(Math.max(0.0, Math.min(1.0, progress)));
            bossBar.addPlayer(player);
            ACTIVE_BOSSBARS.put(playerId, bossBar);
        }
        if (durationTicks > 0) {
            long delayMs = (long)durationTicks * 50L;
            long tickIntervalMs = (long)tickUpdateInterval * 50L;
            BossBar finalBossBar = bossBar;
            CompletableFuture<Void> cleanup = tickUpdateInterval != 20 && tickIntervalMs < delayMs ? CompletableFuture.runAsync(() -> {
                try {
                    long endTime = System.currentTimeMillis() + delayMs;
                    while (System.currentTimeMillis() < endTime && player.isOnline()) {
                        Thread.sleep(tickIntervalMs);
                        BossBar currentBar = ACTIVE_BOSSBARS.get(playerId);
                        if (currentBar != finalBossBar || !player.isOnline()) break;
                        currentBar.setTitle(MessageUtils.stripFormatting(message));
                        currentBar.setColor(color);
                        currentBar.setStyle(style);
                        currentBar.setProgress(Math.max(0.0, Math.min(1.0, progress)));
                    }
                    Object object = BOSSBAR_LOCK;
                    synchronized (object) {
                        BossBar currentBar = ACTIVE_BOSSBARS.get(playerId);
                        if (currentBar == finalBossBar) {
                            try {
                                currentBar.removePlayer(player);
                                ACTIVE_BOSSBARS.remove(playerId);
                            }
                            catch (Exception e) {
                                ACTIVE_BOSSBARS.remove(playerId);
                            }
                        }
                        BOSSBAR_CLEANUPS.remove(playerId);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }, ASYNC_EXECUTOR) : CompletableFuture.runAsync(() -> {
                try {
                    Thread.sleep(delayMs);
                    Object object = BOSSBAR_LOCK;
                    synchronized (object) {
                        BossBar currentBar = ACTIVE_BOSSBARS.get(playerId);
                        if (currentBar == finalBossBar) {
                            try {
                                currentBar.removePlayer(player);
                                ACTIVE_BOSSBARS.remove(playerId);
                            }
                            catch (Exception e) {
                                ACTIVE_BOSSBARS.remove(playerId);
                            }
                        }
                        BOSSBAR_CLEANUPS.remove(playerId);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }, ASYNC_EXECUTOR);
            BOSSBAR_CLEANUPS.put(playerId, cleanup);
        }
    }

    public static void sendTitleAsync(Player player, String message, int fadeIn, int stay, int fadeOut) {
        PacketUtils.sendTitleAsync(player, message, fadeIn, stay, fadeOut, 20);
    }

    public static void sendTitleAsync(Player player, String message, int fadeIn, int stay, int fadeOut, int tickUpdateInterval) {
        long stayMs;
        long tickIntervalMs;
        if (!player.isOnline()) {
            return;
        }
        Component titleComponent = MessageUtils.parseMessage(message);
        TextComponent subtitleComponent = Component.empty();
        player.showTitle(Title.title((Component)titleComponent, (Component)subtitleComponent, (Title.Times)Title.Times.times((Duration)Duration.ofMillis((long)fadeIn * 50L), (Duration)Duration.ofMillis((long)stay * 50L), (Duration)Duration.ofMillis((long)fadeOut * 50L))));
        if (tickUpdateInterval != 20 && stay > 0 && (tickIntervalMs = (long)tickUpdateInterval * 50L) < (stayMs = (long)stay * 50L)) {
            ASYNC_EXECUTOR.schedule(() -> {
                try {
                    long endTime = System.currentTimeMillis() + stayMs;
                    while (System.currentTimeMillis() < endTime && player.isOnline()) {
                        Thread.sleep(tickIntervalMs);
                        if (player.isOnline()) {
                            Component refreshedTitle = MessageUtils.parseMessage(message);
                            int remainingStay = Math.min(stay, (int)(tickIntervalMs / 50L));
                            player.showTitle(Title.title((Component)refreshedTitle, (Component)Component.empty(), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(0L), (Duration)Duration.ofMillis((long)remainingStay * 50L), (Duration)Duration.ofMillis(0L))));
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }, 0L, TimeUnit.MILLISECONDS);
        }
    }

    public static void sendChatAsync(Player player, String message) {
        if (!player.isOnline()) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            if (player.isOnline()) {
                MessageUtils.sendMessage(player, message);
            }
        }, ASYNC_EXECUTOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanupPlayer(UUID playerId) {
        Object object = BOSSBAR_LOCK;
        synchronized (object) {
            BossBar bossBar;
            CompletableFuture<Void> cleanup = BOSSBAR_CLEANUPS.remove(playerId);
            if (cleanup != null) {
                cleanup.cancel(true);
            }
            if ((bossBar = ACTIVE_BOSSBARS.remove(playerId)) != null) {
                try {
                    bossBar.removeAll();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceCleanupPlayerBossbars(Player player) {
        if (player == null || !player.isOnline()) {
            return;
        }
        UUID playerId = player.getUniqueId();
        Object object = BOSSBAR_LOCK;
        synchronized (object) {
            BossBar bossBar;
            CompletableFuture<Void> cleanup = BOSSBAR_CLEANUPS.remove(playerId);
            if (cleanup != null) {
                cleanup.cancel(true);
            }
            if ((bossBar = ACTIVE_BOSSBARS.remove(playerId)) != null) {
                try {
                    bossBar.removePlayer(player);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                BossBar clearBar = Bukkit.createBossBar((String)"", (BarColor)BarColor.WHITE, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
                clearBar.addPlayer(player);
                clearBar.removePlayer(player);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void shutdown() {
        BOSSBAR_CLEANUPS.values().forEach(future -> future.cancel(false));
        BOSSBAR_CLEANUPS.clear();
        ACTIVE_BOSSBARS.values().forEach(bar -> {
            try {
                bar.removeAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        ACTIVE_BOSSBARS.clear();
        ASYNC_EXECUTOR.shutdown();
        try {
            if (!ASYNC_EXECUTOR.awaitTermination(2L, TimeUnit.SECONDS)) {
                ASYNC_EXECUTOR.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            ASYNC_EXECUTOR.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private static void initializeReflection() {
    }

    public static ScheduledExecutorService getAsyncExecutor() {
        return ASYNC_EXECUTOR;
    }

    public static CompletableFuture<Void> runDelayed(Runnable task, long delayMs) {
        return CompletableFuture.runAsync(() -> {
            try {
                Thread.sleep(delayMs);
                task.run();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }, ASYNC_EXECUTOR);
    }

    static {
        PacketUtils.initializeReflection();
    }
}

