/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs;

import fr.ax_dev.universejobs.action.ActionLimitManager;
import fr.ax_dev.universejobs.action.ActionProcessor;
import fr.ax_dev.universejobs.bonus.MoneyBonusManager;
import fr.ax_dev.universejobs.bonus.XpBonusManager;
import fr.ax_dev.universejobs.cache.ConfigurationCache;
import fr.ax_dev.universejobs.cache.PlayerJobCache;
import fr.ax_dev.universejobs.command.JobCommand;
import fr.ax_dev.universejobs.compatibility.FoliaCompatibilityManager;
import fr.ax_dev.universejobs.config.ConfigManager;
import fr.ax_dev.universejobs.config.LanguageManager;
import fr.ax_dev.universejobs.integration.MythicMobsHandler;
import fr.ax_dev.universejobs.job.InactivityDecayManager;
import fr.ax_dev.universejobs.job.JobManager;
import fr.ax_dev.universejobs.job.PlayerJobData;
import fr.ax_dev.universejobs.levelup.SimpleLevelUpActionManager;
import fr.ax_dev.universejobs.listener.BrewEventListener;
import fr.ax_dev.universejobs.listener.EnchantEventListener;
import fr.ax_dev.universejobs.listener.ExploreEventListener;
import fr.ax_dev.universejobs.listener.JobActionListener;
import fr.ax_dev.universejobs.listener.RepairEventListener;
import fr.ax_dev.universejobs.menu.BoostManagerGui;
import fr.ax_dev.universejobs.menu.MenuManager;
import fr.ax_dev.universejobs.placeholder.PlaceholderManager;
import fr.ax_dev.universejobs.protection.BlockProtectionManager;
import fr.ax_dev.universejobs.reward.RewardManager;
import fr.ax_dev.universejobs.reward.gui.RewardGuiManager;
import fr.ax_dev.universejobs.rewards.BatchedRewardManager;
import fr.ax_dev.universejobs.storage.DataStorage;
import fr.ax_dev.universejobs.storage.database.DatabaseDataStorage;
import fr.ax_dev.universejobs.storage.migration.DataMigrator;
import fr.ax_dev.universejobs.update.UpdateChecker;
import fr.ax_dev.universejobs.utils.AsyncXpMessageSender;
import fr.ax_dev.universejobs.utils.PluginAccessor;
import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public final class UniverseJobs
extends JavaPlugin
implements Listener {
    private static volatile UniverseJobs instance;
    private ConfigManager configManager;
    private LanguageManager languageManager;
    private FoliaCompatibilityManager foliaManager;
    private JobManager jobManager;
    private SimpleLevelUpActionManager levelUpActionManager;
    private ActionProcessor actionProcessor;
    private ActionLimitManager limitManager;
    private XpBonusManager bonusManager;
    private MoneyBonusManager moneyBonusManager;
    private AsyncXpMessageSender messageSender;
    private BlockProtectionManager protectionManager;
    private RewardManager rewardManager;
    private RewardGuiManager rewardGuiManager;
    private BatchedRewardManager batchedRewardManager;
    private MenuManager menuManager;
    private BoostManagerGui boostManagerGui;
    private PlaceholderManager placeholderManager;
    private MythicMobsHandler mythicMobsHandler;
    private BukkitTask saveTask;
    private BukkitTask dailyTask;
    private long startTime;
    private PluginAccessor accessor;
    private UpdateChecker updateChecker;
    private InactivityDecayManager inactivityDecayManager;
    private ExploreEventListener exploreEventListener;
    private DataStorage dataStorage;
    private DataMigrator dataMigrator;
    private ConfigurationCache configCache;
    private PlayerJobCache playerCache;

    public void onEnable() {
        UniverseJobs.setInstance(this);
        this.startTime = System.currentTimeMillis();
        this.configManager = new ConfigManager(this);
        this.languageManager = new LanguageManager(this);
        this.foliaManager = new FoliaCompatibilityManager(this);
        this.jobManager = new JobManager(this);
        this.levelUpActionManager = new SimpleLevelUpActionManager(this);
        this.limitManager = new ActionLimitManager(this, this.configCache);
        this.bonusManager = new XpBonusManager(this);
        this.moneyBonusManager = new MoneyBonusManager(this);
        this.messageSender = new AsyncXpMessageSender(this);
        this.protectionManager = new BlockProtectionManager(this);
        this.menuManager = new MenuManager(this);
        this.boostManagerGui = new BoostManagerGui(this);
        this.placeholderManager = new PlaceholderManager(this);
        this.mythicMobsHandler = new MythicMobsHandler(this);
        try {
            this.configManager.loadConfig();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to load configuration", e);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        try {
            this.initializeStorageSystem();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to initialize storage system", e);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        try {
            this.jobManager.loadJobs();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to load jobs", e);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.configCache = new ConfigurationCache(this);
        this.playerCache = new PlayerJobCache(this);
        try {
            this.configCache.loadAllConfigurations();
            this.playerCache.preloadOnlinePlayers();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to initialize cache system", e);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.rewardManager = new RewardManager(this);
        this.rewardGuiManager = new RewardGuiManager(this, this.rewardManager);
        this.batchedRewardManager = new BatchedRewardManager(this);
        this.actionProcessor = new ActionProcessor(this, this.jobManager, this.bonusManager, this.moneyBonusManager, this.messageSender, this.limitManager, this.configCache, this.playerCache);
        try {
            this.levelUpActionManager.loadJobActions();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to load level up actions", e);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        try {
            this.rewardManager.initialize();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to initialize reward system", e);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        JobCommand jobCommand = new JobCommand(this, this.jobManager);
        this.registerDynamicCommand(jobCommand);
        this.getServer().getPluginManager().registerEvents((Listener)new JobActionListener(this, this.actionProcessor, this.protectionManager, this.mythicMobsHandler, this.configCache, this.playerCache), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EnchantEventListener(this, this.actionProcessor), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BrewEventListener(this, this.actionProcessor), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new RepairEventListener(this, this.actionProcessor), (Plugin)this);
        this.exploreEventListener = new ExploreEventListener(this, this.actionProcessor);
        this.getServer().getPluginManager().registerEvents((Listener)this.exploreEventListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        if (this.mythicMobsHandler.isAvailable()) {
            this.getServer().getPluginManager().registerEvents((Listener)this.mythicMobsHandler, (Plugin)this);
        }
        if (this.getServer().getPluginManager().isPluginEnabled("Nexo")) {
            try {
                Class<?> nexoListenerClass = Class.forName("fr.ax_dev.universejobs.listener.NexoEventListener");
                Object nexoListener = nexoListenerClass.getConstructor(UniverseJobs.class, ActionProcessor.class, BlockProtectionManager.class).newInstance(new Object[]{this, this.actionProcessor, this.protectionManager});
                this.getServer().getPluginManager().registerEvents((Listener)nexoListener, (Plugin)this);
                this.getLogger().info("Nexo event listener registered successfully");
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to register Nexo event listener: " + e.getMessage());
            }
        }
        if (this.getServer().getPluginManager().isPluginEnabled("ItemsAdder")) {
            try {
                Class<?> itemsAdderListenerClass = Class.forName("fr.ax_dev.universejobs.listener.ItemsAdderEventListener");
                Object itemsAdderListener = itemsAdderListenerClass.getConstructor(UniverseJobs.class, ActionProcessor.class, BlockProtectionManager.class).newInstance(new Object[]{this, this.actionProcessor, this.protectionManager});
                this.getServer().getPluginManager().registerEvents((Listener)itemsAdderListener, (Plugin)this);
                this.getLogger().info("ItemsAdder event listener registered successfully");
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to register ItemsAdder event listener: " + e.getMessage());
            }
        }
        if (this.getServer().getPluginManager().isPluginEnabled("Oraxen")) {
            try {
                Class<?> oraxenListenerClass = Class.forName("fr.ax_dev.universejobs.listener.OraxenEventListener");
                Object oraxenListener = oraxenListenerClass.getConstructor(UniverseJobs.class, ActionProcessor.class, BlockProtectionManager.class).newInstance(new Object[]{this, this.actionProcessor, this.protectionManager});
                this.getServer().getPluginManager().registerEvents((Listener)oraxenListener, (Plugin)this);
                this.getLogger().info("Oraxen event listener registered successfully");
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to register Oraxen event listener: " + e.getMessage());
            }
        }
        if (this.getServer().getPluginManager().isPluginEnabled("CustomCrops")) {
            try {
                Class<?> customCropsListenerClass = Class.forName("fr.ax_dev.universejobs.listener.CustomCropsEventListener");
                Object customCropsListener = customCropsListenerClass.getConstructor(UniverseJobs.class, ActionProcessor.class, BlockProtectionManager.class).newInstance(new Object[]{this, this.actionProcessor, this.protectionManager});
                this.getServer().getPluginManager().registerEvents((Listener)customCropsListener, (Plugin)this);
                this.getLogger().info("CustomCrops event listener registered successfully");
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to register CustomCrops event listener: " + e.getMessage());
            }
        }
        if (this.getServer().getPluginManager().isPluginEnabled("CustomFishing")) {
            try {
                Class<?> customFishingListenerClass = Class.forName("fr.ax_dev.universejobs.listener.CustomFishingEventListener");
                Object customFishingListener = customFishingListenerClass.getConstructor(UniverseJobs.class, ActionProcessor.class).newInstance(new Object[]{this, this.actionProcessor});
                this.getServer().getPluginManager().registerEvents((Listener)customFishingListener, (Plugin)this);
                this.getLogger().info("CustomFishing event listener registered successfully");
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to register CustomFishing event listener: " + e.getMessage());
            }
        }
        if (this.getServer().getPluginManager().isPluginEnabled("CraftEngine")) {
            try {
                Class<?> craftEngineListenerClass = Class.forName("fr.ax_dev.universejobs.listener.CraftEngineEventListener");
                Object craftEngineListener = craftEngineListenerClass.getConstructor(UniverseJobs.class, ActionProcessor.class, BlockProtectionManager.class).newInstance(new Object[]{this, this.actionProcessor, this.protectionManager});
                this.getServer().getPluginManager().registerEvents((Listener)craftEngineListener, (Plugin)this);
                this.getLogger().info("CraftEngine event listener registered successfully");
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to register CraftEngine event listener: " + e.getMessage());
            }
        }
        for (Player player : this.getServer().getOnlinePlayers()) {
            this.foliaManager.runAsync(() -> {
                this.jobManager.loadPlayerData(player);
                this.rewardManager.loadPlayerData(player);
                this.playerCache.preloadPlayer(player.getUniqueId());
            });
        }
        try {
            this.placeholderManager.initialize();
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Failed to initialize PlaceholderAPI integration", e);
        }
        this.inactivityDecayManager = new InactivityDecayManager(this, this.jobManager);
        this.startSaveTask();
        this.startDailyTask();
        this.checkDependencies();
        this.accessor = new PluginAccessor(this);
        this.updateChecker = new UpdateChecker(this);
        this.updateChecker.checkForUpdates();
    }

    public void onDisable() {
        this.getLogger().info("Shutting down UniverseJobs plugin...");
        try {
            this.stopSaveTask();
            this.shutdownManagersExceptJobManager();
            this.getLogger().info("Saving all player data synchronously...");
            if (this.jobManager != null) {
                this.jobManager.saveAllPlayerDataSync();
            }
            this.getLogger().info("Shutting down JobManager...");
            this.shutdownJobManager();
            this.getLogger().info("Shutting down storage system...");
            this.shutdownStorageSystem();
            this.getLogger().info("UniverseJobs shutdown complete!");
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Critical error during plugin shutdown", e);
        }
        finally {
            UniverseJobs.setInstance(null);
        }
    }

    private void stopSaveTask() {
        if (this.saveTask != null && !this.saveTask.isCancelled()) {
            this.saveTask.cancel();
            this.saveTask = null;
        }
        if (this.dailyTask != null && !this.dailyTask.isCancelled()) {
            this.dailyTask.cancel();
            this.dailyTask = null;
        }
    }

    private void shutdownManagersExceptJobManager() {
        this.shutdownRewardGuiManager();
        this.shutdownManagerSilently("menu manager", this.menuManager, () -> this.menuManager.closeAllMenus());
        this.shutdownManagerSilently("reward manager", this.rewardManager, () -> this.rewardManager.shutdown());
        this.shutdownManagerSilently("batched reward manager", this.batchedRewardManager, () -> this.batchedRewardManager.shutdown());
        this.shutdownManagerSilently("message sender", this.messageSender, () -> this.messageSender.shutdown());
        this.shutdownManagerSilently("bonus manager", this.bonusManager, () -> this.bonusManager.shutdown());
        this.shutdownManagerSilently("money bonus manager", this.moneyBonusManager, () -> this.moneyBonusManager.shutdown());
        this.shutdownManagerSilently("placeholder manager", this.placeholderManager, () -> this.placeholderManager.shutdown());
        this.shutdownManagerSilently("action limit manager", this.limitManager, () -> this.limitManager.clearAllLimits());
        this.shutdownManagerSilently("Folia manager", this.foliaManager, () -> this.foliaManager.cancelAllTasks());
        this.protectionManager = null;
        this.actionProcessor = null;
        this.languageManager = null;
        this.configManager = null;
    }

    private void shutdownJobManager() {
        this.shutdownManagerSilently("job manager", this.jobManager, () -> this.jobManager.shutdown());
    }

    private void shutdownRewardGuiManager() {
        if (this.rewardGuiManager != null) {
            try {
                for (Player player : this.getServer().getOnlinePlayers()) {
                    if (player.getOpenInventory() == null) continue;
                    player.closeInventory();
                }
                this.rewardGuiManager = null;
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "Error shutting down reward GUI manager", e);
            }
        }
    }

    private void shutdownManagerSilently(String managerName, Object manager, Runnable shutdownAction) {
        if (manager != null) {
            try {
                shutdownAction.run();
                if ("job manager".equals(managerName) || "reward manager".equals(managerName)) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "Error shutting down " + managerName, e);
            }
        }
    }

    private void startSaveTask() {
        int saveInterval = this.configManager.getSaveInterval();
        if (saveInterval > 0) {
            this.foliaManager.runTimerAsync(() -> {
                if (this.configManager.isDebugEnabled()) {
                    this.getLogger().info("Auto-saving player data...");
                }
                this.jobManager.saveAllPlayerData();
            }, (long)saveInterval * 20L, (long)saveInterval * 20L);
        }
        this.foliaManager.runTimerAsync(() -> {
            if (this.actionProcessor != null) {
                this.actionProcessor.clearExpiredCaches();
            }
        }, 6000L, 6000L);
    }

    private void startDailyTask() {
        long ticksIn24Hours = 1728000L;
        long initialDelay = this.calculateInitialDelayToMidnight();
        this.foliaManager.runTimerAsync(() -> {
            if (this.configManager.isDebugEnabled()) {
                this.getLogger().info("Running daily tasks...");
            }
            if (this.inactivityDecayManager != null) {
                this.inactivityDecayManager.processInactivePlayersAsync();
            }
            if (this.limitManager != null) {
                this.limitManager.checkAndResetLimits();
            }
        }, initialDelay, ticksIn24Hours);
    }

    private long calculateInitialDelayToMidnight() {
        Calendar now = Calendar.getInstance();
        Calendar nextMidnight = Calendar.getInstance();
        nextMidnight.add(5, 1);
        nextMidnight.set(11, 0);
        nextMidnight.set(12, 0);
        nextMidnight.set(13, 0);
        nextMidnight.set(14, 0);
        long millisecondsUntilMidnight = nextMidnight.getTimeInMillis() - now.getTimeInMillis();
        return millisecondsUntilMidnight / 50L;
    }

    private void checkDependencies() {
        StringBuilder dependencyStatus = new StringBuilder("Dependency status: ");
        if (this.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            dependencyStatus.append("PlaceholderAPI \u2713 ");
        } else {
            dependencyStatus.append("PlaceholderAPI \u2717 ");
        }
        if (this.getServer().getPluginManager().isPluginEnabled("MythicMobs")) {
            dependencyStatus.append("MythicMobs \u2713 ");
        } else {
            dependencyStatus.append("MythicMobs \u2717 ");
        }
        if (this.getServer().getPluginManager().isPluginEnabled("MMOItems")) {
            dependencyStatus.append("MMOItems \u2713 ");
        } else {
            dependencyStatus.append("MMOItems \u2717 ");
        }
        if (this.getServer().getPluginManager().isPluginEnabled("Nexo")) {
            dependencyStatus.append("Nexo \u2713 ");
        } else {
            dependencyStatus.append("Nexo \u2717 ");
        }
        if (this.getServer().getPluginManager().isPluginEnabled("ItemsAdder")) {
            dependencyStatus.append("ItemsAdder \u2713 ");
        } else {
            dependencyStatus.append("ItemsAdder \u2717 ");
        }
        if (this.getServer().getPluginManager().isPluginEnabled("CustomCrops")) {
            dependencyStatus.append("CustomCrops \u2713 ");
        } else {
            dependencyStatus.append("CustomCrops \u2717 ");
        }
        if (this.getServer().getPluginManager().isPluginEnabled("CustomFishing")) {
            dependencyStatus.append("CustomFishing \u2713");
        } else {
            dependencyStatus.append("CustomFishing \u2717");
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.foliaManager.runAsync(() -> {
            this.jobManager.loadPlayerData(event.getPlayer());
            this.rewardManager.loadPlayerData(event.getPlayer());
            this.playerCache.preloadPlayer(event.getPlayer().getUniqueId());
            if (this.inactivityDecayManager != null) {
                this.inactivityDecayManager.updatePlayerActivity(event.getPlayer().getUniqueId());
            }
            if (this.configCache.isDebugEnabled()) {
                this.getLogger().info("Loaded data and preloaded cache for player: " + event.getPlayer().getName());
            }
        });
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        PlayerJobData playerData;
        if (this.messageSender != null) {
            this.messageSender.cleanupPlayer(event.getPlayer());
        }
        if ((playerData = this.jobManager.getPlayerData(event.getPlayer().getUniqueId())) != null) {
            playerData.clearPermissionCache();
        }
        this.playerCache.cleanupPlayer(event.getPlayer().getUniqueId());
        this.foliaManager.runAsync(() -> {
            this.jobManager.savePlayerData(event.getPlayer());
            this.rewardManager.unloadPlayerData(event.getPlayer());
            if (this.configCache.isDebugEnabled()) {
                this.getLogger().info("Saved data for player: " + event.getPlayer().getName());
            }
        });
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public FoliaCompatibilityManager getFoliaManager() {
        return this.foliaManager;
    }

    public JobManager getJobManager() {
        return this.jobManager;
    }

    public ActionProcessor getActionProcessor() {
        return this.actionProcessor;
    }

    public XpBonusManager getBonusManager() {
        return this.bonusManager;
    }

    public MoneyBonusManager getMoneyBonusManager() {
        return this.moneyBonusManager;
    }

    public AsyncXpMessageSender getMessageSender() {
        return this.messageSender;
    }

    public AsyncXpMessageSender getXpMessageSender() {
        return this.messageSender;
    }

    public BlockProtectionManager getProtectionManager() {
        return this.protectionManager;
    }

    public RewardManager getRewardManager() {
        return this.rewardManager;
    }

    public RewardGuiManager getRewardGuiManager() {
        return this.rewardGuiManager;
    }

    public BatchedRewardManager getBatchedRewardManager() {
        return this.batchedRewardManager;
    }

    public MenuManager getMenuManager() {
        return this.menuManager;
    }

    public BoostManagerGui getBoostManagerGui() {
        return this.boostManagerGui;
    }

    public ConfigurationCache getConfigCache() {
        return this.configCache;
    }

    public PlayerJobCache getPlayerCache() {
        return this.playerCache;
    }

    public PlaceholderManager getPlaceholderManager() {
        return this.placeholderManager;
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    public MythicMobsHandler getMythicMobsHandler() {
        return this.mythicMobsHandler;
    }

    public ActionLimitManager getLimitManager() {
        return this.limitManager;
    }

    public SimpleLevelUpActionManager getLevelUpActionManager() {
        return this.levelUpActionManager;
    }

    private void registerDynamicCommand(final JobCommand jobCommand) {
        String commandName = this.getConfig().getString("main-command", "jobs");
        try {
            Field commandMapField = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            CommandMap commandMap = (CommandMap)commandMapField.get(Bukkit.getServer());
            BukkitCommand command = new BukkitCommand(this, commandName){

                public boolean execute(CommandSender sender, String label, String[] args) {
                    return jobCommand.onCommand(sender, (Command)this, label, args);
                }

                public List<String> tabComplete(CommandSender sender, String alias, String[] args) {
                    return jobCommand.onTabComplete(sender, (Command)this, alias, args);
                }
            };
            command.setDescription("Main jobs command with rewards, XP bonus management, and action limits");
            command.setUsage("/" + commandName + " <join|leave|info|list|rewards|actionlimit> [args...]");
            command.setPermission("universejobs.use");
            commandMap.register("universejobs", (Command)command);
            this.getLogger().info("Registered command: /" + commandName);
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to register dynamic command: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static synchronized UniverseJobs getInstance() {
        return instance;
    }

    public PluginAccessor getAccessor() {
        return this.accessor;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Object getPerformanceManager() {
        return null;
    }

    private void initializeStorageSystem() {
        boolean databaseEnabled;
        String databaseType = this.getConfig().getString("database.type", "");
        boolean bl = databaseEnabled = !databaseType.isEmpty() && (databaseType.equals("sqlite") || databaseType.equals("mysql"));
        if (databaseEnabled) {
            this.getLogger().info("Initializing database storage system...");
            DatabaseDataStorage databaseStorage = new DatabaseDataStorage(this);
            try {
                databaseStorage.initializeAsync().join();
                this.dataStorage = databaseStorage;
                this.dataMigrator = new DataMigrator(this, databaseStorage);
                if (this.dataMigrator.shouldMigrate()) {
                    this.getLogger().info("Legacy YML data detected - starting migration process...");
                    DataMigrator.MigrationResult result = this.dataMigrator.migrateAllData().join();
                    if (result.isSuccessful()) {
                        this.getLogger().info("Data migration completed successfully!");
                        this.getLogger().info("Total records migrated: " + result.getTotalMigrated());
                        this.dataMigrator.markMigrationComplete();
                    } else {
                        this.getLogger().severe("Data migration failed: " + result.error);
                        throw new RuntimeException("Migration failed: " + result.error);
                    }
                }
                this.getLogger().info("Database storage system initialized successfully");
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to initialize database storage", e);
                throw new RuntimeException("Database initialization failed", e);
            }
        } else {
            this.getLogger().info("Using file-based storage system");
            this.dataStorage = null;
        }
    }

    private void shutdownStorageSystem() {
        if (this.dataStorage != null) {
            try {
                this.dataStorage.shutdownAsync().join();
                this.getLogger().info("Storage system shut down successfully");
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "Error shutting down storage system", e);
            }
        }
    }

    public DataStorage getDataStorage() {
        return this.dataStorage;
    }

    public boolean isDatabaseEnabled() {
        return this.dataStorage != null;
    }

    private static synchronized void setInstance(UniverseJobs newInstance) {
        instance = newInstance;
    }
}

