/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.condition.impl;

import fr.ax_dev.universejobs.condition.AbstractCondition;
import fr.ax_dev.universejobs.condition.ConditionContext;
import fr.ax_dev.universejobs.condition.ConditionType;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class TimeCondition
extends AbstractCondition {
    private final long minTime;
    private final long maxTime;

    public TimeCondition(ConfigurationSection config) {
        super(config);
        this.minTime = config.getLong("min", 0L);
        this.maxTime = config.getLong("max", 24000L);
    }

    @Override
    public boolean isMet(Player player, Event event, ConditionContext context) {
        long worldTime = player.getWorld().getTime();
        if (this.minTime <= this.maxTime) {
            return worldTime >= this.minTime && worldTime <= this.maxTime;
        }
        return worldTime >= this.minTime || worldTime <= this.maxTime;
    }

    @Override
    public ConditionType getType() {
        return ConditionType.TIME;
    }

    public String toString() {
        return "TimeCondition{minTime=" + this.minTime + ", maxTime=" + this.maxTime + "}";
    }
}

