/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.condition.impl;

import fr.ax_dev.universejobs.condition.AbstractCondition;
import fr.ax_dev.universejobs.condition.ConditionContext;
import fr.ax_dev.universejobs.condition.ConditionType;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class WorldCondition
extends AbstractCondition {
    private final List<String> allowedWorlds;
    private final boolean blacklist;

    public WorldCondition(ConfigurationSection config) {
        super(config);
        this.allowedWorlds = config.getStringList("worlds");
        this.blacklist = config.getBoolean("blacklist", false);
    }

    @Override
    public boolean isMet(Player player, Event event, ConditionContext context) {
        String playerWorld = player.getWorld().getName();
        boolean inList = this.allowedWorlds.contains(playerWorld);
        return this.blacklist ? !inList : inList;
    }

    @Override
    public ConditionType getType() {
        return ConditionType.WORLD;
    }

    public String toString() {
        return "WorldCondition{worlds=" + this.allowedWorlds.size() + ", blacklist=" + this.blacklist + "}";
    }
}

