/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.job;

import fr.ax_dev.universejobs.action.ActionType;
import fr.ax_dev.universejobs.action.JobAction;
import fr.ax_dev.universejobs.integration.McMMOHandler;
import fr.ax_dev.universejobs.job.XpMessageSettings;
import fr.ax_dev.universejobs.xp.XpCurve;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;

public class Job {
    private static final String XP_TYPE_CURVE = "CURVE";
    private final String id;
    private final String name;
    private final List<String> description;
    private final List<String> lore;
    private final String permission;
    private final int maxLevel;
    private final Map<ActionType, List<JobAction>> actions;
    private final String iconMaterial;
    private final int customModelData;
    private final String iconTexture;
    private final boolean enabled;
    private final String xpType;
    private final String xpValue;
    private XpCurve xpCurve;
    private boolean xpCurveError = false;
    private String xpCurveErrorMessage;
    private final XpMessageSettings xpMessageSettings;
    private final String guiReward;
    private final String rewardsFile;
    private final ConfigurationSection config;
    private final Map<String, McMMOHandler.McMMOAbilityConfig> mcmmoConfig;

    public Job(String id, ConfigurationSection config) {
        String descString;
        this.id = id;
        this.config = config;
        this.name = config.getString("name", id);
        this.description = config.isList("description") ? config.getStringList("description") : ((descString = config.getString("description", "")).isEmpty() ? new ArrayList<String>() : Arrays.asList(descString));
        this.lore = config.getStringList("lore");
        this.permission = config.getString("permission", "universejobs.job." + id.toLowerCase());
        this.maxLevel = config.getInt("max-level", 100);
        ConfigurationSection iconSection = config.getConfigurationSection("icon");
        if (iconSection != null) {
            this.iconMaterial = iconSection.getString("material", "STONE");
            this.iconTexture = iconSection.getString("player-head", null);
            String customModelStr = iconSection.getString("custom-model-data", "");
            this.customModelData = customModelStr.isEmpty() ? 0 : Integer.parseInt(customModelStr.replaceAll("[^0-9]", "0"));
        } else {
            this.iconMaterial = config.getString("icon", "STONE");
            this.customModelData = 0;
            this.iconTexture = null;
        }
        this.enabled = config.getBoolean("enabled", true);
        ConfigurationSection xpSection = config.getConfigurationSection("xp");
        if (xpSection != null) {
            this.xpType = xpSection.getString("type", XP_TYPE_CURVE);
            this.xpValue = xpSection.getString("xp");
            this.xpMessageSettings = new XpMessageSettings(xpSection.getConfigurationSection("message"));
        } else {
            if (config.contains("xp-equation")) {
                this.xpType = "EQUATION";
                this.xpValue = config.getString("xp-equation");
            } else {
                this.xpType = XP_TYPE_CURVE;
                this.xpValue = config.getString("xp-curve", "default");
            }
            this.xpMessageSettings = new XpMessageSettings(config.getConfigurationSection("xp-message"));
        }
        this.xpCurve = null;
        this.guiReward = config.getString("gui-reward");
        this.rewardsFile = config.getString("rewards");
        this.mcmmoConfig = this.loadMcMMOConfig(config.getConfigurationSection("mcmmo"));
        this.actions = new EnumMap<ActionType, List<JobAction>>(ActionType.class);
        this.loadActions(config.getConfigurationSection("actions"));
    }

    private Map<String, McMMOHandler.McMMOAbilityConfig> loadMcMMOConfig(ConfigurationSection mcmmoSection) {
        HashMap<String, McMMOHandler.McMMOAbilityConfig> configMap = new HashMap<String, McMMOHandler.McMMOAbilityConfig>();
        if (mcmmoSection == null) {
            return configMap;
        }
        for (String abilityName : mcmmoSection.getKeys(false)) {
            ConfigurationSection abilitySection = mcmmoSection.getConfigurationSection(abilityName);
            if (abilitySection == null) continue;
            double moneyAmplifier = abilitySection.getDouble("money-amplifier", 1.0);
            double xpAmplifier = abilitySection.getDouble("xp-amplifier", 1.0);
            configMap.put(abilityName.toLowerCase(), new McMMOHandler.McMMOAbilityConfig(moneyAmplifier, xpAmplifier));
        }
        return configMap;
    }

    private void loadActions(ConfigurationSection actionsSection) {
        if (actionsSection == null) {
            return;
        }
        for (String actionTypeStr : actionsSection.getKeys(false)) {
            ConfigurationSection actionSection;
            ActionType actionType = ActionType.fromString(actionTypeStr);
            if (actionType == null || (actionSection = actionsSection.getConfigurationSection(actionTypeStr)) == null) continue;
            ArrayList<JobAction> jobActions = new ArrayList<JobAction>();
            if (actionSection.contains("target")) {
                jobActions.add(new JobAction(actionSection));
            } else {
                for (String actionKey : actionSection.getKeys(false)) {
                    ConfigurationSection singleActionSection = actionSection.getConfigurationSection(actionKey);
                    if (singleActionSection == null) continue;
                    jobActions.add(new JobAction(singleActionSection));
                }
            }
            this.actions.put(actionType, jobActions);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return String.join((CharSequence)" ", this.description);
    }

    public List<String> getDescriptionLines() {
        return new ArrayList<String>(this.description);
    }

    public List<String> getLore() {
        return new ArrayList<String>(this.lore);
    }

    public String getPermission() {
        return this.permission;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public String getIconMaterial() {
        return this.iconMaterial;
    }

    public int getCustomModelData() {
        return this.customModelData;
    }

    public String getIconTexture() {
        return this.iconTexture;
    }

    public boolean hasIconTexture() {
        return this.iconTexture != null && !this.iconTexture.isEmpty();
    }

    @Deprecated
    public String getIcon() {
        return this.iconMaterial;
    }

    public boolean isEnabled() {
        return this.enabled && !this.xpCurveError;
    }

    public boolean isEnabledInConfig() {
        return this.enabled;
    }

    public List<JobAction> getActions(ActionType actionType) {
        return this.actions.getOrDefault((Object)actionType, new ArrayList());
    }

    public Set<ActionType> getActionTypes() {
        return this.actions.keySet();
    }

    public Map<ActionType, List<JobAction>> getActions() {
        return new HashMap<ActionType, List<JobAction>>(this.actions);
    }

    public Map<String, McMMOHandler.McMMOAbilityConfig> getMcmmoConfig() {
        return this.mcmmoConfig;
    }

    public boolean hasActions(ActionType actionType) {
        List<JobAction> jobActions = this.actions.get((Object)actionType);
        return jobActions != null && !jobActions.isEmpty();
    }

    public String getXpType() {
        return this.xpType;
    }

    public String getXpValue() {
        return this.xpValue;
    }

    public String getXpCurveName() {
        return XP_TYPE_CURVE.equals(this.xpType) ? this.xpValue : null;
    }

    public String getXpEquation() {
        return "EQUATION".equals(this.xpType) ? this.xpValue : null;
    }

    public XpCurve getXpCurve() {
        return this.xpCurve;
    }

    public void setXpCurve(XpCurve xpCurve) {
        this.xpCurve = xpCurve;
    }

    public boolean hasCustomXpCurve() {
        return this.xpValue != null;
    }

    public boolean hasXpCurveError() {
        return this.xpCurveError;
    }

    public String getXpCurveErrorMessage() {
        return this.xpCurveErrorMessage;
    }

    public void setXpCurveError(boolean error, String message) {
        this.xpCurveError = error;
        this.xpCurveErrorMessage = message;
    }

    public XpMessageSettings getXpMessageSettings() {
        return this.xpMessageSettings;
    }

    public String getGuiReward() {
        return this.guiReward;
    }

    public String getRewardsFile() {
        return this.rewardsFile;
    }

    public ActionType getActionTypeForAction(JobAction jobAction) {
        for (Map.Entry<ActionType, List<JobAction>> entry : this.actions.entrySet()) {
            if (!entry.getValue().contains(jobAction)) continue;
            return entry.getKey();
        }
        return null;
    }

    public String getDisplayName() {
        return this.name;
    }

    public double getXpForLevel(int level) {
        if (this.xpCurve != null) {
            return this.xpCurve.getXpForLevel(level);
        }
        return 0.0;
    }

    public int getLevelFromXp(double xp) {
        if (this.xpCurve != null) {
            return this.xpCurve.getLevelFromXp(xp);
        }
        return 1;
    }

    public ConfigurationSection getConfig() {
        return this.config;
    }

    public boolean isAutoRestoreEnabled() {
        return this.config.getBoolean("action-limits.auto-restore.enabled", false);
    }

    public String getAutoRestoreTime() {
        if (!this.isAutoRestoreEnabled()) {
            return null;
        }
        return this.config.getString("action-limits.auto-restore.time", "00:00");
    }

    public String toString() {
        return "Job{id='" + this.id + "', name='" + this.name + "', enabled=" + this.enabled + ", xpType='" + this.xpType + "', xpValue='" + (this.xpValue != null ? this.xpValue : "default") + "'}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Job job = (Job)obj;
        return Objects.equals(this.id, job.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

