/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.job;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.action.ActionLimitManager;
import fr.ax_dev.universejobs.config.ConfigManager;
import fr.ax_dev.universejobs.job.Job;
import fr.ax_dev.universejobs.job.PlayerJobData;
import fr.ax_dev.universejobs.storage.DataStorage;
import fr.ax_dev.universejobs.storage.database.DatabaseDataStorage;
import fr.ax_dev.universejobs.xp.XpCurve;
import fr.ax_dev.universejobs.xp.XpCurveManager;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class JobManager {
    private final UniverseJobs plugin;
    private final Map<String, Job> jobs = new ConcurrentHashMap<String, Job>();
    private final Map<UUID, PlayerJobData> playerData = new ConcurrentHashMap<UUID, PlayerJobData>();
    private final File jobsFolder;
    private final File dataFolder;
    private XpCurveManager xpCurveManager;
    private final ReadWriteLock dataLock = new ReentrantReadWriteLock();
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);
    private final Set<WeakReference<PlayerJobData>> trackedPlayerData = ConcurrentHashMap.newKeySet();
    private volatile long lastCleanupTime = System.currentTimeMillis();
    private static final long CLEANUP_INTERVAL = 300000L;
    private static final int MAX_CACHED_PLAYERS = 1000;
    private static final Map<String, LeaderboardBatchData> LEADERBOARD_BATCH = new ConcurrentHashMap<String, LeaderboardBatchData>();
    private static final long LEADERBOARD_BATCH_INTERVAL = 10000L;
    private static long lastLeaderboardUpdate = 0L;

    public JobManager(UniverseJobs plugin) {
        this.plugin = plugin;
        this.jobsFolder = new File(plugin.getDataFolder(), "jobs");
        this.dataFolder = new File(plugin.getDataFolder(), "data");
        if (!this.jobsFolder.exists()) {
            this.jobsFolder.mkdirs();
        }
        this.xpCurveManager = new XpCurveManager(plugin);
    }

    public void loadJobs() {
        File[] jobFiles;
        this.isShutdown.set(false);
        this.jobs.clear();
        if (!this.jobsFolder.exists()) {
            this.plugin.getLogger().warning("Jobs folder does not exist, creating it...");
            this.jobsFolder.mkdirs();
        }
        if ((jobFiles = this.jobsFolder.listFiles((dir, name) -> name.endsWith(".yml"))) == null || jobFiles.length == 0) {
            this.plugin.getLogger().info("Jobs folder is empty, creating default job files...");
            this.createDefaultJobs();
            jobFiles = this.jobsFolder.listFiles((dir, name) -> name.endsWith(".yml"));
            if (jobFiles == null || jobFiles.length == 0) {
                this.plugin.getLogger().warning("Failed to create default job files. Check plugin resources.");
                return;
            }
        }
        for (File jobFile : jobFiles) {
            try {
                String jobId = jobFile.getName().replace(".yml", "");
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)jobFile);
                Job job = new Job(jobId, (ConfigurationSection)config);
                if (!job.isEnabledInConfig()) continue;
                this.setupJobXpCurve(job);
                if (job.isEnabled()) {
                    this.jobs.put(jobId, job);
                    if (!job.isAutoRestoreEnabled()) continue;
                    ActionLimitManager limitManager = this.plugin.getLimitManager();
                    limitManager.setAutoRestoreConfig(jobId, true, job.getAutoRestoreTime());
                    continue;
                }
                this.plugin.getLogger().severe("Job " + jobId + " is disabled due to XP curve error: " + job.getXpCurveErrorMessage());
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to load job file: " + jobFile.getName(), e);
            }
        }
        if (!this.jobs.isEmpty()) {
            this.plugin.getFoliaManager().runLater(() -> this.cleanupInvalidJobs(), 20L);
        }
    }

    public Job getJob(String jobId) {
        return this.jobs.get(jobId);
    }

    public Collection<Job> getAllJobs() {
        return new ArrayList<Job>(this.jobs.values());
    }

    public Collection<Job> getEnabledJobs() {
        return this.jobs.values().stream().filter(Job::isEnabled).toList();
    }

    public boolean hasJob(String jobId) {
        return this.jobs.containsKey(jobId);
    }

    public PlayerJobData getPlayerData(Player player) {
        return this.getPlayerData(player.getUniqueId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlayerJobData getPlayerData(UUID playerUuid) {
        PlayerJobData existingData;
        if (this.isShutdown.get()) {
            throw new IllegalStateException("JobManager is shutdown");
        }
        this.checkAndPerformCleanup();
        this.dataLock.readLock().lock();
        try {
            existingData = this.playerData.get(playerUuid);
            if (existingData != null) {
                PlayerJobData playerJobData = existingData;
                return playerJobData;
            }
        }
        finally {
            this.dataLock.readLock().unlock();
        }
        this.dataLock.writeLock().lock();
        try {
            existingData = this.playerData.get(playerUuid);
            if (existingData != null) {
                PlayerJobData playerJobData = existingData;
                return playerJobData;
            }
            PlayerJobData data = new PlayerJobData(playerUuid);
            data.setJobManager(this);
            this.playerData.put(playerUuid, data);
            this.trackPlayerData(data);
            PlayerJobData playerJobData = data;
            return playerJobData;
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    public boolean joinJob(Player player, String jobId) {
        Job job = this.getJob(jobId);
        if (job == null || !job.isEnabled()) {
            return false;
        }
        if (job.getPermission() != null && !player.hasPermission(job.getPermission())) {
            return false;
        }
        return this.joinJob(player.getUniqueId(), jobId);
    }

    public boolean leaveJob(Player player, String jobId) {
        return this.leaveJob(player.getUniqueId(), jobId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean joinJob(UUID playerUuid, String jobId) {
        PlayerJobData data;
        if (this.isShutdown.get()) {
            return false;
        }
        Job job = this.getJob(jobId);
        if (job == null || !job.isEnabled()) {
            return false;
        }
        PlayerJobData playerJobData = data = this.getPlayerData(playerUuid);
        synchronized (playerJobData) {
            boolean result = data.joinJob(jobId);
            if (result) {
                this.updateLeaderboardCache(playerUuid, jobId, data);
                this.plugin.getPlayerCache().addPlayerJob(playerUuid, jobId);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean leaveJob(UUID playerUuid, String jobId) {
        PlayerJobData data;
        if (this.isShutdown.get()) {
            return false;
        }
        if (this.plugin.getConfigManager().isDefaultJob(jobId)) {
            return false;
        }
        PlayerJobData playerJobData = data = this.getPlayerData(playerUuid);
        synchronized (playerJobData) {
            boolean result = data.leaveJob(jobId);
            if (result) {
                this.applyLeavePenalty(data, jobId);
                this.updateLeaderboardCache(playerUuid, jobId, data);
                this.plugin.getPlayerCache().removePlayerJob(playerUuid, jobId);
            }
            return result;
        }
    }

    public boolean hasJob(Player player, String jobId) {
        PlayerJobData data = this.getPlayerData(player);
        return data.hasJob(jobId);
    }

    public Set<String> getPlayerJobs(Player player) {
        PlayerJobData data = this.getPlayerData(player);
        return data.getJobs();
    }

    public Map<String, Job> getJobs() {
        return new HashMap<String, Job>(this.jobs);
    }

    public Map<UUID, PlayerJobData> getAllPlayerData() {
        this.dataLock.readLock().lock();
        try {
            HashMap<UUID, PlayerJobData> hashMap = new HashMap<UUID, PlayerJobData>(this.playerData);
            return hashMap;
        }
        finally {
            this.dataLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addXp(Player player, String jobId, double xp) {
        PlayerJobData data;
        if (this.isShutdown.get()) {
            return;
        }
        if (Double.isNaN(xp) || Double.isInfinite(xp) || xp < -1000000.0 || xp > 1000000.0) {
            this.plugin.getLogger().warning("Invalid XP amount attempted for player " + player.getName() + ": " + xp);
            return;
        }
        PlayerJobData playerJobData = data = this.getPlayerData(player);
        synchronized (playerJobData) {
            data.addXp(jobId, xp);
            this.updateLeaderboardCache(player.getUniqueId(), jobId, data);
            this.plugin.getPlayerCache().preloadPlayer(player.getUniqueId());
        }
    }

    public double getXp(Player player, String jobId) {
        PlayerJobData data = this.getPlayerData(player);
        return data.getXp(jobId);
    }

    public int getLevel(Player player, String jobId) {
        PlayerJobData data = this.getPlayerData(player);
        Job job = this.getJob(jobId);
        if (job != null && job.getXpCurve() != null) {
            double xp = data.getXp(jobId);
            return job.getXpCurve().getLevelForXp(xp, job.getMaxLevel());
        }
        return data.getLevel(jobId);
    }

    public double getXpRequiredForLevel(String jobId, int level) {
        Job job = this.getJob(jobId);
        if (job != null && job.getXpCurve() != null) {
            return job.getXpCurve().getXpForLevel(level);
        }
        return (double)level * 1000.0;
    }

    public double getXpToNextLevel(Player player, String jobId) {
        Job job = this.getJob(jobId);
        if (job != null && job.getXpCurve() != null) {
            int currentLevel = this.getLevel(player, jobId);
            double currentXp = this.getXp(player, jobId);
            double nextLevelXp = job.getXpCurve().getXpForLevel(currentLevel + 1);
            return Math.max(0.0, nextLevelXp - currentXp);
        }
        return 1000.0;
    }

    public void savePlayerData(Player player) {
        this.savePlayerData(player.getUniqueId());
    }

    public void savePlayerData(UUID playerUuid) {
        PlayerJobData data;
        if (this.isShutdown.get()) {
            this.plugin.getLogger().warning("Attempted to save player data after JobManager shutdown: " + String.valueOf(playerUuid));
            return;
        }
        this.dataLock.readLock().lock();
        try {
            data = this.playerData.get(playerUuid);
        }
        finally {
            this.dataLock.readLock().unlock();
        }
        if (data == null) {
            return;
        }
        this.savePlayerDataInternal(playerUuid, data);
    }

    public void loadPlayerData(Player player) {
        this.loadPlayerData(player.getUniqueId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPlayerData(UUID playerUuid) {
        if (this.isShutdown.get()) {
            this.plugin.getLogger().warning("Attempted to load player data after JobManager shutdown: " + String.valueOf(playerUuid));
            return;
        }
        this.dataLock.readLock().lock();
        try {
            if (this.playerData.containsKey(playerUuid)) {
                return;
            }
        }
        finally {
            this.dataLock.readLock().unlock();
        }
        try {
            PlayerJobData data;
            if (this.plugin.isDatabaseEnabled()) {
                DataStorage dataStorage = this.plugin.getDataStorage();
                data = dataStorage.loadPlayerDataAsync(playerUuid).join();
            } else {
                File dataFile = new File(this.dataFolder, playerUuid.toString() + ".yml");
                if (!dataFile.exists()) {
                    data = new PlayerJobData(playerUuid);
                } else {
                    YamlConfiguration config = YamlConfiguration.loadConfiguration((File)dataFile);
                    data = new PlayerJobData(playerUuid);
                    data.load((FileConfiguration)config);
                }
            }
            data.setJobManager(this);
            this.assignDefaultJobs(data);
            this.dataLock.writeLock().lock();
            try {
                this.playerData.put(playerUuid, data);
                this.trackPlayerData(data);
            }
            finally {
                this.dataLock.writeLock().unlock();
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to load player data for " + String.valueOf(playerUuid), e);
            PlayerJobData fallbackData = new PlayerJobData(playerUuid);
            fallbackData.setJobManager(this);
            this.assignDefaultJobs(fallbackData);
            this.dataLock.writeLock().lock();
            try {
                this.playerData.put(playerUuid, fallbackData);
                this.trackPlayerData(fallbackData);
            }
            finally {
                this.dataLock.writeLock().unlock();
            }
        }
    }

    private void assignDefaultJobs(PlayerJobData data) {
        ConfigManager config = this.plugin.getConfigManager();
        if (config.isAllJobsByDefault()) {
            for (Job job : this.jobs.values()) {
                if (!job.isEnabled() || data.hasJob(job.getId())) continue;
                data.joinJob(job.getId());
            }
        } else {
            List<String> defaultJobs = config.getJobsByDefault();
            for (String jobId : defaultJobs) {
                Job job = this.getJob(jobId);
                if (job == null || !job.isEnabled() || data.hasJob(jobId)) continue;
                data.joinJob(jobId);
            }
        }
    }

    private void createDefaultJobs() {
        String[] defaultJobs;
        for (String jobFile : defaultJobs = new String[]{"miner.yml", "farmer.yml", "hunter.yml", "lumberjack.yml"}) {
            try {
                this.plugin.saveResource("jobs/" + jobFile, false);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Could not create job file " + jobFile + ": " + e.getMessage());
            }
        }
    }

    public void saveAllPlayerData() {
        for (UUID playerUuid : this.playerData.keySet()) {
            this.savePlayerData(playerUuid);
        }
    }

    public void reloadJobs() {
        this.xpCurveManager.reload();
        this.loadJobs();
        this.cleanupInvalidJobs();
    }

    public void cleanupInvalidJobs() {
        this.plugin.getFoliaManager().runAsync(() -> {
            AtomicInteger cleanedPlayers = new AtomicInteger(0);
            AtomicInteger removedJobs = new AtomicInteger(0);
            try {
                Set<String> validJobIds = this.jobs.keySet();
                this.dataLock.readLock().lock();
                ArrayList<UUID> playersToCheck = new ArrayList<UUID>(this.playerData.keySet());
                this.dataLock.readLock().unlock();
                for (UUID playerUuid : playersToCheck) {
                    PlayerJobData data = this.playerData.get(playerUuid);
                    if (data == null) continue;
                    HashSet<String> playerJobs = new HashSet<String>(data.getJobs());
                    boolean hasInvalidJobs = false;
                    for (String jobId : playerJobs) {
                        if (validJobIds.contains(jobId)) continue;
                        data.leaveJob(jobId);
                        hasInvalidJobs = true;
                        removedJobs.incrementAndGet();
                        this.plugin.getLogger().info("Removed invalid job '" + jobId + "' from player " + String.valueOf(playerUuid) + " (job no longer exists after reload)");
                    }
                    if (!hasInvalidJobs) continue;
                    cleanedPlayers.incrementAndGet();
                    this.savePlayerData(playerUuid);
                }
                File[] playerFiles = this.dataFolder.listFiles((dir, name) -> name.endsWith(".yml"));
                if (playerFiles != null) {
                    for (File file : playerFiles) {
                        try {
                            String fileName = file.getName();
                            String uuidString = fileName.substring(0, fileName.length() - 4);
                            UUID playerUuid = UUID.fromString(uuidString);
                            if (this.playerData.containsKey(playerUuid)) continue;
                            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                            List jobsList = config.getStringList("jobs");
                            ArrayList<String> validJobs = new ArrayList<String>();
                            boolean hasInvalidJobs = false;
                            for (String jobId : jobsList) {
                                if (validJobIds.contains(jobId)) {
                                    validJobs.add(jobId);
                                    continue;
                                }
                                hasInvalidJobs = true;
                                removedJobs.incrementAndGet();
                                config.set("xp." + jobId, null);
                                config.set("levels." + jobId, null);
                                this.plugin.getLogger().info("Removed invalid job '" + jobId + "' from offline player " + String.valueOf(playerUuid) + " (job no longer exists after reload)");
                            }
                            if (!hasInvalidJobs) continue;
                            cleanedPlayers.incrementAndGet();
                            config.set("jobs", validJobs);
                            config.save(file);
                        }
                        catch (Exception e) {
                            this.plugin.getLogger().warning("Error cleaning player data file " + file.getName() + ": " + e.getMessage());
                        }
                    }
                }
                if (cleanedPlayers.get() > 0 && this.plugin.getPlayerCache() != null) {
                    this.plugin.getFoliaManager().runNextTick(() -> {
                        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                            this.plugin.getPlayerCache().cleanupPlayer(onlinePlayer.getUniqueId());
                            this.plugin.getPlayerCache().preloadPlayer(onlinePlayer.getUniqueId());
                        }
                        if (removedJobs.get() > 0) {
                            this.plugin.getLogger().info("Startup cleanup completed: " + cleanedPlayers.get() + " players cleaned, " + removedJobs.get() + " invalid jobs removed, cache refreshed");
                        } else {
                            this.plugin.getLogger().info("Startup cleanup completed: all player data is clean");
                        }
                    });
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Error during job cleanup: " + e.getMessage());
            }
        });
    }

    private void setupJobXpCurve(Job job) {
        block7: {
            try {
                XpCurve curve = job.getXpEquation() != null ? this.xpCurveManager.getCurveFromEquation(job.getXpEquation()) : (job.getXpCurveName() != null ? this.xpCurveManager.getCurve(job.getXpCurveName()) : this.xpCurveManager.getDefaultCurve());
                job.setXpCurve(curve);
                try {
                    double testXp1 = curve.getXpForLevel(1);
                    double testXp10 = curve.getXpForLevel(10);
                    double testXp50 = curve.getXpForLevel(50);
                    if (Double.isNaN(testXp1) || Double.isInfinite(testXp1) || Double.isNaN(testXp10) || Double.isInfinite(testXp10) || Double.isNaN(testXp50) || Double.isInfinite(testXp50)) {
                        throw new RuntimeException("XP curve returned invalid values (NaN or Infinite)");
                    }
                    if (testXp1 < 0.0 || testXp10 < 0.0 || testXp50 < 0.0) {
                        throw new RuntimeException("XP curve returned negative values");
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("XP curve validation failed: " + e.getMessage(), e);
                }
            }
            catch (Exception e) {
                String errorMessage = "XP curve setup failed: " + e.getMessage();
                job.setXpCurveError(true, errorMessage);
                this.plugin.getLogger().severe("Job " + job.getId() + " disabled - " + errorMessage);
                if (job.getXpEquation() != null) {
                    this.plugin.getLogger().severe("Check your XP equation syntax: " + job.getXpEquation());
                    this.plugin.getLogger().severe("Supported functions: Math.pow, Math.sqrt, Math.floor, Math.ceil");
                    this.plugin.getLogger().severe("Example: 100 * Math.pow(level, 2)");
                }
                if (job.getXpCurveName() == null) break block7;
                this.plugin.getLogger().severe("Check if XP curve file exists: xp-curves/" + job.getXpCurveName() + ".yml");
            }
        }
    }

    public XpCurveManager getXpCurveManager() {
        return this.xpCurveManager;
    }

    private void applyLeavePenalty(PlayerJobData data, String jobId) {
        double currentXp;
        if (!this.plugin.getConfigManager().isLeavePenaltyEnabled()) {
            return;
        }
        String penaltyType = this.plugin.getConfigManager().getLeavePenaltyType(jobId);
        double penaltyPercentage = this.plugin.getConfigManager().getLeavePenaltyPercentage(jobId);
        if (penaltyPercentage <= 0.0 || penaltyPercentage > 1.0) {
            return;
        }
        if ("level".equalsIgnoreCase(penaltyType)) {
            int currentLevel = data.getLevel(jobId);
            if (currentLevel > 1) {
                int levelsToLose = Math.max(1, (int)Math.floor((double)currentLevel * penaltyPercentage));
                int newLevel = Math.max(1, currentLevel - levelsToLose);
                data.setLevel(jobId, newLevel);
                data.setXp(jobId, 0.0);
                UUID playerUuid = data.getPlayerUuid();
                if (playerUuid != null) {
                    this.plugin.getPlayerCache().updatePlayerXp(playerUuid, jobId, 0.0, newLevel);
                    this.plugin.getActionProcessor().clearPlayerCache(playerUuid);
                }
            }
        } else if ("xp".equalsIgnoreCase(penaltyType) && (currentXp = data.getXp(jobId)) > 0.0) {
            double xpToLose = currentXp * penaltyPercentage;
            double newXp = Math.max(0.0, currentXp - xpToLose);
            data.setXp(jobId, newXp);
            int newLevel = data.getLevel(jobId);
            UUID playerUuid = data.getPlayerUuid();
            if (playerUuid != null) {
                this.plugin.getPlayerCache().updatePlayerXp(playerUuid, jobId, newXp, newLevel);
                this.plugin.getActionProcessor().clearPlayerCache(playerUuid);
            }
        }
    }

    public Object getPerformanceManager() {
        return null;
    }

    public CompletableFuture<Void> initializePerformanceManager() {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> shutdownPerformanceManager() {
        return CompletableFuture.completedFuture(null);
    }

    public Map<String, Object> getPerformanceStats() {
        return new HashMap<String, Object>();
    }

    public void removePlayerData(UUID playerUuid) {
        this.dataLock.writeLock().lock();
        try {
            this.playerData.remove(playerUuid);
            if (this.plugin.getDataStorage() != null) {
                this.plugin.getDataStorage().deletePlayerData(playerUuid);
            }
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    public void markDataDirty(UUID playerUuid) {
        PlayerJobData data = this.getPlayerData(playerUuid);
        if (data != null) {
            this.savePlayerData(playerUuid);
        }
    }

    public Map<String, Object> getHealthInfo() {
        HashMap<String, Object> health = new HashMap<String, Object>();
        health.put("performance_manager_enabled", false);
        return health;
    }

    public void performCleanup() {
        if (this.isShutdown.get()) {
            return;
        }
        try {
            this.cleanupPlayerDataCache();
            this.cleanupJobReferences();
            this.lastCleanupTime = System.currentTimeMillis();
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().info("JobManager cleanup completed. Active player data: " + this.playerData.size());
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Error during JobManager cleanup", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupPlayerDataCache() {
        if (this.playerData.size() <= 1000) {
            return;
        }
        this.dataLock.writeLock().lock();
        try {
            Iterator<Map.Entry<UUID, PlayerJobData>> iterator = this.playerData.entrySet().iterator();
            int removedCount = 0;
            while (iterator.hasNext() && this.playerData.size() > 1000) {
                Map.Entry<UUID, PlayerJobData> entry = iterator.next();
                Player player = this.plugin.getServer().getPlayer(entry.getKey());
                if (player != null && player.isOnline()) continue;
                try {
                    this.savePlayerDataInternal(entry.getKey(), entry.getValue());
                    iterator.remove();
                    ++removedCount;
                }
                catch (Exception e) {
                    this.plugin.getLogger().log(Level.WARNING, "Failed to save player data during cleanup for " + String.valueOf(entry.getKey()), e);
                }
            }
            if (removedCount > 0 && this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().info("Cleaned up " + removedCount + " offline player data entries from cache");
            }
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    private void cleanupJobReferences() {
        this.trackedPlayerData.removeIf(ref -> ref.get() == null);
    }

    public void shutdown() {
        if (this.isShutdown.compareAndSet(false, true)) {
            try {
                this.saveAllPlayerDataSync();
                this.dataLock.writeLock().lock();
                try {
                    this.playerData.clear();
                    this.trackedPlayerData.clear();
                }
                finally {
                    this.dataLock.writeLock().unlock();
                }
                if (this.xpCurveManager != null) {
                    this.xpCurveManager = null;
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Error during JobManager shutdown", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAllPlayerDataSync() {
        this.dataLock.readLock().lock();
        try {
            for (Map.Entry<UUID, PlayerJobData> entry : this.playerData.entrySet()) {
                try {
                    this.savePlayerDataInternal(entry.getKey(), entry.getValue());
                }
                catch (Exception e) {
                    this.plugin.getLogger().log(Level.SEVERE, "Failed to save player data during shutdown for " + String.valueOf(entry.getKey()), e);
                }
            }
        }
        finally {
            this.dataLock.readLock().unlock();
        }
    }

    private void savePlayerDataInternal(UUID playerUuid, PlayerJobData data) {
        if (data == null) {
            return;
        }
        try {
            if (this.plugin.isDatabaseEnabled()) {
                DataStorage dataStorage = this.plugin.getDataStorage();
                if (dataStorage != null) {
                    dataStorage.savePlayerDataAsync(playerUuid, data).join();
                }
            } else {
                if (!this.dataFolder.exists()) {
                    this.dataFolder.mkdirs();
                }
                File dataFile = new File(this.dataFolder, playerUuid.toString() + ".yml");
                YamlConfiguration config = new YamlConfiguration();
                data.save((FileConfiguration)config);
                config.save(dataFile);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to save player data for " + String.valueOf(playerUuid), e);
        }
    }

    private void checkAndPerformCleanup() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastCleanupTime > 300000L) {
            this.plugin.getFoliaManager().runAsync(this::performCleanup);
        }
    }

    private void trackPlayerData(PlayerJobData data) {
        if (data != null) {
            this.trackedPlayerData.add(new WeakReference<PlayerJobData>(data));
        }
    }

    public Map<String, Object> getMemoryStats() {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        this.dataLock.readLock().lock();
        try {
            stats.put("cached_players", this.playerData.size());
            stats.put("max_cached_players", 1000);
            stats.put("loaded_jobs", this.jobs.size());
            stats.put("tracked_references", this.trackedPlayerData.size());
            stats.put("is_shutdown", this.isShutdown.get());
            stats.put("last_cleanup", new Date(this.lastCleanupTime));
        }
        finally {
            this.dataLock.readLock().unlock();
        }
        return stats;
    }

    public UniverseJobs getPlugin() {
        return this.plugin;
    }

    public double calculateUsageMultiplier(String jobId, double userCount) {
        FileConfiguration config = this.plugin.getConfig();
        if (!config.getBoolean("usage-multiplier.enabled", false)) {
            return 1.0;
        }
        Object path = "usage-multiplier.jobs." + jobId;
        if (!config.contains((String)path)) {
            path = "usage-multiplier.default";
        }
        if (!config.contains((String)path)) {
            return 1.0;
        }
        double minMultiplier = config.getDouble((String)path + ".min", 0.5);
        double maxMultiplier = config.getDouble((String)path + ".max", 2.0);
        double maxJobUsers = this.getMaxJobUserCount();
        if (maxJobUsers <= 0.0 || userCount <= 0.0) {
            return maxMultiplier;
        }
        double usagePercentage = userCount / maxJobUsers;
        double multiplier = maxMultiplier - usagePercentage * (maxMultiplier - minMultiplier);
        return Math.max(minMultiplier, Math.min(maxMultiplier, multiplier));
    }

    private double getMaxJobUserCount() {
        double maxUsers = 0.0;
        for (String jobId : this.jobs.keySet()) {
            double userCount = this.plugin.getDataStorage().getJobUserCount(jobId);
            if (!(userCount > maxUsers)) continue;
            maxUsers = userCount;
        }
        return maxUsers;
    }

    private void updateLeaderboardCache(UUID playerUuid, String jobId, PlayerJobData data) {
        if (!this.plugin.isDatabaseEnabled()) {
            return;
        }
        String key = String.valueOf(playerUuid) + ":" + jobId;
        String playerName = this.plugin.getServer().getOfflinePlayer(playerUuid).getName();
        if (playerName == null) {
            playerName = "Unknown";
        }
        LEADERBOARD_BATCH.put(key, new LeaderboardBatchData(playerUuid, playerName, jobId, data.getXp(jobId), data.getLevel(jobId)));
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastLeaderboardUpdate >= 10000L) {
            this.flushLeaderboardBatch();
            lastLeaderboardUpdate = currentTime;
        }
    }

    private void flushLeaderboardBatch() {
        if (LEADERBOARD_BATCH.isEmpty()) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                DatabaseDataStorage storage = (DatabaseDataStorage)this.plugin.getDataStorage();
                HashMap<String, LeaderboardBatchData> batchToProcess = new HashMap<String, LeaderboardBatchData>(LEADERBOARD_BATCH);
                LEADERBOARD_BATCH.clear();
                for (LeaderboardBatchData data : batchToProcess.values()) {
                    storage.getLeaderboardDao().updatePlayerLeaderboardEntry(data.playerUuid, data.playerName, data.jobId, data.xp, data.level);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to flush leaderboard batch: " + e.getMessage());
            }
        });
    }

    private static class LeaderboardBatchData {
        final UUID playerUuid;
        final String playerName;
        final String jobId;
        final double xp;
        final int level;

        LeaderboardBatchData(UUID playerUuid, String playerName, String jobId, double xp, int level) {
            this.playerUuid = playerUuid;
            this.playerName = playerName;
            this.jobId = jobId;
            this.xp = xp;
            this.level = level;
        }
    }
}

