/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.listener;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.action.ActionProcessor;
import fr.ax_dev.universejobs.action.ActionType;
import fr.ax_dev.universejobs.condition.ConditionContext;
import fr.ax_dev.universejobs.protection.BlockProtectionManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.momirealms.customcrops.api.event.CropBreakEvent;
import net.momirealms.customcrops.api.event.CropInteractEvent;
import net.momirealms.customcrops.api.event.CropPlantEvent;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;

public class CustomCropsEventListener
implements Listener {
    private static final String TARGET_PREFIX = "customcrops:";
    private static final String TARGET_KEY = "target";
    private final UniverseJobs plugin;
    private final ActionProcessor actionProcessor;
    private final BlockProtectionManager protectionManager;
    private final Map<UUID, Long> lastInteractTime = new HashMap<UUID, Long>();
    private static final long INTERACT_COOLDOWN_MS = 50L;
    private static final long INTERACT_TYPE_CACHE_MS = 500L;
    private final Map<UUID, String> lastInteractTypeCache = new ConcurrentHashMap<UUID, String>();
    private final Map<UUID, Long> lastInteractTypeTime = new ConcurrentHashMap<UUID, Long>();

    public CustomCropsEventListener(UniverseJobs plugin, ActionProcessor actionProcessor, BlockProtectionManager protectionManager) {
        this.plugin = plugin;
        this.actionProcessor = actionProcessor;
        this.protectionManager = protectionManager;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCropBreak(CropBreakEvent event) {
        if (!(event.entityBreaker() instanceof Player)) {
            return;
        }
        Player player = (Player)event.entityBreaker();
        Location location = event.location();
        String cropStageItemID = event.cropStageItemID();
        if (cropStageItemID == null || cropStageItemID.isEmpty()) {
            return;
        }
        ConditionContext context = new ConditionContext().setBlock(location.getBlock()).set(TARGET_KEY, TARGET_PREFIX + cropStageItemID).set("customcrops_crop_stage_id", cropStageItemID);
        this.actionProcessor.processAction(player, ActionType.BREAK, (Event)event, context);
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info("CustomCrops break: " + cropStageItemID + " by " + player.getName() + " at " + String.valueOf(location));
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (event.getClickedBlock() == null) {
            return;
        }
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Action action = event.getAction();
        if (action != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        String interactType = player.isSneaking() ? "RIGHT_SHIFT_CLICK" : "RIGHT_CLICK";
        UUID playerUUID = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        this.lastInteractTypeCache.put(playerUUID, interactType);
        this.lastInteractTypeTime.put(playerUUID, currentTime);
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info("Cached interact-type for " + player.getName() + ": " + interactType + " at " + String.valueOf(event.getClickedBlock().getLocation()));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCropInteract(CropInteractEvent event) {
        Player player = event.getPlayer();
        Location location = event.location();
        UUID playerUUID = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        Long lastTime = this.lastInteractTime.get(playerUUID);
        if (lastTime != null && currentTime - lastTime < 50L) {
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().info("CustomCrops interact blocked (double-click protection): " + player.getName() + " cooldown remaining: " + (50L - (currentTime - lastTime)) + "ms");
            }
            return;
        }
        this.lastInteractTime.put(playerUUID, currentTime);
        String cropStageItemID = event.cropStageItemID();
        if (cropStageItemID == null || cropStageItemID.isEmpty()) {
            return;
        }
        String interactType = null;
        Long cachedTime = this.lastInteractTypeTime.get(playerUUID);
        if (cachedTime != null && currentTime - cachedTime <= 500L) {
            interactType = this.lastInteractTypeCache.get(playerUUID);
        }
        if (interactType != null) {
            this.lastInteractTypeCache.remove(playerUUID);
            this.lastInteractTypeTime.remove(playerUUID);
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().info("Cleared cached interact-type for " + player.getName() + " after using: " + interactType);
            }
        }
        ConditionContext context = new ConditionContext().setBlock(location.getBlock()).set(TARGET_KEY, TARGET_PREFIX + cropStageItemID).set("customcrops_crop_stage_id", cropStageItemID);
        if (interactType != null) {
            context.set("interact-type", interactType);
        }
        this.actionProcessor.processAction(player, ActionType.BLOCK_INTERACT, (Event)event, context);
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info("CustomCrops interact/harvest: " + cropStageItemID + " by " + player.getName() + " - interact-type: " + (interactType != null ? interactType : "unknown") + " at " + String.valueOf(location));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCropPlant(CropPlantEvent event) {
        Player player = event.getPlayer();
        Location location = event.location();
        this.protectionManager.recordBlockPlacement(player, location.getBlock());
        String cropID = event.cropConfig().id();
        if (cropID == null || cropID.isEmpty()) {
            return;
        }
        ConditionContext context = new ConditionContext().setBlock(location.getBlock()).set(TARGET_KEY, TARGET_PREFIX + cropID).set("customcrops_crop_id", cropID).set("customcrops_crop_point", String.valueOf(event.point()));
        this.actionProcessor.processAction(player, ActionType.PLACE, (Event)event, context);
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info("CustomCrops plant: " + cropID + " (point: " + event.point() + ") by " + player.getName() + " at " + String.valueOf(location));
            this.plugin.getLogger().info("CustomCrops context target: " + context.getTarget());
        }
    }

    public void cleanupOldInteractTimes() {
        long currentTime = System.currentTimeMillis();
        long cleanupThreshold = 600000L;
        this.lastInteractTime.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > cleanupThreshold);
        long cacheCleanupThreshold = 1000L;
        this.lastInteractTypeCache.entrySet().removeIf(entry -> {
            Long time = this.lastInteractTypeTime.get(entry.getKey());
            return time == null || currentTime - time > cacheCleanupThreshold;
        });
        this.lastInteractTypeTime.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > cacheCleanupThreshold);
    }
}

