/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.listener;

import com.nexomc.nexo.api.events.custom_block.NexoBlockBreakEvent;
import com.nexomc.nexo.api.events.custom_block.NexoBlockInteractEvent;
import com.nexomc.nexo.api.events.custom_block.NexoBlockPlaceEvent;
import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.action.ActionProcessor;
import fr.ax_dev.universejobs.action.ActionType;
import fr.ax_dev.universejobs.condition.ConditionContext;
import fr.ax_dev.universejobs.protection.BlockProtectionManager;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class NexoEventListener
implements Listener {
    private static final String TARGET_PREFIX = "target";
    private static final String NEXO_PREFIX = "nexo:";
    private static final String NEXO_BLOCK_ID = "nexo_block_id";
    private final UniverseJobs plugin;
    private final ActionProcessor actionProcessor;
    private final BlockProtectionManager protectionManager;

    public NexoEventListener(UniverseJobs plugin, ActionProcessor actionProcessor, BlockProtectionManager protectionManager) {
        this.plugin = plugin;
        this.actionProcessor = actionProcessor;
        this.protectionManager = protectionManager;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onNexoBlockPlace(NexoBlockPlaceEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        String nexoBlockId = event.getMechanic().getItemID();
        this.protectionManager.recordBlockPlacement(player, block);
        ConditionContext context = new ConditionContext().setBlock(block).set(TARGET_PREFIX, NEXO_PREFIX + nexoBlockId).set(NEXO_BLOCK_ID, nexoBlockId);
        this.actionProcessor.processAction(player, ActionType.PLACE, (Event)event, context);
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info("Nexo block placed: " + nexoBlockId + " by " + player.getName() + " at " + String.valueOf(block.getLocation()));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onNexoBlockBreak(NexoBlockBreakEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        String nexoBlockId = event.getMechanic().getItemID();
        if (this.protectionManager.isPlayerPlacedBlock(block)) {
            this.protectionManager.removeTrackedBlock(block);
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().info("Player " + player.getName() + " mined a player-placed Nexo block (" + nexoBlockId + ") - no XP awarded");
            }
            return;
        }
        ConditionContext context = new ConditionContext().setBlock(block).set(TARGET_PREFIX, NEXO_PREFIX + nexoBlockId).set(NEXO_BLOCK_ID, nexoBlockId);
        this.actionProcessor.processAction(player, ActionType.BREAK, (Event)event, context);
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info("Nexo block broken: " + nexoBlockId + " by " + player.getName() + " at " + String.valueOf(block.getLocation()));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onNexoBlockInteract(NexoBlockInteractEvent event) {
        String interactType;
        Player player = event.getPlayer();
        Block block = event.getBlock();
        String nexoBlockId = event.getMechanic().getItemID();
        try {
            boolean isRightClick;
            boolean bl = isRightClick = event.getHand() != null;
            interactType = player.isSneaking() ? (isRightClick ? "RIGHT_SHIFT_CLICK" : "LEFT_SHIFT_CLICK") : (isRightClick ? "RIGHT_CLICK" : "LEFT_CLICK");
        }
        catch (Exception e) {
            interactType = player.isSneaking() ? "RIGHT_SHIFT_CLICK" : "RIGHT_CLICK";
        }
        ConditionContext context = new ConditionContext().setBlock(block).set(TARGET_PREFIX, NEXO_PREFIX + nexoBlockId).set(NEXO_BLOCK_ID, nexoBlockId).set("interact-type", interactType);
        this.actionProcessor.processAction(player, ActionType.BLOCK_INTERACT, (Event)event, context);
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info("Nexo block interact: " + nexoBlockId + " by " + player.getName() + " - interact-type: " + interactType);
        }
    }
}

