/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.menu;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.action.ActionType;
import fr.ax_dev.universejobs.job.Job;
import fr.ax_dev.universejobs.job.PlayerJobData;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class AsyncMenuLoader {
    private final UniverseJobs plugin;
    private final ExecutorService executor;
    private final Map<String, PreparedMenuData> menuCache = new ConcurrentHashMap<String, PreparedMenuData>();
    private final Map<UUID, Map<String, Integer>> playerPermissionCache = new ConcurrentHashMap<UUID, Map<String, Integer>>();
    private static final long CACHE_DURATION = 60000L;

    public AsyncMenuLoader(UniverseJobs plugin) {
        this.plugin = plugin;
        this.executor = Executors.newCachedThreadPool(r -> {
            Thread thread = new Thread(r);
            thread.setName("UniverseJobs-MenuLoader");
            thread.setDaemon(true);
            thread.setPriority(1);
            return thread;
        });
    }

    public void preloadPlayerData(Player player) {
        CompletableFuture.runAsync(() -> {
            UUID playerId = player.getUniqueId();
            ConcurrentHashMap<String, Integer> permissions = new ConcurrentHashMap<String, Integer>();
            for (Job job : this.plugin.getJobManager().getJobs().values()) {
                PlayerJobData playerData = this.plugin.getJobManager().getPlayerData(playerId);
                int maxLevel = playerData.getMaxLevel(job.getId());
                permissions.put(job.getId(), maxLevel);
            }
            this.playerPermissionCache.put(playerId, permissions);
        }, this.executor);
    }

    public JobsMainMenuData preloadJobsMainMenuData(Player player) {
        PlayerJobData playerData;
        UUID playerId = player.getUniqueId();
        JobsMainMenuData data = new JobsMainMenuData();
        data.playerData = playerData = this.plugin.getJobManager().getPlayerData(playerId);
        data.jobPlaceholders = new ConcurrentHashMap<String, Map<String, String>>();
        for (Job job : this.plugin.getJobManager().getJobs().values()) {
            if (!job.isEnabled()) continue;
            Map<String, String> placeholders = this.createJobPlaceholdersAsync(job, playerData);
            data.jobPlaceholders.put(job.getId(), placeholders);
        }
        return data;
    }

    public Map<String, ItemStack> createJobsMainMenuItems(Player player, JobsMainMenuData data) {
        return new ConcurrentHashMap<String, ItemStack>();
    }

    private Map<String, String> createJobPlaceholdersAsync(Job job, PlayerJobData playerData) {
        ConcurrentHashMap<String, String> placeholders = new ConcurrentHashMap<String, String>();
        placeholders.put("{job_id}", job.getId());
        placeholders.put("{job_name}", job.getName());
        placeholders.put("{job_description}", job.getDescription());
        placeholders.put("{job_description_lines}", String.join((CharSequence)"\n", job.getDescriptionLines()));
        boolean hasJob = playerData.hasJob(job.getId());
        placeholders.put("{has_job}", String.valueOf(hasJob));
        if (hasJob) {
            int level = playerData.getLevel(job.getId());
            double xp = playerData.getXp(job.getId());
            int maxLevel = playerData.getMaxLevel(job.getId());
            placeholders.put("{level}", String.valueOf(level));
            placeholders.put("{xp}", String.valueOf((long)xp));
            placeholders.put("{max_level}", String.valueOf(maxLevel));
            if (level < maxLevel && job.getXpCurve() != null) {
                long currentLevelXp = (long)job.getXpCurve().getXpForLevel(level);
                long nextLevelXp = (long)job.getXpCurve().getXpForLevel(level + 1);
                long currentXpInLevel = Math.max(0L, (long)xp - currentLevelXp);
                long xpNeededForNext = nextLevelXp - currentLevelXp;
                long xpToNext = Math.max(0L, nextLevelXp - (long)xp);
                double progress = xpNeededForNext > 0L ? Math.min(1.0, (double)currentXpInLevel / (double)xpNeededForNext) : 1.0;
                placeholders.put("{xp_to_next}", String.valueOf(xpToNext));
                placeholders.put("{next_level_xp}", String.valueOf(xpNeededForNext));
                placeholders.put("{current_xp}", String.valueOf(currentXpInLevel));
                placeholders.put("{progress_percent}", String.format("%.1f", progress * 100.0));
            }
        } else {
            placeholders.put("{level}", "0");
            placeholders.put("{xp}", "0");
            placeholders.put("{max_level}", String.valueOf(playerData.getMaxLevel(job.getId())));
            placeholders.put("{xp_to_next}", "0");
            placeholders.put("{next_level_xp}", "0");
            placeholders.put("{progress_percent}", "0.0");
        }
        return placeholders;
    }

    public CompletableFuture<PreparedMenuData> prepareJobsMenu(Player player) {
        String cacheKey = "jobs_" + String.valueOf(player.getUniqueId());
        PreparedMenuData cached = this.menuCache.get(cacheKey);
        if (cached != null && !cached.isExpired()) {
            return CompletableFuture.completedFuture(cached);
        }
        return CompletableFuture.supplyAsync(() -> {
            PreparedMenuData data = new PreparedMenuData();
            for (Job job : this.plugin.getJobManager().getJobs().values()) {
                Map<String, String> placeholders = this.createJobPlaceholdersAsync(player, job);
                data.addPlaceholders(job.getId(), placeholders);
            }
            this.menuCache.put(cacheKey, data);
            return data;
        }, this.executor);
    }

    public CompletableFuture<PreparedMenuData> prepareJobActionsMenu(Player player, String jobId) {
        String cacheKey = "actions_" + String.valueOf(player.getUniqueId()) + "_" + jobId;
        PreparedMenuData cached = this.menuCache.get(cacheKey);
        if (cached != null && !cached.isExpired()) {
            return CompletableFuture.completedFuture(cached);
        }
        return CompletableFuture.supplyAsync(() -> {
            PreparedMenuData data = new PreparedMenuData();
            Job job = this.plugin.getJobManager().getJob(jobId);
            if (job == null) {
                return data;
            }
            job.getActionTypes().forEach(actionType -> job.getActions((ActionType)((Object)((Object)actionType))).forEach(action -> {
                String key = actionType.name() + "_" + action.getTarget();
                Map<String, String> placeholders = Map.of("action_type", actionType.toString(), "target", action.getTarget(), "xp", String.valueOf(action.getXp()), "money", String.valueOf(action.getMoney()));
                data.addPlaceholders(key, placeholders);
            }));
            this.menuCache.put(cacheKey, data);
            return data;
        }, this.executor);
    }

    private Map<String, String> createJobPlaceholdersAsync(Player player, Job job) {
        Map<String, Integer> perms;
        PlayerJobData playerData = this.plugin.getJobManager().getPlayerData(player.getUniqueId());
        ConcurrentHashMap<String, String> placeholders = new ConcurrentHashMap<String, String>();
        placeholders.put("{job_id}", job.getId());
        placeholders.put("{job_name}", job.getDisplayName());
        placeholders.put("{job_description}", job.getDescription());
        boolean hasJob = playerData.hasJob(job.getId());
        placeholders.put("{has_job}", String.valueOf(hasJob));
        if (hasJob) {
            placeholders.put("{level}", String.valueOf(playerData.getLevel(job.getId())));
            placeholders.put("{xp}", String.valueOf(Math.round(playerData.getXp(job.getId()))));
            double[] xpProgress = playerData.getXpProgress(job.getId());
            placeholders.put("{xp_current}", String.valueOf(Math.round(xpProgress[0])));
            placeholders.put("{xp_required}", String.valueOf(Math.round(xpProgress[1])));
            placeholders.put("{xp_percent}", String.valueOf(Math.round(xpProgress[0] / xpProgress[1] * 100.0)));
        }
        if ((perms = this.playerPermissionCache.get(player.getUniqueId())) != null && perms.containsKey(job.getId())) {
            placeholders.put("{max_level}", String.valueOf(perms.get(job.getId())));
        } else {
            placeholders.put("{max_level}", String.valueOf(playerData.getMaxLevel(job.getId())));
        }
        return placeholders;
    }

    public void clearCache(UUID playerId) {
        this.menuCache.entrySet().removeIf(entry -> ((String)entry.getKey()).contains(playerId.toString()));
        this.playerPermissionCache.remove(playerId);
    }

    public void shutdown() {
        this.executor.shutdown();
        this.menuCache.clear();
        this.playerPermissionCache.clear();
    }

    public static class JobsMainMenuData {
        public PlayerJobData playerData;
        public Map<String, Map<String, String>> jobPlaceholders;
    }

    public static class PreparedMenuData {
        private final Map<String, ItemStack> items = new ConcurrentHashMap<String, ItemStack>();
        private final Map<String, Map<String, String>> placeholders = new ConcurrentHashMap<String, Map<String, String>>();
        private final long createdAt = System.currentTimeMillis();

        public void addItem(String key, ItemStack item) {
            this.items.put(key, item);
        }

        public ItemStack getItem(String key) {
            return this.items.get(key);
        }

        public Map<String, ItemStack> getAllItems() {
            return new ConcurrentHashMap<String, ItemStack>(this.items);
        }

        public void addPlaceholders(String key, Map<String, String> placeholderMap) {
            this.placeholders.put(key, placeholderMap);
        }

        public Map<String, String> getPlaceholders(String key) {
            return this.placeholders.getOrDefault(key, new ConcurrentHashMap());
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.createdAt > 60000L;
        }
    }
}

