/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.menu;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.kyori.adventure.text.Component;
import org.bukkit.inventory.ItemStack;

public class ComponentCache {
    private static final int MAX_CACHE_SIZE = 1000;
    private static final int MAX_QUEUE_SIZE = 100;
    private final Map<String, Component> componentCache = new ConcurrentHashMap<String, Component>();
    private final Map<String, ItemStack> itemCache = new ConcurrentHashMap<String, ItemStack>();
    private final Queue<String> accessOrder = new ConcurrentLinkedQueue<String>();
    private final Map<String, Long> lastAccess = new ConcurrentHashMap<String, Long>();

    public Component getComponent(String key, ComponentSupplier supplier) {
        Component component = this.componentCache.get(key);
        if (component != null) {
            this.trackAccess(key);
            return component;
        }
        component = supplier.get();
        if (component != null) {
            this.addToCache(key, component);
        }
        return component;
    }

    public ItemStack getItem(String key, ItemSupplier supplier) {
        ItemStack item = this.itemCache.get(key);
        if (item != null) {
            this.trackAccess(key);
            return item.clone();
        }
        item = supplier.get();
        if (item != null) {
            this.addToItemCache(key, item.clone());
            return item;
        }
        return null;
    }

    private void addToCache(String key, Component component) {
        if (this.componentCache.size() >= 1000) {
            this.evictOldest();
        }
        this.componentCache.put(key, component);
        this.trackAccess(key);
    }

    private void addToItemCache(String key, ItemStack item) {
        if (this.itemCache.size() >= 1000) {
            this.evictOldestItem();
        }
        this.itemCache.put(key, item);
        this.trackAccess(key);
    }

    private void trackAccess(String key) {
        this.lastAccess.put(key, System.currentTimeMillis());
        if (this.accessOrder.size() > 100) {
            this.accessOrder.poll();
        }
        this.accessOrder.offer(key);
    }

    private void evictOldest() {
        String oldest = null;
        long oldestTime = Long.MAX_VALUE;
        for (Map.Entry<String, Long> entry : this.lastAccess.entrySet()) {
            if (entry.getValue() >= oldestTime || !this.componentCache.containsKey(entry.getKey())) continue;
            oldestTime = entry.getValue();
            oldest = entry.getKey();
        }
        if (oldest != null) {
            this.componentCache.remove(oldest);
            this.lastAccess.remove(oldest);
        }
    }

    private void evictOldestItem() {
        String oldest = null;
        long oldestTime = Long.MAX_VALUE;
        for (Map.Entry<String, Long> entry : this.lastAccess.entrySet()) {
            if (entry.getValue() >= oldestTime || !this.itemCache.containsKey(entry.getKey())) continue;
            oldestTime = entry.getValue();
            oldest = entry.getKey();
        }
        if (oldest != null) {
            this.itemCache.remove(oldest);
            this.lastAccess.remove(oldest);
        }
    }

    public void preWarm() {
        String[] commonKeys;
        for (String string : commonKeys = new String[]{"empty_slot", "back_button", "next_page", "prev_page", "close_button", "refresh_button", "fill_item"}) {
        }
    }

    public void clear() {
        this.componentCache.clear();
        this.itemCache.clear();
        this.accessOrder.clear();
        this.lastAccess.clear();
    }

    public void clearPlayer(String playerUuid) {
        this.componentCache.entrySet().removeIf(entry -> ((String)entry.getKey()).startsWith(playerUuid + ":"));
        this.itemCache.entrySet().removeIf(entry -> ((String)entry.getKey()).startsWith(playerUuid + ":"));
    }

    public int getComponentCacheSize() {
        return this.componentCache.size();
    }

    public int getItemCacheSize() {
        return this.itemCache.size();
    }

    @FunctionalInterface
    public static interface ComponentSupplier {
        public Component get();
    }

    @FunctionalInterface
    public static interface ItemSupplier {
        public ItemStack get();
    }
}

