/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.menu;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class InventoryPool {
    private static final int MAX_POOL_SIZE = 50;
    private static final int DEFAULT_SIZE = 54;
    private final Map<Integer, ConcurrentLinkedQueue<Inventory>> poolsBySize = new ConcurrentHashMap<Integer, ConcurrentLinkedQueue<Inventory>>();
    private final Map<Inventory, Long> lastUsed = new ConcurrentHashMap<Inventory, Long>();
    private static final long CLEANUP_INTERVAL = 300000L;
    private volatile long lastCleanup = System.currentTimeMillis();

    public Inventory getInventory(int size, Component title, InventoryHolder holder) {
        Inventory inventory = Bukkit.createInventory((InventoryHolder)holder, (int)size, (Component)title);
        this.lastUsed.put(inventory, System.currentTimeMillis());
        return inventory;
    }

    public void returnInventory(Inventory inventory) {
        if (inventory == null) {
            return;
        }
        int size = inventory.getSize();
        ConcurrentLinkedQueue<Inventory> pool = this.poolsBySize.get(size);
        if (pool != null && pool.size() < 50) {
            inventory.clear();
            pool.offer(inventory);
        }
        this.lastUsed.remove(inventory);
        this.cleanupIfNeeded();
    }

    private void cleanupIfNeeded() {
        long now = System.currentTimeMillis();
        if (now - this.lastCleanup > 300000L) {
            this.cleanup();
            this.lastCleanup = now;
        }
    }

    private void cleanup() {
        long threshold = System.currentTimeMillis() - 300000L;
        for (ConcurrentLinkedQueue<Inventory> pool : this.poolsBySize.values()) {
            pool.removeIf(inv -> {
                Long lastUse = this.lastUsed.get(inv);
                return lastUse != null && lastUse < threshold;
            });
        }
    }

    public void shutdown() {
        this.poolsBySize.clear();
        this.lastUsed.clear();
    }

    public int getPoolSize() {
        return this.poolsBySize.values().stream().mapToInt(ConcurrentLinkedQueue::size).sum();
    }
}

