/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.menu.config;

import fr.ax_dev.universejobs.menu.config.MenuItemConfig;
import fr.ax_dev.universejobs.menu.config.SimpleConfigurationSection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;

public class JobItemFormat
extends MenuItemConfig {
    private final boolean useJobIcon;
    private final List<String> loreWithoutJob;
    private final boolean elseGlow;

    public JobItemFormat(ConfigurationSection config) {
        super(JobItemFormat.createJobItemConfigSection(config));
        this.useJobIcon = config.getBoolean("use-job-icon", true);
        ConfigurationSection elseSection = config.getConfigurationSection("else");
        if (elseSection != null) {
            List elseLore = elseSection.getStringList("lore");
            this.loreWithoutJob = elseLore.isEmpty() ? JobItemFormat.getDefaultLoreWithoutJob() : elseLore;
            this.elseGlow = elseSection.getBoolean("glow", true);
        } else {
            List loreWithoutJobRaw = config.getStringList("lore-without-job");
            this.loreWithoutJob = loreWithoutJobRaw.isEmpty() ? JobItemFormat.getDefaultLoreWithoutJob() : loreWithoutJobRaw;
            this.elseGlow = config.getBoolean("glow-when-not-joined", true);
        }
    }

    private JobItemFormat(boolean useJobIcon, String displayName, List<String> lore, List<String> loreWithoutJob, boolean glowWhenJoined, boolean glowWhenNotJoined, int amount, boolean hideAttributes, boolean hideEnchants) {
        super(JobItemFormat.createDefaultConfigSection(displayName, lore, glowWhenJoined, glowWhenNotJoined, amount, hideAttributes, hideEnchants));
        this.useJobIcon = useJobIcon;
        this.loreWithoutJob = loreWithoutJob;
        this.elseGlow = glowWhenNotJoined;
    }

    private static ConfigurationSection createJobItemConfigSection(ConfigurationSection config) {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put("enabled", config.getBoolean("enabled", true));
        configMap.put("material", config.getString("material", "STONE"));
        configMap.put("amount", config.getInt("amount", 1));
        configMap.put("display-name", config.getString("display-name", "<bold>{job_name}</bold>"));
        List<String> lore = config.getStringList("lore");
        if (lore.isEmpty()) {
            lore = JobItemFormat.getDefaultLore();
        }
        configMap.put("lore", lore);
        configMap.put("custom-model-data", config.getInt("custom-model-data", 0));
        configMap.put("glow", config.getBoolean("glow-when-joined", false));
        configMap.put("hide-attributes", config.getBoolean("hide-attributes", true));
        configMap.put("hide-enchants", config.getBoolean("hide-enchants", true));
        return new SimpleConfigurationSection(configMap);
    }

    private static ConfigurationSection createDefaultConfigSection(String displayName, List<String> lore, boolean glowWhenJoined, boolean glowWhenNotJoined, int amount, boolean hideAttributes, boolean hideEnchants) {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put("enabled", true);
        configMap.put("material", "STONE");
        configMap.put("amount", amount);
        configMap.put("display-name", displayName);
        configMap.put("lore", lore);
        configMap.put("custom-model-data", 0);
        configMap.put("glow", glowWhenJoined);
        configMap.put("hide-attributes", hideAttributes);
        configMap.put("hide-enchants", hideEnchants);
        return new SimpleConfigurationSection(configMap);
    }

    public static JobItemFormat getDefault() {
        return new JobItemFormat(true, "<bold>{job_name}</bold>", JobItemFormat.getDefaultLore(), JobItemFormat.getDefaultLoreWithoutJob(), false, true, 1, true, true);
    }

    private static List<String> getDefaultLore() {
        return Arrays.asList("<gray>{job_description}", "", "<gray>Your Status:", "<gray>\u251c <gray>Level: <#abffb3>{player_level}<gray>/<#abffb3>{job_max_level} <gray>(<#FFD700>{progress_percent}%<gray>)", "<gray>\u251c <gray>XP: <#62de6e>{player_xp}", "<gray>\u2514 {progress_bar}", "", "<gray>\u25c6 <gray>Status: {job_status}", "", "<#FFD700>\u25b6 Left-Click to open job menu", "<#abffb3>\u25b6 Right-Click to leave");
    }

    private static List<String> getDefaultLoreWithoutJob() {
        return Arrays.asList("<gray>{job_description}", "", "<gray>Your Status:", "<gray>\u251c <gray>Level: <#abffb3>{player_level}<gray>/<#abffb3>{job_max_level} <gray>(<#FFD700>{progress_percent}%<gray>)", "<gray>\u251c <gray>XP: <#62de6e>{player_xp}", "<gray>\u2514 {progress_bar}", "", "<gray>\u25c6 <gray>Status: {job_status}", "", "<#FFD700>\u25b6 Left-Click to open job menu", "<#abffb3>\u25b6 Right-Click to join");
    }

    public boolean isUseJobIcon() {
        return this.useJobIcon;
    }

    public List<String> getLoreWithoutJob() {
        return new ArrayList<String>(this.loreWithoutJob);
    }

    public boolean shouldGlow(boolean hasJob) {
        return hasJob ? this.isGlow() : this.elseGlow;
    }
}

