/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.placeholder;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.job.Job;
import fr.ax_dev.universejobs.job.PlayerJobData;
import fr.ax_dev.universejobs.placeholder.BoostPlaceholder;
import fr.ax_dev.universejobs.placeholder.GlobalLeaderboardPlaceholder;
import fr.ax_dev.universejobs.placeholder.JobsLeaderboardPlaceholder;
import java.util.ArrayList;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;

public class UniversalPlaceholderExpansion
extends PlaceholderExpansion {
    private final UniverseJobs plugin;
    private final JobsLeaderboardPlaceholder jobsLeaderboardPlaceholder;
    private final GlobalLeaderboardPlaceholder globalLeaderboardPlaceholder;
    private final BoostPlaceholder boostPlaceholder;

    public UniversalPlaceholderExpansion(UniverseJobs plugin) {
        this.plugin = plugin;
        this.jobsLeaderboardPlaceholder = new JobsLeaderboardPlaceholder(plugin);
        this.globalLeaderboardPlaceholder = new GlobalLeaderboardPlaceholder(plugin);
        this.boostPlaceholder = new BoostPlaceholder(plugin);
    }

    public String getIdentifier() {
        return "universejobs";
    }

    public String getAuthor() {
        return this.plugin.getDescription().getAuthors().toString();
    }

    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public String onRequest(OfflinePlayer player, String params) {
        if (params == null) {
            return null;
        }
        if (params.equalsIgnoreCase("totaljobs")) {
            return String.valueOf(this.plugin.getJobManager().getAllJobs().size());
        }
        if (params.equalsIgnoreCase("equippedjobs")) {
            if (player == null) {
                return "0";
            }
            return String.valueOf(this.getEquippedJobsCount(player));
        }
        if (params.equalsIgnoreCase("currentjobs")) {
            if (player == null) {
                return "No Jobs";
            }
            return this.getCurrentJobs(player);
        }
        String[] args = params.split("_");
        if (args.length < 1) {
            return null;
        }
        if (args[0].equalsIgnoreCase("global")) {
            return this.globalLeaderboardPlaceholder.onRequest(player, params);
        }
        if (args[0].equalsIgnoreCase("boost")) {
            return this.boostPlaceholder.onRequest(player, params);
        }
        if (args[0].equalsIgnoreCase("equippedjobs") && args.length == 2) {
            if (player == null) {
                return "0";
            }
            return String.valueOf(this.getEquippedJobsOfTypeCount(player, args[1]));
        }
        if (args[0].equalsIgnoreCase("multiplier") && args.length == 2) {
            if (player == null) {
                return "1.0";
            }
            return String.valueOf(this.getUsageMultiplier(args[1]));
        }
        return this.jobsLeaderboardPlaceholder.onRequest(player, params);
    }

    public void clearCache() {
        this.jobsLeaderboardPlaceholder.clearCache();
        this.globalLeaderboardPlaceholder.clearCache();
    }

    public void clearJobCache(String jobId) {
        this.jobsLeaderboardPlaceholder.clearJobCache(jobId);
    }

    private int getEquippedJobsCount(OfflinePlayer player) {
        try {
            return this.plugin.getDataStorage().getPlayerData(player.getUniqueId()).getJobs().size();
        }
        catch (Exception e) {
            return 0;
        }
    }

    private int getEquippedJobsOfTypeCount(OfflinePlayer player, String jobType) {
        try {
            return (int)this.plugin.getDataStorage().getPlayerData(player.getUniqueId()).getJobs().stream().filter(jobId -> jobType.equalsIgnoreCase((String)jobId)).count();
        }
        catch (Exception e) {
            return 0;
        }
    }

    private double getUsageMultiplier(String jobId) {
        try {
            double userCount = this.plugin.getDataStorage().getJobUserCount(jobId);
            return this.plugin.getJobManager().calculateUsageMultiplier(jobId, userCount);
        }
        catch (Exception e) {
            return 1.0;
        }
    }

    private String getCurrentJobs(OfflinePlayer player) {
        try {
            PlayerJobData playerData = this.plugin.getDataStorage().getPlayerData(player.getUniqueId());
            if (playerData == null || playerData.getJobs().isEmpty()) {
                return "No Jobs";
            }
            ArrayList<String> jobNames = new ArrayList<String>();
            for (String jobId : playerData.getJobs()) {
                Job job = this.plugin.getJobManager().getJob(jobId);
                if (job == null) continue;
                jobNames.add(job.getName());
            }
            if (jobNames.isEmpty()) {
                return "No Jobs";
            }
            return String.join((CharSequence)", ", jobNames);
        }
        catch (Exception e) {
            return "No Jobs";
        }
    }
}

