/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.reward;

import fr.ax_dev.universejobs.condition.ConditionGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.configuration.ConfigurationSection;

public class Reward {
    private final String id;
    private final String name;
    private final String description;
    private final List<String> lore;
    private final String jobId;
    private final int requiredLevel;
    private final boolean repeatable;
    private final long cooldownHours;
    private final ConditionGroup requirements;
    private final List<RewardItem> items;
    private final List<String> commands;
    private final double economyReward;
    private final String permission;
    private final int guiSlot;
    private final boolean enabled;

    public Reward(String id, String jobId, ConfigurationSection config) {
        this.id = id;
        this.jobId = jobId;
        this.name = config.getString("name", id);
        this.description = config.getString("description", "");
        this.lore = config.getStringList("lore");
        this.requiredLevel = config.getInt("required-level", 1);
        this.repeatable = config.getBoolean("repeatable", false);
        this.cooldownHours = config.getLong("cooldown-hours", 0L);
        this.economyReward = config.getDouble("economy-reward", 0.0);
        this.permission = config.getString("permission");
        this.guiSlot = config.getInt("gui-slot", -1);
        this.enabled = config.getBoolean("enabled", true);
        ConfigurationSection reqSection = config.getConfigurationSection("requirements");
        this.requirements = reqSection != null ? new ConditionGroup(reqSection) : null;
        this.items = new ArrayList<RewardItem>();
        ConfigurationSection itemsSection = config.getConfigurationSection("items");
        if (itemsSection != null) {
            for (String itemKey : itemsSection.getKeys(false)) {
                ConfigurationSection itemSection = itemsSection.getConfigurationSection(itemKey);
                if (itemSection == null) continue;
                this.items.add(new RewardItem(itemSection));
            }
        }
        this.commands = config.getStringList("commands");
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getLore() {
        return new ArrayList<String>(this.lore);
    }

    public String getJobId() {
        return this.jobId;
    }

    public int getRequiredLevel() {
        return this.requiredLevel;
    }

    public boolean isRepeatable() {
        return this.repeatable;
    }

    public long getCooldownHours() {
        return this.cooldownHours;
    }

    public ConditionGroup getRequirements() {
        return this.requirements;
    }

    public List<RewardItem> getItems() {
        return new ArrayList<RewardItem>(this.items);
    }

    public List<String> getCommands() {
        return new ArrayList<String>(this.commands);
    }

    public double getEconomyReward() {
        return this.economyReward;
    }

    public String getPermission() {
        return this.permission;
    }

    public int getGuiSlot() {
        return this.guiSlot;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean hasItems() {
        return !this.items.isEmpty();
    }

    public boolean hasCommands() {
        return !this.commands.isEmpty();
    }

    public boolean hasEconomyReward() {
        return this.economyReward > 0.0;
    }

    public boolean hasRequirements() {
        return this.requirements != null;
    }

    public String toString() {
        return "Reward{id='" + this.id + "', name='" + this.name + "', job='" + this.jobId + "', level=" + this.requiredLevel + ", enabled=" + this.enabled + "}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Reward reward = (Reward)obj;
        return Objects.equals(this.id, reward.id) && Objects.equals(this.jobId, reward.jobId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.jobId);
    }

    public static class RewardItem {
        private final String material;
        private final int amount;
        private final String displayName;
        private final List<String> lore;
        private final int customModelData;
        private final String nexoId;
        private final String itemsAdderId;

        public RewardItem(ConfigurationSection config) {
            this.material = config.getString("material", "STONE");
            this.amount = config.getInt("amount", 1);
            this.displayName = config.getString("display-name");
            this.lore = config.getStringList("lore");
            this.customModelData = config.getInt("custom-model-data", -1);
            this.nexoId = config.getString("nexo-id");
            this.itemsAdderId = config.getString("itemsadder-id");
        }

        public String getMaterial() {
            return this.material;
        }

        public int getAmount() {
            return this.amount;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public List<String> getLore() {
            return new ArrayList<String>(this.lore);
        }

        public int getCustomModelData() {
            return this.customModelData;
        }

        public String getNexoId() {
            return this.nexoId;
        }

        public String getItemsAdderId() {
            return this.itemsAdderId;
        }

        public boolean hasCustomModelData() {
            return this.customModelData != -1;
        }

        public boolean isNexoItem() {
            return this.nexoId != null && !this.nexoId.isEmpty();
        }

        public boolean isItemsAdderItem() {
            return this.itemsAdderId != null && !this.itemsAdderId.isEmpty();
        }
    }
}

