/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.update;

import fr.ax_dev.universejobs.UniverseJobs;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Level;
import org.bukkit.plugin.Plugin;

public class UpdateChecker {
    private static final String SPIGOT_API_URL = "https://api.spiget.org/v2/resources/128572/versions/latest";
    private final UniverseJobs plugin;

    public UpdateChecker(UniverseJobs plugin) {
        this.plugin = plugin;
    }

    public void checkForUpdates() {
        this.plugin.getServer().getAsyncScheduler().runNow((Plugin)this.plugin, task -> {
            try {
                URL url = new URL(SPIGOT_API_URL);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("User-Agent", "UniverseJobs-UpdateChecker");
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                int responseCode = connection.getResponseCode();
                if (responseCode != 200) {
                    this.plugin.getLogger().warning("Update check failed: HTTP " + responseCode);
                    return;
                }
                StringBuilder response = new StringBuilder();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        response.append(line);
                    }
                }
                String responseBody = response.toString();
                String latestVersion = this.extractValue(responseBody, "\"name\"");
                if (latestVersion == null) {
                    this.plugin.getLogger().warning("Could not parse latest version from Spigot response.");
                    return;
                }
                String currentVersion = this.plugin.getDescription().getVersion();
                int comparison = this.compareVersions(currentVersion, latestVersion);
                if (comparison == 0) {
                    this.plugin.getLogger().info("UniverseJobs is up to date! (Version: " + currentVersion + ")");
                } else if (comparison > 0) {
                    this.plugin.getLogger().info("You are running a newer version than the latest on SpigotMC!");
                    this.plugin.getLogger().info("    Current: " + currentVersion);
                    this.plugin.getLogger().info("    SpigotMC: " + latestVersion);
                } else {
                    this.plugin.getLogger().info("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
                    this.plugin.getLogger().info("    NEW UPDATE AVAILABLE!");
                    this.plugin.getLogger().info("    Current: " + currentVersion);
                    this.plugin.getLogger().info("    Latest:  " + latestVersion);
                    this.plugin.getLogger().info("    Download: https://www.spigotmc.org/resources/128572/");
                    this.plugin.getLogger().info("\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550");
                }
            }
            catch (IOException e) {
                if (this.plugin.getServer().getPluginManager().getPlugin("UniverseJobs").isEnabled()) {
                    this.plugin.getLogger().log(Level.WARNING, "Could not check for updates: " + e.getMessage());
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Error while checking for updates", e);
            }
        });
    }

    private int compareVersions(String current, String latest) {
        String cleanCurrent = this.extractVersionNumber(current);
        String cleanLatest = this.extractVersionNumber(latest);
        String[] currentParts = cleanCurrent.split("\\.");
        String[] latestParts = cleanLatest.split("\\.");
        int maxLength = Math.max(currentParts.length, latestParts.length);
        for (int i = 0; i < maxLength; ++i) {
            int latestPart;
            int currentPart = i < currentParts.length ? this.parseVersionPart(currentParts[i]) : 0;
            int n = latestPart = i < latestParts.length ? this.parseVersionPart(latestParts[i]) : 0;
            if (currentPart == latestPart) continue;
            return currentPart - latestPart;
        }
        return 0;
    }

    private String extractVersionNumber(String version) {
        if (version == null) {
            return "0.0.0";
        }
        version = version.toUpperCase();
        version = version.replaceAll("^(ALPHA-|BETA-|RC-|RELEASE-|V)", "");
        version = version.replaceAll("(-DEV|-SNAPSHOT|-BETA|-ALPHA).*$", "");
        return version.trim();
    }

    private int parseVersionPart(String part) {
        try {
            return Integer.parseInt(part);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private String extractValue(String json, String key) {
        int end;
        int start = json.indexOf(key);
        if (start == -1) {
            return null;
        }
        if ((start = json.indexOf(58, start)) == -1) {
            return null;
        }
        if ((start = json.indexOf(34, start)) == -1) {
            return null;
        }
        if ((end = json.indexOf(34, ++start)) == -1) {
            return null;
        }
        return json.substring(start, end);
    }
}

