/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.utils;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;

public class CumulativeGainTracker {
    private static final Map<UUID, PlayerGains> PLAYER_GAINS = new ConcurrentHashMap<UUID, PlayerGains>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] addGains(Player player, double xpGain, double moneyGain) {
        PlayerGains gains;
        UUID playerId = player.getUniqueId();
        PlayerGains playerGains = gains = PLAYER_GAINS.computeIfAbsent(playerId, k -> new PlayerGains());
        synchronized (playerGains) {
            gains.addGains(xpGain, moneyGain);
            return new double[]{gains.totalXp, gains.totalMoney, gains.getCurrentXpPerAction(), gains.getCurrentMoneyPerAction()};
        }
    }

    public static boolean hasActiveGains(Player player) {
        PlayerGains gains = PLAYER_GAINS.get(player.getUniqueId());
        return gains != null && gains.hasGains();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasRecentGains(Player player, long durationMs) {
        PlayerGains gains = PLAYER_GAINS.get(player.getUniqueId());
        if (gains == null) {
            return false;
        }
        PlayerGains playerGains = gains;
        synchronized (playerGains) {
            long timeSinceLastUpdate = System.currentTimeMillis() - gains.lastUpdateTime;
            return timeSinceLastUpdate < durationMs && gains.hasGains();
        }
    }

    public static void clearGains(Player player) {
        PLAYER_GAINS.remove(player.getUniqueId());
    }

    public static void clearAllGains() {
        PLAYER_GAINS.clear();
    }

    private static class PlayerGains {
        private double totalXp = 0.0;
        private double totalMoney = 0.0;
        private double lastXpPerAction = 0.0;
        private double lastMoneyPerAction = 0.0;
        private int actionCount = 0;
        private long lastUpdateTime = System.currentTimeMillis();

        private PlayerGains() {
        }

        void addGains(double xp, double money) {
            this.totalXp += xp;
            this.totalMoney += money;
            this.lastXpPerAction = xp;
            this.lastMoneyPerAction = money;
            ++this.actionCount;
            this.lastUpdateTime = System.currentTimeMillis();
        }

        boolean hasGains() {
            return this.totalXp != 0.0 || this.totalMoney != 0.0;
        }

        double getCurrentXpPerAction() {
            return this.lastXpPerAction;
        }

        double getCurrentMoneyPerAction() {
            return this.lastMoneyPerAction;
        }
    }
}

