/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.utils;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.compatibility.FoliaCompatibilityManager;
import fr.ax_dev.universejobs.utils.MessageUtils;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class MessageBatch {
    private final UniverseJobs plugin;
    private final FoliaCompatibilityManager foliaManager;
    private final Map<UUID, Queue<PendingMessage>> pendingMessages = new ConcurrentHashMap<UUID, Queue<PendingMessage>>();
    private ScheduledTask batchProcessor;
    private boolean isRunning = false;
    private long lastProcessTime = System.currentTimeMillis();

    public MessageBatch(UniverseJobs plugin) {
        this.plugin = plugin;
        this.foliaManager = plugin.getFoliaManager();
    }

    public void queueMessage(Player player, MessageType type, String content, int duration) {
        UUID playerId = player.getUniqueId();
        PendingMessage message = new PendingMessage(type, content, duration, System.currentTimeMillis());
        this.pendingMessages.computeIfAbsent(playerId, k -> new ConcurrentLinkedQueue()).offer(message);
        if (!this.isRunning) {
            this.startBatchProcessor();
        }
    }

    private void startBatchProcessor() {
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        this.batchProcessor = this.plugin.getServer().getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin, scheduledTask -> {
            if (this.pendingMessages.isEmpty()) {
                if (System.currentTimeMillis() - this.lastProcessTime > 10000L) {
                    this.isRunning = false;
                    scheduledTask.cancel();
                    return;
                }
                return;
            }
            this.processBatch();
            this.lastProcessTime = System.currentTimeMillis();
        }, 2L, 2L);
    }

    private void processBatch() {
        for (Map.Entry<UUID, Queue<PendingMessage>> entry2 : this.pendingMessages.entrySet()) {
            PendingMessage message;
            UUID playerId = entry2.getKey();
            Queue<PendingMessage> messages = entry2.getValue();
            if (messages.isEmpty()) continue;
            Player player = this.plugin.getServer().getPlayer(playerId);
            if (player == null || !player.isOnline()) {
                messages.clear();
                continue;
            }
            PendingMessage latestActionBar = null;
            PendingMessage latestBossBar = null;
            while ((message = messages.poll()) != null) {
                switch (message.type.ordinal()) {
                    case 1: {
                        latestActionBar = message;
                        break;
                    }
                    case 2: {
                        latestBossBar = message;
                        break;
                    }
                    case 0: {
                        this.foliaManager.runAtEntity((Entity)player, () -> {
                            if (player.isOnline()) {
                                MessageUtils.sendMessage(player, message.content);
                            }
                        });
                    }
                }
            }
            if (latestActionBar != null) {
                this.sendActionBarBatched(player, latestActionBar);
            }
            if (latestBossBar == null) continue;
            this.sendBossBarBatched(player, latestBossBar);
        }
        this.pendingMessages.entrySet().removeIf(entry -> ((Queue)entry.getValue()).isEmpty());
    }

    private void sendActionBarBatched(Player player, PendingMessage message) {
        this.foliaManager.runAtEntity((Entity)player, () -> {
            if (player.isOnline()) {
                player.sendActionBar(MessageUtils.parseMessage(message.content));
                if (message.duration > 0) {
                    this.foliaManager.runLater(() -> this.foliaManager.runAtEntity((Entity)player, () -> {
                        if (player.isOnline()) {
                            player.sendActionBar(MessageUtils.parseMessage(""));
                        }
                    }), message.duration);
                }
            }
        });
    }

    private void sendBossBarBatched(Player player, PendingMessage message) {
        this.foliaManager.runAtEntity((Entity)player, () -> {
            if (player.isOnline()) {
                this.plugin.getXpMessageSender().sendProgressUpdate(player, message.content, 1.0, message.duration);
            }
        });
    }

    public void cleanupPlayer(UUID playerId) {
        this.pendingMessages.remove(playerId);
    }

    public void shutdown() {
        if (this.batchProcessor != null) {
            this.batchProcessor.cancel();
        }
        this.pendingMessages.clear();
        this.isRunning = false;
    }

    private record PendingMessage(MessageType type, String content, int duration, long timestamp) {
    }

    public static enum MessageType {
        CHAT,
        ACTIONBAR,
        BOSSBAR;

    }
}

