/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs;

import fr.ax_dev.universejobs.action.ActionLimitManager;
import fr.ax_dev.universejobs.action.ActionProcessor;
import fr.ax_dev.universejobs.bonus.MoneyBonusManager;
import fr.ax_dev.universejobs.bonus.XpBonusManager;
import fr.ax_dev.universejobs.cache.ConfigurationCache;
import fr.ax_dev.universejobs.cache.PlayerJobCache;
import fr.ax_dev.universejobs.command.JobCommand;
import fr.ax_dev.universejobs.compatibility.FoliaCompatibilityManager;
import fr.ax_dev.universejobs.config.ConfigManager;
import fr.ax_dev.universejobs.config.LanguageManager;
import fr.ax_dev.universejobs.integration.MythicMobsHandler;
import fr.ax_dev.universejobs.job.JobManager;
import fr.ax_dev.universejobs.levelup.SimpleLevelUpActionManager;
import fr.ax_dev.universejobs.listener.CustomCropsEventListener;
import fr.ax_dev.universejobs.listener.CustomFishingEventListener;
import fr.ax_dev.universejobs.listener.EnchantEventListener;
import fr.ax_dev.universejobs.listener.ItemsAdderEventListener;
import fr.ax_dev.universejobs.listener.JobActionListener;
import fr.ax_dev.universejobs.listener.NexoEventListener;
import fr.ax_dev.universejobs.menu.BoostManagerGui;
import fr.ax_dev.universejobs.menu.MenuManager;
import fr.ax_dev.universejobs.placeholder.PlaceholderManager;
import fr.ax_dev.universejobs.protection.BlockProtectionManager;
import fr.ax_dev.universejobs.reward.RewardManager;
import fr.ax_dev.universejobs.reward.gui.RewardGuiManager;
import fr.ax_dev.universejobs.utils.AsyncXpMessageSender;
import fr.ax_dev.universejobs.utils.PluginAccessor;
import java.util.logging.Level;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public final class UniverseJobs
extends JavaPlugin
implements Listener {
    private static volatile UniverseJobs instance;
    private ConfigManager configManager;
    private LanguageManager languageManager;
    private FoliaCompatibilityManager foliaManager;
    private JobManager jobManager;
    private SimpleLevelUpActionManager levelUpActionManager;
    private ActionProcessor actionProcessor;
    private ActionLimitManager limitManager;
    private XpBonusManager bonusManager;
    private MoneyBonusManager moneyBonusManager;
    private AsyncXpMessageSender messageSender;
    private BlockProtectionManager protectionManager;
    private RewardManager rewardManager;
    private RewardGuiManager rewardGuiManager;
    private MenuManager menuManager;
    private BoostManagerGui boostManagerGui;
    private PlaceholderManager placeholderManager;
    private MythicMobsHandler mythicMobsHandler;
    private BukkitTask saveTask;
    private long startTime;
    private PluginAccessor accessor;
    private ConfigurationCache configCache;
    private PlayerJobCache playerCache;

    public void onEnable() {
        UniverseJobs.setInstance(this);
        this.startTime = System.currentTimeMillis();
        this.configManager = new ConfigManager(this);
        this.languageManager = new LanguageManager(this);
        this.foliaManager = new FoliaCompatibilityManager(this);
        this.jobManager = new JobManager(this);
        this.levelUpActionManager = new SimpleLevelUpActionManager(this);
        this.limitManager = new ActionLimitManager(this);
        this.bonusManager = new XpBonusManager(this);
        this.moneyBonusManager = new MoneyBonusManager(this);
        this.messageSender = new AsyncXpMessageSender(this);
        this.protectionManager = new BlockProtectionManager(this);
        this.rewardManager = new RewardManager(this);
        this.rewardGuiManager = new RewardGuiManager(this, this.rewardManager);
        this.menuManager = new MenuManager(this);
        this.boostManagerGui = new BoostManagerGui(this);
        this.placeholderManager = new PlaceholderManager(this);
        this.mythicMobsHandler = new MythicMobsHandler(this);
        this.getLogger().info("Initializing ultra-fast cache system...");
        this.configCache = new ConfigurationCache(this);
        this.playerCache = new PlayerJobCache(this);
        this.actionProcessor = new ActionProcessor(this, this.jobManager, this.bonusManager, this.moneyBonusManager, this.messageSender, this.limitManager, this.configCache, this.playerCache);
        try {
            this.configManager.loadConfig();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to load configuration", e);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        try {
            this.jobManager.loadJobs();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to load jobs", e);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        try {
            this.configCache.loadAllConfigurations();
            this.playerCache.preloadOnlinePlayers();
            this.getLogger().info("Ultra-fast cache system loaded!");
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to initialize cache system", e);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        try {
            this.levelUpActionManager.loadJobActions();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to load level up actions", e);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        try {
            this.rewardManager.initialize();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to initialize reward system", e);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        JobCommand jobCommand = new JobCommand(this, this.jobManager);
        this.getCommand("jobs").setExecutor((CommandExecutor)jobCommand);
        this.getCommand("jobs").setTabCompleter((TabCompleter)jobCommand);
        this.getServer().getPluginManager().registerEvents((Listener)new JobActionListener(this, this.actionProcessor, this.protectionManager, this.mythicMobsHandler, this.configCache, this.playerCache), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EnchantEventListener(this, this.actionProcessor), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        if (this.mythicMobsHandler.isAvailable()) {
            this.getServer().getPluginManager().registerEvents((Listener)this.mythicMobsHandler, (Plugin)this);
        }
        if (this.getServer().getPluginManager().isPluginEnabled("Nexo")) {
            this.getServer().getPluginManager().registerEvents((Listener)new NexoEventListener(this, this.actionProcessor, this.protectionManager), (Plugin)this);
        }
        if (this.getServer().getPluginManager().isPluginEnabled("ItemsAdder")) {
            this.getServer().getPluginManager().registerEvents((Listener)new ItemsAdderEventListener(this, this.actionProcessor, this.protectionManager), (Plugin)this);
        }
        if (this.getServer().getPluginManager().isPluginEnabled("CustomCrops")) {
            this.getServer().getPluginManager().registerEvents((Listener)new CustomCropsEventListener(this, this.actionProcessor, this.protectionManager), (Plugin)this);
        }
        if (this.getServer().getPluginManager().isPluginEnabled("CustomFishing")) {
            this.getLogger().info("CustomFishing plugin detected - registering event listener");
            this.getServer().getPluginManager().registerEvents((Listener)new CustomFishingEventListener(this, this.actionProcessor), (Plugin)this);
            this.getLogger().info("CustomFishing event listener registered successfully");
        } else {
            this.getLogger().info("CustomFishing plugin not found - skipping CustomFishing integration");
        }
        for (Player player : this.getServer().getOnlinePlayers()) {
            this.foliaManager.runAsync(() -> {
                this.jobManager.loadPlayerData(player);
                this.rewardManager.loadPlayerData(player);
                this.playerCache.preloadPlayer(player.getUniqueId());
            });
        }
        try {
            this.placeholderManager.initialize();
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Failed to initialize PlaceholderAPI integration", e);
        }
        this.startSaveTask();
        this.checkDependencies();
        this.accessor = new PluginAccessor(this);
    }

    public void onDisable() {
        this.getLogger().info("Shutting down UniverseJobs plugin...");
        try {
            this.stopSaveTask();
            this.savePlayerData();
            this.shutdownManagers();
            this.getLogger().info("UniverseJobs plugin shutdown completed successfully");
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Critical error during plugin shutdown", e);
        }
        finally {
            UniverseJobs.setInstance(null);
        }
    }

    private void stopSaveTask() {
        if (this.saveTask != null && !this.saveTask.isCancelled()) {
            this.saveTask.cancel();
            this.saveTask = null;
        }
    }

    private void savePlayerData() {
        if (this.jobManager != null) {
            this.getLogger().info("Saving all player data...");
            this.jobManager.saveAllPlayerData();
        }
    }

    private void shutdownManagers() {
        this.getLogger().info("Shutting down managers...");
        this.shutdownRewardGuiManager();
        this.shutdownManagerSafely("menu manager", this.menuManager, () -> this.menuManager.closeAllMenus());
        this.shutdownManagerSafely("reward manager", this.rewardManager, () -> this.rewardManager.shutdown());
        this.shutdownManagerSafely("message sender", this.messageSender, () -> this.messageSender.shutdown());
        this.shutdownManagerSafely("bonus manager", this.bonusManager, () -> this.bonusManager.shutdown());
        this.shutdownManagerSafely("money bonus manager", this.moneyBonusManager, () -> this.moneyBonusManager.shutdown());
        this.shutdownManagerSafely("placeholder manager", this.placeholderManager, () -> this.placeholderManager.shutdown());
        this.shutdownManagerSafely("job manager", this.jobManager, () -> this.jobManager.shutdown());
        this.shutdownManagerSafely("action limit manager", this.limitManager, () -> this.limitManager.clearAllLimits());
        this.shutdownManagerSafely("Folia manager", this.foliaManager, () -> this.foliaManager.cancelAllTasks());
        this.protectionManager = null;
        this.actionProcessor = null;
        this.languageManager = null;
        this.configManager = null;
    }

    private void shutdownRewardGuiManager() {
        if (this.rewardGuiManager != null) {
            try {
                for (Player player : this.getServer().getOnlinePlayers()) {
                    if (player.getOpenInventory() == null) continue;
                    player.closeInventory();
                }
                this.rewardGuiManager = null;
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "Error shutting down reward GUI manager", e);
            }
        }
    }

    private void shutdownManagerSafely(String managerName, Object manager, Runnable shutdownAction) {
        if (manager != null) {
            try {
                shutdownAction.run();
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "Error shutting down " + managerName, e);
            }
        }
    }

    private void startSaveTask() {
        int saveInterval = this.configManager.getSaveInterval();
        if (saveInterval > 0) {
            this.foliaManager.runTimerAsync(() -> {
                if (this.configManager.isDebugEnabled()) {
                    this.getLogger().info("Auto-saving player data...");
                }
                this.jobManager.saveAllPlayerData();
            }, (long)saveInterval * 20L, (long)saveInterval * 20L);
        }
    }

    private void checkDependencies() {
        StringBuilder dependencyStatus = new StringBuilder("Dependency status: ");
        if (this.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            dependencyStatus.append("PlaceholderAPI \u2713 ");
        } else {
            dependencyStatus.append("PlaceholderAPI \u2717 ");
        }
        if (this.getServer().getPluginManager().isPluginEnabled("MythicMobs")) {
            dependencyStatus.append("MythicMobs \u2713 ");
        } else {
            dependencyStatus.append("MythicMobs \u2717 ");
        }
        if (this.getServer().getPluginManager().isPluginEnabled("MMOItems")) {
            dependencyStatus.append("MMOItems \u2713 ");
        } else {
            dependencyStatus.append("MMOItems \u2717 ");
        }
        if (this.getServer().getPluginManager().isPluginEnabled("Nexo")) {
            dependencyStatus.append("Nexo \u2713 ");
        } else {
            dependencyStatus.append("Nexo \u2717 ");
        }
        if (this.getServer().getPluginManager().isPluginEnabled("ItemsAdder")) {
            dependencyStatus.append("ItemsAdder \u2713 ");
        } else {
            dependencyStatus.append("ItemsAdder \u2717 ");
        }
        if (this.getServer().getPluginManager().isPluginEnabled("CustomCrops")) {
            dependencyStatus.append("CustomCrops \u2713 ");
        } else {
            dependencyStatus.append("CustomCrops \u2717 ");
        }
        if (this.getServer().getPluginManager().isPluginEnabled("CustomFishing")) {
            dependencyStatus.append("CustomFishing \u2713");
        } else {
            dependencyStatus.append("CustomFishing \u2717");
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.foliaManager.runAsync(() -> {
            this.jobManager.loadPlayerData(event.getPlayer());
            this.rewardManager.loadPlayerData(event.getPlayer());
            this.playerCache.preloadPlayer(event.getPlayer().getUniqueId());
            if (this.configCache.isDebugEnabled()) {
                this.getLogger().info("Loaded data and preloaded cache for player: " + event.getPlayer().getName());
            }
        });
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (this.messageSender != null) {
            this.messageSender.cleanupPlayer(event.getPlayer());
        }
        this.playerCache.cleanupPlayer(event.getPlayer().getUniqueId());
        this.foliaManager.runAsync(() -> {
            this.jobManager.savePlayerData(event.getPlayer());
            this.rewardManager.unloadPlayerData(event.getPlayer());
            if (this.configCache.isDebugEnabled()) {
                this.getLogger().info("Saved data for player: " + event.getPlayer().getName());
            }
        });
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public FoliaCompatibilityManager getFoliaManager() {
        return this.foliaManager;
    }

    public JobManager getJobManager() {
        return this.jobManager;
    }

    public ActionProcessor getActionProcessor() {
        return this.actionProcessor;
    }

    public XpBonusManager getBonusManager() {
        return this.bonusManager;
    }

    public MoneyBonusManager getMoneyBonusManager() {
        return this.moneyBonusManager;
    }

    public AsyncXpMessageSender getMessageSender() {
        return this.messageSender;
    }

    public AsyncXpMessageSender getXpMessageSender() {
        return this.messageSender;
    }

    public BlockProtectionManager getProtectionManager() {
        return this.protectionManager;
    }

    public RewardManager getRewardManager() {
        return this.rewardManager;
    }

    public RewardGuiManager getRewardGuiManager() {
        return this.rewardGuiManager;
    }

    public MenuManager getMenuManager() {
        return this.menuManager;
    }

    public BoostManagerGui getBoostManagerGui() {
        return this.boostManagerGui;
    }

    public ConfigurationCache getConfigCache() {
        return this.configCache;
    }

    public PlayerJobCache getPlayerCache() {
        return this.playerCache;
    }

    public PlaceholderManager getPlaceholderManager() {
        return this.placeholderManager;
    }

    public MythicMobsHandler getMythicMobsHandler() {
        return this.mythicMobsHandler;
    }

    public ActionLimitManager getLimitManager() {
        return this.limitManager;
    }

    public SimpleLevelUpActionManager getLevelUpActionManager() {
        return this.levelUpActionManager;
    }

    public static synchronized UniverseJobs getInstance() {
        return instance;
    }

    public PluginAccessor getAccessor() {
        return this.accessor;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public Object getPerformanceManager() {
        return null;
    }

    private static synchronized void setInstance(UniverseJobs newInstance) {
        instance = newInstance;
    }
}

