/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.bonus;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.bonus.BaseBonus;
import fr.ax_dev.universejobs.bonus.BonusManager;
import fr.ax_dev.universejobs.compatibility.FoliaCompatibilityManager;
import fr.ax_dev.universejobs.config.ConfigManager;
import fr.ax_dev.universejobs.utils.MessageUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public abstract class BaseBonusManager<T extends BaseBonus>
implements BonusManager<T> {
    protected final UniverseJobs plugin;
    protected final FoliaCompatibilityManager foliaManager;
    protected final Map<UUID, List<T>> playerBonuses = new ConcurrentHashMap<UUID, List<T>>();
    protected final Map<String, T> boostIdMap = new ConcurrentHashMap<String, T>();
    protected boolean cleanupRunning = false;
    protected int nextBoostCounter = 1;

    protected BaseBonusManager(UniverseJobs plugin) {
        this.plugin = plugin;
        this.foliaManager = plugin.getFoliaManager();
        this.startCleanupTask();
    }

    protected abstract T createBonus(UUID var1, String var2, double var3, long var5, String var7, String var8, String var9, boolean var10, String var11, String var12);

    protected abstract String getBonusTypeName();

    protected String generateBoostId() {
        String prefix = this.getBonusTypeName().toLowerCase();
        if (prefix.endsWith("bonus")) {
            prefix = prefix.substring(0, prefix.length() - 5);
        }
        return prefix + this.nextBoostCounter++;
    }

    @Override
    public int addGlobalBonus(double multiplier, long duration, String reason, String grantedBy) {
        int count = 0;
        for (Player player : Bukkit.getOnlinePlayers()) {
            String boostId = this.generateBoostId();
            T bonus = this.createBonus(player.getUniqueId(), null, multiplier, duration, reason, grantedBy, boostId, true, null, null);
            this.addBonus(bonus);
            ++count;
        }
        if (count > 0) {
            String message = "Global " + this.getBonusTypeName() + " bonus started: " + multiplier + "x for " + this.formatDuration(duration);
            for (Player player : Bukkit.getOnlinePlayers()) {
                MessageUtils.sendMessage(player, message);
            }
        }
        return count;
    }

    @Override
    public void addPlayerBonus(UUID playerId, double multiplier, long duration, String reason, String grantedBy) {
        String boostId = this.generateBoostId();
        T bonus = this.createBonus(playerId, null, multiplier, duration, reason, grantedBy, boostId, false, null, null);
        this.addBonus(bonus);
    }

    @Override
    public void addJobBonus(UUID playerId, String jobId, double multiplier, long duration, String reason, String grantedBy) {
        String boostId = this.generateBoostId();
        T bonus = this.createBonus(playerId, jobId, multiplier, duration, reason, grantedBy, boostId, false, null, null);
        this.addBonus(bonus);
    }

    public void addActionBonus(UUID playerId, String jobId, String actionType, String actionId, double multiplier, long duration, String reason, String grantedBy, boolean isGlobal) {
        String boostId = this.generateBoostId();
        T bonus = this.createBonus(playerId, jobId, multiplier, duration, reason, grantedBy, boostId, isGlobal, actionType, actionId);
        this.addBonus(bonus);
    }

    protected void addBonus(T bonus) {
        this.playerBonuses.computeIfAbsent(((BaseBonus)bonus).getPlayerId(), k -> new ArrayList()).add(bonus);
        this.boostIdMap.put(((BaseBonus)bonus).getBoostId(), bonus);
        Player player = Bukkit.getPlayer((UUID)((BaseBonus)bonus).getPlayerId());
        if (player != null) {
            String message = this.getBonusTypeName() + " boost [" + ((BaseBonus)bonus).getBoostId() + "] received: " + ((BaseBonus)bonus).getMultiplier() + "x for " + ((BaseBonus)bonus).getRemainingTimeFormatted();
            if (((BaseBonus)bonus).getJobId() != null) {
                message = message + " (Job: " + ((BaseBonus)bonus).getJobId() + ")";
            }
            MessageUtils.sendMessage(player, message);
        }
    }

    @Override
    public List<T> getActiveBonuses(UUID playerId) {
        List<T> bonuses = this.playerBonuses.get(playerId);
        if (bonuses == null) {
            return new ArrayList();
        }
        return bonuses.stream().filter(BaseBonus::isActive).collect(Collectors.toList());
    }

    @Override
    public List<T> getActiveBonuses(UUID playerId, String jobId) {
        return this.getActiveBonuses(playerId).stream().filter(bonus -> bonus.appliesTo(jobId)).collect(Collectors.toList());
    }

    @Override
    public boolean removeBonus(T bonus) {
        List<T> bonuses = this.playerBonuses.get(((BaseBonus)bonus).getPlayerId());
        if (bonuses != null) {
            boolean removed = bonuses.remove(bonus);
            if (removed) {
                this.boostIdMap.remove(((BaseBonus)bonus).getBoostId());
                if (bonuses.isEmpty()) {
                    this.playerBonuses.remove(((BaseBonus)bonus).getPlayerId());
                }
            }
            return removed;
        }
        return false;
    }

    public boolean removeBoostById(String boostId) {
        BaseBonus bonus = (BaseBonus)this.boostIdMap.get(boostId);
        if (bonus != null) {
            return this.removeBonus((T)bonus);
        }
        return false;
    }

    public T getBoostById(String boostId) {
        return (T)((BaseBonus)this.boostIdMap.get(boostId));
    }

    public List<String> getAllActiveBoostIds() {
        return this.boostIdMap.values().stream().filter(BaseBonus::isActive).map(BaseBonus::getBoostId).collect(Collectors.toList());
    }

    @Override
    public int removeAllBonuses(UUID playerId) {
        List<T> bonuses = this.playerBonuses.remove(playerId);
        if (bonuses != null) {
            for (BaseBonus bonus : bonuses) {
                this.boostIdMap.remove(bonus.getBoostId());
            }
            return bonuses.size();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupExpiredBonuses() {
        if (this.cleanupRunning) {
            return;
        }
        this.cleanupRunning = true;
        try {
            int cleaned = 0;
            Iterator<Map.Entry<UUID, List<T>>> iterator = this.playerBonuses.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<UUID, List<T>> entry = iterator.next();
                List<T> bonuses = entry.getValue();
                int sizeBefore = bonuses.size();
                Iterator<T> bonusIterator = bonuses.iterator();
                while (bonusIterator.hasNext()) {
                    BaseBonus bonus = (BaseBonus)bonusIterator.next();
                    if (bonus.isActive()) continue;
                    bonusIterator.remove();
                    this.boostIdMap.remove(bonus.getBoostId());
                    ++cleaned;
                }
                if (!bonuses.isEmpty()) continue;
                iterator.remove();
            }
            if (cleaned > 0) {
                this.plugin.getLogger().info("Cleaned up " + cleaned + " expired " + this.getBonusTypeName().toLowerCase() + " bonuses");
            }
        }
        finally {
            this.cleanupRunning = false;
        }
    }

    @Override
    public Map<String, Object> getStats() {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        stats.put("totalPlayers", this.playerBonuses.size());
        stats.put("totalBonuses", this.playerBonuses.values().stream().mapToInt(List::size).sum());
        stats.put("activeBonuses", this.playerBonuses.values().stream().flatMap(Collection::stream).mapToInt(bonus -> bonus.isActive() ? 1 : 0).sum());
        return stats;
    }

    public double getTotalMultiplier(UUID playerId, String jobId) {
        List<T> activeBonuses = this.getActiveBonuses(playerId, jobId);
        if (activeBonuses.isEmpty()) {
            return 1.0;
        }
        ConfigManager.BoostCalculationMode mode = this.plugin.getConfigManager().getBoostCalculationMode();
        switch (mode) {
            case ADDITIVE: {
                double sum = 0.0;
                for (BaseBonus bonus : activeBonuses) {
                    sum += bonus.getMultiplier() - 1.0;
                }
                return 1.0 + sum;
            }
            case MULTIPLICATIVE: {
                double product = 1.0;
                for (BaseBonus bonus : activeBonuses) {
                    product *= bonus.getMultiplier();
                }
                return product;
            }
            case HIGHEST: {
                double highest = 1.0;
                for (BaseBonus bonus : activeBonuses) {
                    if (!(bonus.getMultiplier() > highest)) continue;
                    highest = bonus.getMultiplier();
                }
                return highest;
            }
        }
        double defaultProduct = 1.0;
        for (BaseBonus bonus : activeBonuses) {
            defaultProduct *= bonus.getMultiplier();
        }
        return defaultProduct;
    }

    private void startCleanupTask() {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, this::cleanupExpiredBonuses, 1200L, 1200L);
    }

    public void shutdown() {
        this.cleanupRunning = false;
    }

    private String formatDuration(long seconds) {
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        long secs = seconds % 60L;
        if (hours > 0L) {
            return String.format("%dh %dm %ds", hours, minutes, secs);
        }
        if (minutes > 0L) {
            return String.format("%dm %ds", minutes, secs);
        }
        return String.format("%ds", secs);
    }

    public Set<UUID> getPlayersWithActiveBonuses() {
        return this.playerBonuses.entrySet().stream().filter(entry -> ((List)entry.getValue()).stream().anyMatch(BaseBonus::isActive)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Set<String> getJobsWithActiveBonuses(UUID playerId) {
        List<T> bonuses = this.getActiveBonuses(playerId);
        return bonuses.stream().map(BaseBonus::getJobId).filter(Objects::nonNull).collect(Collectors.toSet());
    }
}

