/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.command.handler;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.action.ActionType;
import fr.ax_dev.universejobs.action.JobAction;
import fr.ax_dev.universejobs.bonus.BaseBonus;
import fr.ax_dev.universejobs.bonus.MoneyBonus;
import fr.ax_dev.universejobs.bonus.XpBonus;
import fr.ax_dev.universejobs.command.handler.JobCommandHandler;
import fr.ax_dev.universejobs.job.Job;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class BoostCommandHandler
extends JobCommandHandler {
    private static final String CMD_GIVE = "give";
    private static final String CMD_REMOVE = "remove";
    private static final String CMD_INFO = "info";
    private static final String TYPE_XP = "xp";
    private static final String TYPE_MONEY = "money";
    private static final String PERM_BOOST_ADMIN = "universejobs.admin.boost";

    public BoostCommandHandler(UniverseJobs plugin) {
        super(plugin);
    }

    @Override
    public boolean handleCommand(CommandSender sender, String[] args) {
        String action;
        if (!this.hasPermission(sender, PERM_BOOST_ADMIN)) {
            sender.sendMessage(this.languageManager.getMessage("commands.no-permission"));
            return true;
        }
        if (args.length < 3) {
            this.sendBoostHelp(sender);
            return true;
        }
        switch (action = args[2].toLowerCase()) {
            case "give": {
                this.handleGiveBoost(sender, args);
                break;
            }
            case "remove": {
                this.handleRemoveBoost(sender, args);
                break;
            }
            case "info": {
                this.handleInfoBoost(sender, args);
                break;
            }
            default: {
                this.sendBoostHelp(sender);
            }
        }
        return true;
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        if (!this.hasPermission(sender, PERM_BOOST_ADMIN)) {
            return new ArrayList<String>();
        }
        int offset = args.length >= 3 && "boost".equals(args[2]) ? 1 : 0;
        int adjustedLength = args.length - offset;
        String action = args.length > 2 + offset ? args[2 + offset].toLowerCase() : "";
        return switch (adjustedLength) {
            case 3 -> Arrays.asList(CMD_GIVE, CMD_REMOVE, CMD_INFO).stream().filter(cmd -> cmd.startsWith(action)).collect(Collectors.toList());
            case 4 -> {
                if (CMD_REMOVE.equals(action)) {
                    yield this.getActiveBoostIds(args, offset);
                }
                if (CMD_GIVE.equals(action)) {
                    yield this.getTypeCompletions(args, offset);
                }
                yield new ArrayList();
            }
            case 5 -> this.getPlayerCompletions(args, offset);
            case 6 -> this.getJobCompletions(args, offset);
            case 7 -> this.getActionTypeCompletions(args, offset);
            case 8 -> this.getActionIdOrMultiplierCompletions(args, offset);
            case 9 -> this.getMultiplierOrDurationCompletions(args, offset);
            case 10 -> this.getDurationCompletions(args, offset);
            default -> new ArrayList();
        };
    }

    private List<String> getTypeCompletions(String[] args, int offset) {
        String action = args[2 + offset].toLowerCase();
        if (action.equals(CMD_GIVE) || action.equals(CMD_REMOVE)) {
            return Arrays.asList(TYPE_XP, TYPE_MONEY).stream().filter(type -> type.startsWith(args[3 + offset].toLowerCase())).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    private List<String> getPlayerCompletions(String[] args, int offset) {
        String action = args[2 + offset].toLowerCase();
        if (action.equals(CMD_GIVE)) {
            ArrayList<String> players = new ArrayList<String>();
            players.add("*");
            players.addAll(Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[4 + offset].toLowerCase())).collect(Collectors.toList()));
            return players;
        }
        return new ArrayList<String>();
    }

    private List<String> getDurationCompletions(String[] args, int offset) {
        int durationArgIndex;
        String action = args[2 + offset].toLowerCase();
        if (action.equals(CMD_GIVE) && args.length > (durationArgIndex = args.length > 6 + offset && args[6 + offset].equals("*") ? 8 + offset : 9 + offset)) {
            return Arrays.asList("300", "600", "1800", "3600", "7200").stream().filter(dur -> dur.startsWith(args[durationArgIndex])).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    private List<String> getJobCompletions(String[] args, int offset) {
        String action = args[2 + offset].toLowerCase();
        if (action.equals(CMD_GIVE)) {
            ArrayList<String> jobs = new ArrayList<String>();
            jobs.add("*");
            jobs.addAll(this.plugin.getJobManager().getJobs().keySet().stream().filter(id -> id.toLowerCase().startsWith(args[5 + offset].toLowerCase())).collect(Collectors.toList()));
            return jobs;
        }
        return new ArrayList<String>();
    }

    private List<String> getActionTypeCompletions(String[] args, int offset) {
        String action = args[2 + offset].toLowerCase();
        if (action.equals(CMD_GIVE) && args.length > 5 + offset) {
            String jobId = args[5 + offset];
            ArrayList<String> actionTypes = new ArrayList<String>();
            actionTypes.add("*");
            if (jobId.equals("*")) {
                HashSet<String> allActionTypes = new HashSet<String>();
                for (Job job : this.plugin.getJobManager().getJobs().values()) {
                    for (ActionType actionType : job.getActions().keySet()) {
                        allActionTypes.add(actionType.name());
                    }
                }
                actionTypes.addAll(allActionTypes);
            } else {
                Job job = this.plugin.getJobManager().getJob(jobId);
                if (job != null) {
                    for (ActionType actionType : job.getActions().keySet()) {
                        actionTypes.add(actionType.name());
                    }
                }
            }
            return actionTypes.stream().distinct().sorted().filter(act -> act.toLowerCase().startsWith(args[6 + offset].toLowerCase())).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    private List<String> getActionIdOrMultiplierCompletions(String[] args, int offset) {
        String action = args[2 + offset].toLowerCase();
        if (action.equals(CMD_GIVE) && args.length > 6 + offset) {
            String actionType = args[6 + offset];
            if (actionType.equals("*")) {
                return Arrays.asList("1.0", "1.5", "2.0", "2.5", "3.0").stream().filter(mult -> mult.startsWith(args[7 + offset])).collect(Collectors.toList());
            }
            return this.getActionIdCompletions(args, offset);
        }
        return new ArrayList<String>();
    }

    private List<String> getMultiplierOrDurationCompletions(String[] args, int offset) {
        String action = args[2 + offset].toLowerCase();
        if (action.equals(CMD_GIVE) && args.length > 6 + offset) {
            String actionType = args[6 + offset];
            if (actionType.equals("*")) {
                return Arrays.asList("300", "600", "1800", "3600", "7200").stream().filter(dur -> dur.startsWith(args[8 + offset])).collect(Collectors.toList());
            }
            return Arrays.asList("1.0", "1.5", "2.0", "2.5", "3.0").stream().filter(mult -> mult.startsWith(args[8 + offset])).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    private List<String> getActionIdCompletions(String[] args, int offset) {
        String action = args[2 + offset].toLowerCase();
        if (action.equals(CMD_GIVE) && args.length > 6 + offset) {
            String actionType = args[6 + offset].toUpperCase();
            String jobId = args.length > 5 + offset ? args[5 + offset] : "*";
            ArrayList<String> ids = new ArrayList<String>();
            ids.add("*");
            if (jobId.equals("*")) {
                for (Job job : this.plugin.getJobManager().getJobs().values()) {
                    ids.addAll(this.getJobActionIds(job, actionType));
                }
            } else {
                Job job = this.plugin.getJobManager().getJob(jobId);
                if (job != null) {
                    ids.addAll(this.getJobActionIds(job, actionType));
                }
            }
            return ids.stream().distinct().filter(id -> id.toLowerCase().startsWith(args[7 + offset].toLowerCase())).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    private List<String> getJobActionIds(Job job, String actionType) {
        ArrayList<String> actionIds = new ArrayList<String>();
        try {
            YamlConfiguration jobConfig;
            ConfigurationSection actionSection;
            File jobFile = new File(this.plugin.getDataFolder(), "jobs/" + job.getId() + ".yml");
            if (jobFile.exists() && (actionSection = (jobConfig = YamlConfiguration.loadConfiguration((File)jobFile)).getConfigurationSection("actions." + actionType)) != null) {
                actionIds.addAll(actionSection.getKeys(false));
                return actionIds;
            }
        }
        catch (Exception jobFile) {
            // empty catch block
        }
        try {
            ActionType enumActionType = ActionType.valueOf(actionType.toUpperCase());
            List<JobAction> actions = job.getActions(enumActionType);
            if (actions != null) {
                for (JobAction action : actions) {
                    actionIds.add(action.getName());
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return actionIds;
    }

    private List<String> getActiveBoostIds(String[] args, int offset) {
        ArrayList<String> allBoosts = new ArrayList<String>();
        allBoosts.addAll(this.plugin.getBonusManager().getAllActiveBoostIds());
        allBoosts.addAll(this.plugin.getMoneyBonusManager().getAllActiveBoostIds());
        String input = args.length > 3 + offset ? args[3 + offset].toLowerCase() : "";
        return allBoosts.stream().filter(boostId -> boostId.toLowerCase().startsWith(input)).sorted().collect(Collectors.toList());
    }

    private void handleGiveBoost(CommandSender sender, String[] args) {
        long duration;
        double multiplier;
        if (args.length < 9) {
            sender.sendMessage("\u00a7cUsage: /jobs admin boost give <xp|money> <player/*> <job/*> <action_type> [id_in_action] <multiplier> <duration>");
            sender.sendMessage("\u00a77Examples:");
            sender.sendMessage("\u00a77  /jobs admin boost give xp * miner * 2.0 3600");
            sender.sendMessage("\u00a77  /jobs admin boost give money Player123 * BREAK simple_break 1.5 1800");
            return;
        }
        String boostType = args[3].toLowerCase();
        if (!boostType.equals(TYPE_XP) && !boostType.equals(TYPE_MONEY)) {
            sender.sendMessage("\u00a7cInvalid boost type! Use: xp or money");
            return;
        }
        String target = this.sanitizeInputWithWildcard(args[4]);
        if (!target.equals("*") && !this.isValidPlayerName(target)) {
            sender.sendMessage("\u00a7cInvalid player name!");
            return;
        }
        String jobId = this.sanitizeInputWithWildcard(args[5]);
        if (!jobId.equals("*") && !this.isValidJobId(jobId)) {
            sender.sendMessage("\u00a7cInvalid job ID!");
            return;
        }
        String actionType = this.sanitizeInputWithWildcard(args[6]);
        if (!actionType.equals("*") && !this.isValidActionType(actionType)) {
            sender.sendMessage("\u00a7cInvalid action type!");
            return;
        }
        String actionId = "*";
        if (actionType.equals("*")) {
            multiplier = this.parseMultiplier(args[7]);
            if (multiplier <= 0.0) {
                sender.sendMessage("\u00a7cInvalid multiplier! Must be between 0.1 and 10.0");
                return;
            }
            duration = this.parseDuration(args[8]);
            if (duration <= 0L) {
                sender.sendMessage("\u00a7cInvalid duration! Must be between 1 and 86400 seconds");
                return;
            }
        } else {
            if (args.length < 10) {
                sender.sendMessage("\u00a7cWhen using specific action type, id_in_action is required!");
                sender.sendMessage("\u00a77Usage: /jobs admin boost give <xp|money> <player/*> <job/*> <action_type> <id_in_action> <multiplier> <duration>");
                return;
            }
            actionId = this.sanitizeInputWithWildcard(args[7]);
            if (!actionId.equals("*") && !this.isValidActionId(actionType, actionId)) {
                sender.sendMessage("\u00a7cInvalid action ID for type " + actionType + "!");
                return;
            }
            multiplier = this.parseMultiplier(args[8]);
            if (multiplier <= 0.0) {
                sender.sendMessage("\u00a7cInvalid multiplier! Must be between 0.1 and 10.0");
                return;
            }
            duration = this.parseDuration(args[9]);
            if (duration <= 0L) {
                sender.sendMessage("\u00a7cInvalid duration! Must be between 1 and 86400 seconds");
                return;
            }
        }
        String reason = "Admin boost";
        String senderName = sender instanceof Player ? sender.getName() : "Console";
        this.applyBoost(boostType, target, multiplier, duration, jobId, actionType, actionId, reason, senderName);
        String targetDisplay = target.equals("*") ? "all players" : target;
        String jobDisplay = jobId.equals("*") ? "all jobs" : jobId;
        String actionDisplay = actionType.equals("*") ? "all actions" : actionType;
        Object actionIdDisplay = actionId.equals("*") ? "" : " (" + actionId + ")";
        sender.sendMessage("\u00a7aApplied " + boostType + " boost x" + multiplier + " for " + duration + "s to " + targetDisplay + " (" + jobDisplay + " - " + actionDisplay + (String)actionIdDisplay + ")");
    }

    private void handleRemoveBoost(CommandSender sender, String[] args) {
        if (args.length < 4) {
            sender.sendMessage("\u00a7cUsage: /jobs admin boost remove <boostId>");
            sender.sendMessage("\u00a77Use \u00a7e/jobs admin boost info\u00a77 to see active boosts");
            return;
        }
        String boostId = this.sanitizeInput(args[3]);
        boolean removedXp = this.plugin.getBonusManager().removeBoostById(boostId);
        boolean removedMoney = this.plugin.getMoneyBonusManager().removeBoostById(boostId);
        if (removedXp || removedMoney) {
            String type = removedXp ? "XP" : "Money";
            sender.sendMessage("\u00a7aRemoved " + type + " boost: " + boostId);
        } else {
            sender.sendMessage("\u00a7cBoost ID not found: " + boostId);
            sender.sendMessage("\u00a77Use \u00a7e/jobs admin boost info\u00a77 to see active boosts");
        }
    }

    private void handleInfoBoost(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            this.plugin.getBoostManagerGui().openGui(player);
        } else {
            String actionInfo;
            String jobInfo;
            String playerName;
            Player player;
            BaseBonus boost;
            sender.sendMessage("\u00a76=== Active Boosts ===");
            List<String> xpBoosts = this.plugin.getBonusManager().getAllActiveBoostIds();
            List<String> moneyBoosts = this.plugin.getMoneyBonusManager().getAllActiveBoostIds();
            if (xpBoosts.isEmpty() && moneyBoosts.isEmpty()) {
                sender.sendMessage("\u00a77No active boosts");
                return;
            }
            if (!xpBoosts.isEmpty()) {
                sender.sendMessage("\u00a7e\u00a7lXP Boosts:");
                for (String boostId : xpBoosts) {
                    boost = (XpBonus)this.plugin.getBonusManager().getBoostById(boostId);
                    if (boost == null || !boost.isActive()) continue;
                    playerName = boost.isGlobal() ? "All Players" : ((player = Bukkit.getPlayer((UUID)boost.getPlayerId())) != null ? player.getName() : "Unknown");
                    jobInfo = boost.getJobId() == null ? "All Jobs" : boost.getJobId();
                    actionInfo = this.formatActionInfo(boost.getActionType(), boost.getActionId());
                    sender.sendMessage("\u00a77  " + boostId + " \u00a78- \u00a7f" + playerName + " \u00a78| \u00a7a" + boost.getMultiplier() + "x \u00a78| \u00a7e" + jobInfo + " \u00a78| \u00a7b" + actionInfo + " \u00a78| \u00a7c" + boost.getRemainingTimeFormatted());
                }
            }
            if (!moneyBoosts.isEmpty()) {
                sender.sendMessage("\u00a76\u00a7lMoney Boosts:");
                for (String boostId : moneyBoosts) {
                    boost = (MoneyBonus)this.plugin.getMoneyBonusManager().getBoostById(boostId);
                    if (boost == null || !boost.isActive()) continue;
                    playerName = boost.isGlobal() ? "All Players" : ((player = Bukkit.getPlayer((UUID)boost.getPlayerId())) != null ? player.getName() : "Unknown");
                    jobInfo = boost.getJobId() == null ? "All Jobs" : boost.getJobId();
                    actionInfo = this.formatActionInfo(boost.getActionType(), boost.getActionId());
                    sender.sendMessage("\u00a77  " + boostId + " \u00a78- \u00a7f" + playerName + " \u00a78| \u00a7a" + boost.getMultiplier() + "x \u00a78| \u00a7e" + jobInfo + " \u00a78| \u00a7b" + actionInfo + " \u00a78| \u00a7c" + boost.getRemainingTimeFormatted());
                }
            }
            sender.sendMessage("\u00a77Use \u00a7e/jobs admin boost remove <boostId>\u00a77 to remove a specific boost");
        }
    }

    private String formatActionInfo(String actionType, String actionId) {
        if (actionType == null) {
            return "All Actions";
        }
        if (actionId == null) {
            return actionType;
        }
        return actionType + ":" + actionId;
    }

    private boolean isValidActionType(String actionType) {
        try {
            ActionType.valueOf(actionType.toUpperCase());
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private boolean isValidActionId(String actionType, String actionId) {
        if (actionId.equals("*")) {
            return true;
        }
        try {
            ActionType enumActionType = ActionType.valueOf(actionType.toUpperCase());
            for (Job job : this.plugin.getJobManager().getJobs().values()) {
                List<JobAction> actions = job.getActions(enumActionType);
                if (actions == null) continue;
                for (JobAction action : actions) {
                    if (!action.getName().equals(actionId)) continue;
                    return true;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    private void applyBoost(String boostType, String target, double multiplier, long duration, String jobId, String actionType, String actionId, String reason, String senderName) {
        String finalJobId;
        String finalActionType = actionType.equals("*") ? null : actionType;
        String finalActionId = actionId.equals("*") ? null : actionId;
        String string = finalJobId = jobId.equals("*") ? null : jobId;
        if (target.equals("*")) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (boostType.equals(TYPE_XP)) {
                    this.plugin.getBonusManager().addActionBonus(player.getUniqueId(), finalJobId, finalActionType, finalActionId, multiplier, duration, reason, senderName, true);
                    continue;
                }
                if (!boostType.equals(TYPE_MONEY)) continue;
                this.plugin.getMoneyBonusManager().addActionBonus(player.getUniqueId(), finalJobId, finalActionType, finalActionId, multiplier, duration, reason, senderName, true);
            }
        } else {
            Player targetPlayer = Bukkit.getPlayer((String)target);
            if (targetPlayer == null) {
                return;
            }
            if (boostType.equals(TYPE_XP)) {
                this.plugin.getBonusManager().addActionBonus(targetPlayer.getUniqueId(), finalJobId, finalActionType, finalActionId, multiplier, duration, reason, senderName, false);
            } else if (boostType.equals(TYPE_MONEY)) {
                this.plugin.getMoneyBonusManager().addActionBonus(targetPlayer.getUniqueId(), finalJobId, finalActionType, finalActionId, multiplier, duration, reason, senderName, false);
            }
        }
    }

    private void removeBoost(String boostType, Player targetPlayer, String jobId) {
        if (jobId == null || jobId.equals("*")) {
            if (boostType.equals(TYPE_XP)) {
                this.plugin.getBonusManager().removeAllBonuses(targetPlayer.getUniqueId());
            } else if (boostType.equals(TYPE_MONEY)) {
                this.plugin.getMoneyBonusManager().removeAllBonuses(targetPlayer.getUniqueId());
            }
        } else if (boostType.equals(TYPE_XP)) {
            List<XpBonus> bonuses = this.plugin.getBonusManager().getActiveBonuses(targetPlayer.getUniqueId(), jobId);
            bonuses.forEach(this.plugin.getBonusManager()::removeBonus);
        } else if (boostType.equals(TYPE_MONEY)) {
            List<MoneyBonus> bonuses = this.plugin.getMoneyBonusManager().getActiveBonuses(targetPlayer.getUniqueId(), jobId);
            bonuses.forEach(this.plugin.getMoneyBonusManager()::removeBonus);
        }
    }

    private double parseMultiplier(String input) {
        try {
            String multiplierStr = this.sanitizeNumber(input);
            if (multiplierStr.isEmpty() || multiplierStr.length() > 10) {
                return -1.0;
            }
            double multiplier = Double.parseDouble(multiplierStr);
            return multiplier > 0.1 && multiplier <= 10.0 && !Double.isNaN(multiplier) && !Double.isInfinite(multiplier) ? multiplier : -1.0;
        }
        catch (NumberFormatException e) {
            return -1.0;
        }
    }

    private long parseDuration(String input) {
        try {
            String durationStr = this.sanitizeNumber(input);
            if (durationStr.isEmpty() || durationStr.length() > 10) {
                return -1L;
            }
            long duration = Long.parseLong(durationStr);
            return duration > 0L && duration <= 86400L ? duration : -1L;
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    private void sendBoostHelp(CommandSender sender) {
        sender.sendMessage("\u00a76=== Boost Commands ===");
        sender.sendMessage("\u00a7e/jobs admin boost <action> <args...>");
        sender.sendMessage("");
        sender.sendMessage("\u00a76Actions:");
        sender.sendMessage("\u00a7e  give <xp|money> <player/*> <job/*> <action_type> [id_in_action] <multiplier> <duration>");
        sender.sendMessage("\u00a7e  remove <boostId>");
        sender.sendMessage("\u00a7e  info");
        sender.sendMessage("");
        sender.sendMessage("\u00a77Examples:");
        sender.sendMessage("\u00a77  /jobs admin boost give xp * miner * 2.0 3600");
        sender.sendMessage("\u00a77  /jobs admin boost give money Player123 * BREAK simple_break 1.5 1800");
        sender.sendMessage("\u00a77  /jobs admin boost remove xp1");
        sender.sendMessage("\u00a77  /jobs admin boost info");
    }
}

