/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.command.handler;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.command.handler.JobCommandHandler;
import fr.ax_dev.universejobs.job.Job;
import fr.ax_dev.universejobs.job.PlayerJobData;
import fr.ax_dev.universejobs.utils.MessageUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class InfoStatsCommandHandler
extends JobCommandHandler {
    public InfoStatsCommandHandler(UniverseJobs plugin) {
        super(plugin);
    }

    @Override
    public boolean handleCommand(CommandSender sender, String[] args) {
        String subCommand;
        Player player = this.validatePlayerSender(sender);
        if (player == null) {
            return true;
        }
        if (args.length == 0) {
            return false;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "info": {
                this.handleInfoCommand(player, args);
                break;
            }
            case "list": {
                this.handleListCommand(player);
                break;
            }
            case "stats": {
                this.handleStatsCommand(player, args);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        Player player = this.getPlayerFromSender(sender);
        if (player == null || args.length == 0) {
            return completions;
        }
        String subCommand = args[0].toLowerCase();
        if (args.length == 2) {
            String input = args[1].toLowerCase();
            switch (subCommand) {
                case "info": {
                    for (Job job : this.jobManager.getAllJobs()) {
                        if (!job.getId().toLowerCase().startsWith(input)) continue;
                        completions.add(job.getId());
                    }
                    for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
                        if (!onlinePlayer.getName().toLowerCase().startsWith(input)) continue;
                        completions.add(onlinePlayer.getName());
                    }
                    break;
                }
                case "stats": {
                    for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
                        if (!onlinePlayer.getName().toLowerCase().startsWith(input)) continue;
                        completions.add(onlinePlayer.getName());
                    }
                    break;
                }
            }
        }
        return completions;
    }

    private void handleInfoCommand(Player player, String[] args) {
        if (args.length < 2) {
            this.showPlayerJobInfo(player, player);
        } else {
            String target = this.sanitizeInput(args[1]);
            if (target.isEmpty() || target.length() > 32) {
                return;
            }
            Job job = this.jobManager.getJob(target);
            if (job != null) {
                this.showJobInfo(player, job);
            } else {
                if (!this.isValidPlayerName(target)) {
                    return;
                }
                Player targetPlayer = this.plugin.getServer().getPlayer(target);
                if (targetPlayer != null) {
                    this.showPlayerJobInfo(player, targetPlayer);
                } else {
                    MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.info.not-found", "target", target));
                }
            }
        }
    }

    private void handleListCommand(Player player) {
        ArrayList<Job> jobs = new ArrayList<Job>(this.jobManager.getEnabledJobs());
        if (jobs.isEmpty()) {
            MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.list.no-jobs"));
            return;
        }
        MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.list.header"));
        for (Job job : jobs) {
            String status = this.jobManager.hasJob(player, job.getId()) ? this.languageManager.getMessage("commands.list.status-have") : this.languageManager.getMessage("commands.list.status-dont-have");
            MessageUtils.sendMessage(player, String.format("%s &e%s &7- %s", status, job.getName(), job.getDescription()));
        }
    }

    private void handleStatsCommand(Player player, String[] args) {
        Player target = player;
        if (args.length > 1 && (target = this.plugin.getServer().getPlayer(args[1])) == null) {
            MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.player-not-found"));
            return;
        }
        this.showPlayerJobInfo(player, target);
    }

    private void showJobInfo(Player player, Job job) {
        MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.info.job.header", "job", job.getName()));
        MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.info.job.description", "description", job.getDescription()));
        MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.info.job.max-level", "level", String.valueOf(job.getMaxLevel())));
        MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.info.job.permission", "permission", job.getPermission()));
        if (!job.getLore().isEmpty()) {
            MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.info.job.lore-header"));
            for (String line : job.getLore()) {
                MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.info.job.lore-line", "line", line));
            }
        }
        MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.info.job.action-types", "types", job.getActionTypes().stream().map(Enum::name).collect(Collectors.joining(", "))));
    }

    private void showPlayerJobInfo(Player viewer, Player target) {
        PlayerJobData data = this.jobManager.getPlayerData(target);
        Set<String> playerJobs = data.getJobs();
        if (playerJobs.isEmpty()) {
            if (viewer == target) {
                MessageUtils.sendMessage(viewer, this.languageManager.getMessage("commands.stats.no-jobs-self"));
            } else {
                MessageUtils.sendMessage(viewer, this.languageManager.getMessage("commands.stats.no-jobs-other", "player", target.getName()));
            }
            return;
        }
        if (viewer == target) {
            MessageUtils.sendMessage(viewer, this.languageManager.getMessage("commands.stats.header-self"));
        } else {
            MessageUtils.sendMessage(viewer, this.languageManager.getMessage("commands.stats.header-other", "player", target.getName()));
        }
        for (String jobId : playerJobs) {
            Job job = this.jobManager.getJob(jobId);
            if (job == null) continue;
            int level = this.jobManager.getLevel(target, jobId);
            double[] progress = data.getXpProgress(jobId);
            MessageUtils.sendMessage(viewer, this.languageManager.getMessage("commands.stats.job-entry", "job", job.getName(), "level", String.valueOf(level), "current_xp", String.valueOf(Math.round(progress[0])), "required_xp", String.valueOf(Math.round(progress[1]))));
        }
    }
}

