/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.command.handler;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.command.handler.JobCommandHandler;
import fr.ax_dev.universejobs.job.Job;
import fr.ax_dev.universejobs.reward.Reward;
import fr.ax_dev.universejobs.utils.MessageUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RewardsCommandHandler
extends JobCommandHandler {
    private static final String CMD_CLAIM = "claim";
    private static final String PERM_REWARDS_USE = "universejobs.rewards.use";

    public RewardsCommandHandler(UniverseJobs plugin) {
        super(plugin);
    }

    @Override
    public boolean handleCommand(CommandSender sender, String[] args) {
        String rewardSubCommand;
        Player player = this.validatePlayerSender(sender);
        if (player == null) {
            return true;
        }
        if (!this.hasPermission((CommandSender)player, PERM_REWARDS_USE)) {
            MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.rewards.no-permission"));
            return true;
        }
        if (args.length < 2) {
            this.sendRewardsHelp(player);
            return true;
        }
        return switch (rewardSubCommand = args[1].toLowerCase()) {
            case "open" -> {
                this.handleOpenCommand(player, args);
                yield true;
            }
            case CMD_CLAIM -> {
                this.handleClaimCommand(player, args);
                yield true;
            }
            default -> {
                this.sendRewardsHelp(player);
                yield true;
            }
        };
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        Player player = this.getPlayerFromSender(sender);
        if (player == null || args.length == 0) {
            return completions;
        }
        if (args.length == 2) {
            return this.getRewardsSubCommands(player, args[1].toLowerCase());
        }
        if (args.length >= 3) {
            return this.getRewardsTabCompletions(player, args);
        }
        return completions;
    }

    private List<String> getRewardsSubCommands(Player player, String input) {
        ArrayList<String> rewardSubCommands = new ArrayList<String>(Arrays.asList("open", CMD_CLAIM));
        return rewardSubCommands.stream().filter(cmd -> cmd.startsWith(input)).collect(Collectors.toList());
    }

    private void handleOpenCommand(Player player, String[] args) {
        if (args.length < 3) {
            MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.rewards.open.usage"));
            return;
        }
        String jobId = args[2];
        Job job = this.validateAndGetJob(player, jobId);
        if (job == null) {
            return;
        }
        if (!this.jobManager.hasJob(player, jobId)) {
            MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.rewards.must-have-job", "job", job.getName()));
            return;
        }
        this.rewardGuiManager.openRewardsGui(player, jobId);
    }

    private void handleClaimCommand(Player player, String[] args) {
        if (args.length < 4) {
            MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.rewards.claim.usage"));
            return;
        }
        String jobId = args[2];
        String rewardId = args[3];
        Reward reward = this.validateAndGetReward(player, jobId, rewardId);
        if (reward == null) {
            return;
        }
        if (this.rewardManager.claimReward(player, reward)) {
            MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.rewards.claim.success", "reward", reward.getName()));
        } else {
            MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.rewards.claim.failed", "reward", reward.getName()));
        }
    }

    private Job validateAndGetJob(Player player, String jobId) {
        Job job = this.jobManager.getJob(jobId);
        if (job == null) {
            MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.rewards.job-not-found", "job", jobId));
            return null;
        }
        return job;
    }

    private Reward validateAndGetReward(Player player, String jobId, String rewardId) {
        Job job = this.validateAndGetJob(player, jobId);
        if (job == null) {
            return null;
        }
        Reward reward = this.rewardManager.getReward(jobId, rewardId);
        if (reward == null) {
            MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.rewards.reward-not-found", "reward", rewardId, "job", job.getName()));
            return null;
        }
        return reward;
    }

    private List<String> getRewardsTabCompletions(Player player, String[] args) {
        return switch (args.length) {
            case 3 -> this.getRewardsCompletions3Args(player, args);
            case 4 -> this.getRewardsCompletions4Args(player, args);
            default -> new ArrayList();
        };
    }

    private List<String> getRewardsCompletions3Args(Player player, String[] args) {
        String rewardSubCommand = args[1].toLowerCase();
        String input = args[2].toLowerCase();
        return switch (rewardSubCommand) {
            case "open", CMD_CLAIM -> this.getPlayerJobCompletions(player, input);
            default -> new ArrayList();
        };
    }

    private List<String> getRewardsCompletions4Args(Player player, String[] args) {
        String rewardSubCommand = args[1].toLowerCase();
        String jobId = args[2];
        String input = args[3].toLowerCase();
        return switch (rewardSubCommand) {
            case CMD_CLAIM -> this.getRewardCompletions(jobId, input);
            default -> new ArrayList();
        };
    }

    private List<String> getPlayerJobCompletions(Player player, String input) {
        return this.jobManager.getAllJobs().stream().filter(job -> this.jobManager.hasJob(player, job.getId())).map(Job::getId).filter(id -> id.toLowerCase().startsWith(input)).collect(Collectors.toList());
    }

    private List<String> getRewardCompletions(String jobId, String input) {
        return this.rewardManager.getJobRewards(jobId).stream().map(Reward::getId).filter(id -> id.toLowerCase().startsWith(input)).collect(Collectors.toList());
    }

    private void sendRewardsHelp(Player player) {
        MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.rewards.help.header"));
        MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.rewards.help.open"));
        MessageUtils.sendMessage(player, this.languageManager.getMessage("commands.rewards.help.claim"));
    }
}

