/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.condition;

import fr.ax_dev.universejobs.condition.Condition;
import fr.ax_dev.universejobs.condition.ConditionContext;
import fr.ax_dev.universejobs.condition.ConditionResult;
import fr.ax_dev.universejobs.condition.ConditionType;
import fr.ax_dev.universejobs.condition.impl.BiomeCondition;
import fr.ax_dev.universejobs.condition.impl.ItemCondition;
import fr.ax_dev.universejobs.condition.impl.PermissionCondition;
import fr.ax_dev.universejobs.condition.impl.PlaceholderCondition;
import fr.ax_dev.universejobs.condition.impl.TimeCondition;
import fr.ax_dev.universejobs.condition.impl.WeatherCondition;
import fr.ax_dev.universejobs.condition.impl.WorldCondition;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class MultipleConditionWrapper
implements Condition {
    private final String conditionName;
    private final Condition wrappedCondition;
    private final ConditionResult globalAcceptResult;
    private final ConditionResult globalDenyResult;

    public MultipleConditionWrapper(String conditionName, ConfigurationSection conditionConfig, ConfigurationSection globalAccept, ConfigurationSection globalDeny) {
        this.conditionName = conditionName;
        this.wrappedCondition = this.createCondition(conditionName, conditionConfig);
        this.globalAcceptResult = globalAccept != null ? new ConditionResult(globalAccept, true) : null;
        this.globalDenyResult = globalDeny != null ? new ConditionResult(globalDeny, false) : null;
    }

    private Condition createCondition(String type, ConfigurationSection config) {
        ConditionType conditionType = ConditionType.fromString(type);
        if (conditionType == null) {
            return null;
        }
        return switch (conditionType) {
            case ConditionType.PLACEHOLDER -> new PlaceholderCondition(config);
            case ConditionType.PERMISSION -> new PermissionCondition(config);
            case ConditionType.ITEM -> new ItemCondition(config);
            case ConditionType.WORLD -> new WorldCondition(config);
            case ConditionType.TIME -> new TimeCondition(config);
            case ConditionType.WEATHER -> new WeatherCondition(config);
            case ConditionType.BIOME -> new BiomeCondition(config);
            default -> null;
        };
    }

    @Override
    public boolean isMet(Player player, Event event, ConditionContext context) {
        if (this.wrappedCondition == null) {
            return false;
        }
        return this.wrappedCondition.isMet(player, event, context);
    }

    @Override
    public ConditionResult getAcceptResult() {
        if (this.globalAcceptResult != null) {
            return this.globalAcceptResult;
        }
        return this.wrappedCondition != null ? this.wrappedCondition.getAcceptResult() : ConditionResult.allow();
    }

    @Override
    public ConditionResult getDenyResult() {
        ConditionResult wrappedDeny;
        if (this.globalDenyResult != null) {
            return this.globalDenyResult;
        }
        if (this.wrappedCondition != null && (wrappedDeny = this.wrappedCondition.getDenyResult()) != null && !wrappedDeny.isDefault()) {
            return wrappedDeny;
        }
        return ConditionResult.deny();
    }

    @Override
    public ConditionType getType() {
        return this.wrappedCondition != null ? this.wrappedCondition.getType() : ConditionType.CUSTOM;
    }

    public String toString() {
        return "MultipleConditionWrapper{name='" + this.conditionName + "', wrapped=" + String.valueOf(this.wrappedCondition) + "}";
    }
}

