/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.levelup;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.condition.ConditionResult;
import fr.ax_dev.universejobs.job.Job;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class SimpleLevelUpActionManager {
    private static final String LEVELS_KEY = "levels";
    private static final String MESSAGE_KEY = "message";
    private static final String TITLE_KEY = "title";
    private final UniverseJobs plugin;
    private final Map<String, List<LevelUpActionConfig>> jobActions = new ConcurrentHashMap<String, List<LevelUpActionConfig>>();

    public SimpleLevelUpActionManager(UniverseJobs plugin) {
        this.plugin = plugin;
    }

    public void loadJobActions() {
        this.jobActions.clear();
        for (Job job : this.plugin.getJobManager().getAllJobs()) {
            this.loadJobActions(job);
        }
    }

    public void loadJobActions(Job job) {
        ArrayList<LevelUpActionConfig> actions = new ArrayList<LevelUpActionConfig>();
        ConfigurationSection levelUpSection = job.getConfig().getConfigurationSection("levelup-actions");
        if (levelUpSection == null) {
            this.jobActions.put(job.getId(), actions);
            return;
        }
        for (String actionKey : levelUpSection.getKeys(false)) {
            ConfigurationSection actionSection = levelUpSection.getConfigurationSection(actionKey);
            if (actionSection == null) continue;
            String actionType = actionSection.getString("type");
            if (actionType == null) {
                this.plugin.getLogger().warning("No type specified for level up action '" + actionKey + "' in job " + job.getId());
                continue;
            }
            try {
                LevelUpActionConfig actionConfig = new LevelUpActionConfig(actionType.toLowerCase(), actionSection);
                actions.add(actionConfig);
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Failed to load level up action '" + actionKey + "' for job " + job.getId(), e);
            }
        }
        this.jobActions.put(job.getId(), actions);
        this.plugin.getLogger().info("Loaded " + actions.size() + " level up actions for job " + job.getId());
    }

    public void executeLevelUpActions(Player player, String jobId, int oldLevel, int newLevel, double totalXp, double xpGained) {
        List<LevelUpActionConfig> actions = this.jobActions.get(jobId);
        if (actions == null || actions.isEmpty()) {
            return;
        }
        Job job = this.plugin.getJobManager().getJob(jobId);
        if (job == null) {
            return;
        }
        for (int level = oldLevel + 1; level <= newLevel; ++level) {
            this.executeActionsForLevel(player, job, level, oldLevel, totalXp, xpGained, actions);
        }
    }

    private void executeActionsForLevel(Player player, Job job, int level, int oldLevel, double totalXp, double xpGained, List<LevelUpActionConfig> actions) {
        for (LevelUpActionConfig actionConfig : actions) {
            if (!actionConfig.shouldExecuteForLevel(level)) continue;
            try {
                switch (actionConfig.getType()) {
                    case "message": {
                        this.executeMessageAction(player, job, level, oldLevel, actionConfig);
                        break;
                    }
                    case "command": {
                        this.executeCommandAction(player, job, level, oldLevel, actionConfig);
                        break;
                    }
                    case "sound": {
                        this.executeSoundAction(player, job, level, oldLevel, actionConfig);
                        break;
                    }
                    case "bossbar": {
                        this.executeBossBarAction(player, job, level, oldLevel, actionConfig);
                        break;
                    }
                    case "broadcast": {
                        this.executeBroadcastAction(player, job, level, oldLevel, actionConfig);
                        break;
                    }
                    case "title": {
                        this.executeTitleAction(player, job, level, oldLevel, actionConfig);
                        break;
                    }
                    case "particle": {
                        this.executeParticleAction(player, job, level, oldLevel, actionConfig);
                        break;
                    }
                    case "reward": {
                        this.executeRewardAction(player, job, level, oldLevel, actionConfig);
                        break;
                    }
                    default: {
                        this.plugin.getLogger().warning("Unknown level up action type: " + actionConfig.getType());
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Failed to execute level up action '" + actionConfig.getType() + "' for player " + player.getName() + " in job " + job.getId(), e);
            }
        }
    }

    private void executeMessageAction(Player player, Job job, int level, int oldLevel, LevelUpActionConfig config) {
        String singleMessage;
        List<String> messages = config.getConfig().getStringList("messages");
        if (messages.isEmpty() && (singleMessage = config.getConfig().getString(MESSAGE_KEY)) != null && !singleMessage.isEmpty()) {
            messages = List.of(singleMessage);
        }
        for (String message : messages) {
            String processedMessage = this.processPlaceholders(message, player, job, level, oldLevel);
            ConditionResult.allow(processedMessage, null, null).execute(player);
        }
    }

    private void executeCommandAction(Player player, Job job, int level, int oldLevel, LevelUpActionConfig config) {
        String singleCommand;
        List<String> commands = config.getConfig().getStringList("commands");
        if (commands.isEmpty() && (singleCommand = config.getConfig().getString("command")) != null && !singleCommand.isEmpty()) {
            commands = List.of(singleCommand);
        }
        ArrayList<String> processedCommands = new ArrayList<String>();
        for (String command : commands) {
            processedCommands.add(this.processPlaceholders(command, player, job, level, oldLevel));
        }
        ConditionResult.allow(null, null, processedCommands).execute(player);
    }

    private void executeSoundAction(Player player, Job job, int level, int oldLevel, LevelUpActionConfig config) {
        String soundName = config.getConfig().getString("sound", "ENTITY_PLAYER_LEVELUP");
        try {
            Sound sound = Sound.valueOf((String)soundName.toUpperCase());
            ConditionResult.allow(null, sound, null).execute(player);
        }
        catch (IllegalArgumentException e) {
            ConditionResult.allow(null, Sound.ENTITY_PLAYER_LEVELUP, null).execute(player);
        }
    }

    private void executeBossBarAction(Player player, Job job, int level, int oldLevel, LevelUpActionConfig config) {
        String title = this.processPlaceholders(config.getConfig().getString(TITLE_KEY, "Level Up!"), player, job, level, oldLevel);
        if (title != null && !title.isEmpty()) {
            player.sendTitle("\u00a76\u00a7lLEVEL UP!", title, 10, 70, 20);
        }
    }

    private void executeBroadcastAction(Player player, Job job, int level, int oldLevel, LevelUpActionConfig config) {
        String singleMessage;
        List<String> messages = config.getConfig().getStringList("messages");
        if (messages.isEmpty() && (singleMessage = config.getConfig().getString(MESSAGE_KEY)) != null) {
            messages = List.of(singleMessage);
        }
        for (String message : messages) {
            String processedMessage = this.processPlaceholders(message, player, job, level, oldLevel);
            this.plugin.getServer().broadcastMessage(processedMessage);
        }
    }

    private void executeTitleAction(Player player, Job job, int level, int oldLevel, LevelUpActionConfig config) {
        String title = this.processPlaceholders(config.getConfig().getString(TITLE_KEY, ""), player, job, level, oldLevel);
        String subtitle = this.processPlaceholders(config.getConfig().getString("subtitle", ""), player, job, level, oldLevel);
        int fadeIn = config.getConfig().getInt("fade-in", 10);
        int stay = config.getConfig().getInt("stay", 70);
        int fadeOut = config.getConfig().getInt("fade-out", 20);
        player.sendTitle(title, subtitle, fadeIn, stay, fadeOut);
    }

    private void executeParticleAction(Player player, Job job, int level, int oldLevel, LevelUpActionConfig config) {
        try {
            Particle particle = Particle.valueOf((String)config.getConfig().getString("particle", "FLAME").toUpperCase());
            int count = config.getConfig().getInt("count", 20);
            player.getWorld().spawnParticle(particle, player.getLocation().add(0.0, 1.0, 0.0), count, 0.5, 1.0, 0.5, 0.1);
        }
        catch (Exception e) {
            player.getWorld().spawnParticle(Particle.FLAME, player.getLocation().add(0.0, 1.0, 0.0), 20, 0.5, 1.0, 0.5, 0.1);
        }
    }

    private void executeRewardAction(Player player, Job job, int level, int oldLevel, LevelUpActionConfig config) {
        String rewardId = config.getConfig().getString("reward-id");
        if (rewardId != null) {
            List<CallSite> commands = List.of("jobs reward give " + player.getName() + " " + rewardId);
            ConditionResult.allow(null, null, commands).execute(player);
        }
    }

    private String processPlaceholders(String text, Player player, Job job, int level, int oldLevel) {
        return text.replace("{player}", player.getName()).replace("{job}", job.getName()).replace("{oldlevel}", String.valueOf(oldLevel)).replace("{newlevel}", String.valueOf(level)).replace("{level}", String.valueOf(level));
    }

    public void reload() {
        this.loadJobActions();
    }

    public static class LevelUpActionConfig {
        private final String type;
        private final ConfigurationSection config;
        private final int minLevel;
        private final int maxLevel;
        private final Set<Integer> specificLevels;
        private final int levelInterval;

        public LevelUpActionConfig(String type, ConfigurationSection config) {
            this.type = type;
            this.config = config;
            this.minLevel = config.getInt("min-level", 1);
            this.maxLevel = config.getInt("max-level", Integer.MAX_VALUE);
            this.levelInterval = config.getInt("level-interval", 0);
            this.specificLevels = new HashSet<Integer>();
            if (config.contains(SimpleLevelUpActionManager.LEVELS_KEY)) {
                if (config.isList(SimpleLevelUpActionManager.LEVELS_KEY)) {
                    Iterator iterator = config.getIntegerList(SimpleLevelUpActionManager.LEVELS_KEY).iterator();
                    while (iterator.hasNext()) {
                        int level = (Integer)iterator.next();
                        this.specificLevels.add(level);
                    }
                } else {
                    this.specificLevels.add(config.getInt(SimpleLevelUpActionManager.LEVELS_KEY));
                }
            }
        }

        public boolean shouldExecuteForLevel(int level) {
            if (!this.specificLevels.isEmpty()) {
                return this.specificLevels.contains(level);
            }
            if (level < this.minLevel || level > this.maxLevel) {
                return false;
            }
            if (this.levelInterval > 0) {
                return (level - this.minLevel) % this.levelInterval == 0;
            }
            return true;
        }

        public String getType() {
            return this.type;
        }

        public ConfigurationSection getConfig() {
            return this.config;
        }
    }
}

