/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.menu;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.menu.config.MenuItemConfig;
import fr.ax_dev.universejobs.menu.config.SingleMenuConfig;
import fr.ax_dev.universejobs.reward.gui.ItemBuilder;
import fr.ax_dev.universejobs.utils.MessageUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public abstract class BaseMenu
implements InventoryHolder {
    protected final UniverseJobs plugin;
    protected final Player player;
    protected final SingleMenuConfig config;
    protected Inventory inventory;
    protected int currentPage = 0;

    public BaseMenu(UniverseJobs plugin, Player player, SingleMenuConfig config) {
        this.plugin = plugin;
        this.player = player;
        this.config = config;
    }

    protected final void initialize() {
        this.createInventory();
        this.populateInventory();
    }

    protected void createInventory() {
        String title = this.processPlaceholders(this.config.getTitle());
        Component titleComponent = MessageUtils.parseMessage(title);
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.config.getSize(), (Component)titleComponent);
    }

    protected abstract void populateInventory();

    public abstract void handleClick(int var1, InventoryClickEvent var2);

    public void open() {
        this.player.openInventory(this.inventory);
    }

    public void close() {
        this.player.closeInventory();
    }

    public void onClose() {
    }

    public boolean isInventory(Inventory inventory) {
        return this.inventory.equals((Object)inventory);
    }

    public void refresh() {
        this.inventory.clear();
        this.populateInventory();
    }

    protected ItemStack createMenuItem(MenuItemConfig itemConfig) {
        return this.createMenuItem(itemConfig, null);
    }

    protected ItemStack createMenuItem(MenuItemConfig itemConfig, Map<String, String> customPlaceholders) {
        ItemStack item;
        ItemMeta meta;
        ItemBuilder builder = ItemBuilder.fromMaterialName(this.plugin, itemConfig.getMaterial()).amount(itemConfig.getAmount());
        String displayName = itemConfig.getDisplayName();
        if (customPlaceholders != null) {
            displayName = this.replacePlaceholders(displayName, customPlaceholders);
        }
        displayName = this.processPlaceholders(displayName);
        builder.name(displayName);
        ArrayList<String> lore = new ArrayList<String>();
        Iterator<String> iterator = itemConfig.getLore().iterator();
        while (iterator.hasNext()) {
            String loreLine;
            String processedLore = loreLine = iterator.next();
            if (customPlaceholders != null) {
                processedLore = this.replacePlaceholders(processedLore, customPlaceholders);
            }
            processedLore = this.processPlaceholders(processedLore);
            lore.add(processedLore);
        }
        builder.lore(lore);
        if (itemConfig.getCustomModelData() > 0) {
            builder.customModelData(itemConfig.getCustomModelData());
        }
        if (itemConfig.isHideAttributes() || itemConfig.isHideEnchants()) {
            builder.hideAttributes();
        }
        if ((meta = (item = builder.build()).getItemMeta()) != null) {
            if (item.getType() == Material.PLAYER_HEAD && !itemConfig.getSkullOwner().isEmpty() && meta instanceof SkullMeta) {
                SkullMeta skullMeta = (SkullMeta)meta;
                String skullOwner = itemConfig.getSkullOwner();
                if (customPlaceholders != null) {
                    skullOwner = this.replacePlaceholders(skullOwner, customPlaceholders);
                }
                skullOwner = this.processPlaceholders(skullOwner);
                try {
                    skullMeta.setOwningPlayer(this.plugin.getServer().getOfflinePlayer(skullOwner));
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Failed to set skull owner: " + skullOwner);
                }
            }
            for (Map.Entry<String, Integer> entry : itemConfig.getEnchantments().entrySet()) {
                try {
                    Enchantment enchantment = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)entry.getKey().toLowerCase()));
                    if (enchantment == null) continue;
                    meta.addEnchant(enchantment, entry.getValue().intValue(), true);
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Invalid enchantment: " + entry.getKey());
                }
            }
            if (itemConfig.isGlow() && itemConfig.getEnchantments().isEmpty()) {
                meta.addEnchant(Enchantment.LURE, 1, true);
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            if (itemConfig.isHideToolTip()) {
                meta.setHideTooltip(true);
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    protected void addFillItems() {
        MenuItemConfig fillConfig = this.config.getFillItem();
        if (fillConfig == null || !fillConfig.isEnabled()) {
            return;
        }
        ItemStack fillItem = this.createMenuItem(fillConfig);
        List<Integer> slotsToFill = fillConfig.getSlots();
        if (slotsToFill.isEmpty()) {
            slotsToFill = this.config.getFillSlots();
        }
        for (int slot : slotsToFill) {
            if (slot < 0 || slot >= this.inventory.getSize() || this.inventory.getItem(slot) != null) continue;
            this.inventory.setItem(slot, fillItem);
        }
    }

    protected String processPlaceholders(String text) {
        if (text == null) {
            return "";
        }
        try {
            if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                text = PlaceholderAPI.setPlaceholders((Player)this.player, (String)text);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return text;
    }

    protected String replacePlaceholders(String text, Map<String, String> placeholders) {
        if (text == null || placeholders == null) {
            return text;
        }
        String result = text;
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            String key = entry.getKey();
            if (key.startsWith("{") && key.endsWith("}")) {
                result = result.replace(key, entry.getValue());
                continue;
            }
            result = result.replace("{" + key + "}", entry.getValue());
        }
        return result;
    }

    protected boolean handleNavigationClick(int slot) {
        if (this.config.getNavigationSlots().containsKey("previous") && this.config.getNavigationSlots().get("previous").contains(slot) && this.currentPage > 0) {
            --this.currentPage;
            this.refresh();
            return true;
        }
        if (this.config.getNavigationSlots().containsKey("next") && this.config.getNavigationSlots().get("next").contains(slot) && this.hasNextPage()) {
            ++this.currentPage;
            this.refresh();
            return true;
        }
        if (this.config.getNavigationSlots().containsKey("close") && this.config.getNavigationSlots().get("close").contains(slot)) {
            this.close();
            return true;
        }
        if (this.config.getNavigationSlots().containsKey("back") && this.config.getNavigationSlots().get("back").contains(slot)) {
            this.handleBackButton();
            return true;
        }
        return false;
    }

    protected abstract boolean hasNextPage();

    protected void handleBackButton() {
        this.close();
    }

    public Inventory getInventory() {
        return this.inventory;
    }
}

