/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.menu.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;

public class JobItemFormat {
    private final boolean useJobIcon;
    private final String displayName;
    private final List<String> lore;
    private final List<String> loreWithoutJob;
    private final boolean glowWhenJoined;
    private final boolean glowWhenNotJoined;
    private final int amount;
    private final boolean hideAttributes;
    private final boolean hideEnchants;

    public JobItemFormat(ConfigurationSection config) {
        this.useJobIcon = config.getBoolean("use-job-icon", true);
        this.displayName = config.getString("display-name", "&e&l{job_name}");
        this.lore = config.getStringList("lore");
        this.loreWithoutJob = config.getStringList("lore-without-job");
        this.glowWhenJoined = config.getBoolean("glow-when-joined", true);
        this.glowWhenNotJoined = config.getBoolean("glow-when-not-joined", false);
        this.amount = config.getInt("amount", 1);
        this.hideAttributes = config.getBoolean("hide-attributes", true);
        this.hideEnchants = config.getBoolean("hide-enchants", true);
        if (this.lore.isEmpty()) {
            this.lore.addAll(JobItemFormat.getDefaultLore());
        }
        if (this.loreWithoutJob.isEmpty()) {
            this.loreWithoutJob.addAll(JobItemFormat.getDefaultLoreWithoutJob());
        }
    }

    private JobItemFormat(boolean useJobIcon, String displayName, List<String> lore, List<String> loreWithoutJob, boolean glowWhenJoined, boolean glowWhenNotJoined, int amount, boolean hideAttributes, boolean hideEnchants) {
        this.useJobIcon = useJobIcon;
        this.displayName = displayName;
        this.lore = lore;
        this.loreWithoutJob = loreWithoutJob;
        this.glowWhenJoined = glowWhenJoined;
        this.glowWhenNotJoined = glowWhenNotJoined;
        this.amount = amount;
        this.hideAttributes = hideAttributes;
        this.hideEnchants = hideEnchants;
    }

    public static JobItemFormat getDefault() {
        return new JobItemFormat(true, "&e&l{job_name}", JobItemFormat.getDefaultLore(), JobItemFormat.getDefaultLoreWithoutJob(), true, false, 1, true, true);
    }

    private static List<String> getDefaultLore() {
        return Arrays.asList("&7{job_description}", "", "&7Max Level: &e{job_max_level}", "", "&7Your Status:", "&8\u251c &7Level: &a{player_level}&7/&e{job_max_level}", "&8\u251c &7XP: &b{player_xp}", "&8\u251c &7Progress: &e{progress_percent}%", "&8\u2514 &7Status: {job_status}", "", "&7Progress to Next Level:", "&8\u2514 {progress_bar}", "", "&e\u25b6 Left-Click to open job menu", "&a\u25b6 Shift-Left-Click to join/leave");
    }

    private static List<String> getDefaultLoreWithoutJob() {
        return Arrays.asList("&7{job_description}", "", "&7Max Level: &e{job_max_level}", "", "&cYou don't have this job", "", "&e\u25b6 Left-Click to open job menu", "&a\u25b6 Shift-Left-Click to join");
    }

    public boolean isUseJobIcon() {
        return this.useJobIcon;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<String> getLore() {
        return new ArrayList<String>(this.lore);
    }

    public List<String> getLoreWithoutJob() {
        return new ArrayList<String>(this.loreWithoutJob);
    }

    public boolean isGlowWhenJoined() {
        return this.glowWhenJoined;
    }

    public boolean isGlowWhenNotJoined() {
        return this.glowWhenNotJoined;
    }

    public int getAmount() {
        return this.amount;
    }

    public boolean isHideAttributes() {
        return this.hideAttributes;
    }

    public boolean isHideEnchants() {
        return this.hideEnchants;
    }
}

