/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.menu.utils;

import fr.ax_dev.universejobs.action.ActionType;
import fr.ax_dev.universejobs.menu.config.MenuItemConfig;
import fr.ax_dev.universejobs.menu.config.SimpleConfigurationSection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class MenuItemUtils {
    public static Map<String, Object> createItemConfigMap(String material, String displayName, List<String> lore, boolean glow) {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put("enabled", true);
        configMap.put("material", material);
        configMap.put("amount", 1);
        configMap.put("display-name", displayName);
        configMap.put("lore", lore);
        configMap.put("custom-model-data", 0);
        configMap.put("glow", glow);
        configMap.put("hide-attributes", false);
        configMap.put("hide-enchants", glow);
        configMap.put("slots", new ArrayList());
        configMap.put("action", "none");
        configMap.put("action-value", "");
        return configMap;
    }

    public static MenuItemConfig createMenuItemConfig(String material, String displayName, List<String> lore, String action, boolean glow) {
        Map<String, Object> configMap = MenuItemUtils.createItemConfigMap(material, displayName, lore, glow);
        configMap.put("action", action);
        return new MenuItemConfig((ConfigurationSection)new SimpleConfigurationSection(configMap));
    }

    public static MenuItemConfig createJoinLeaveButton(boolean hasJob, String jobName) {
        String material = hasJob ? "RED_CONCRETE" : "GREEN_CONCRETE";
        String displayName = hasJob ? "&c&lLeave Job" : "&a&lJoin Job";
        String action = hasJob ? "leave_job" : "join_job";
        ArrayList<String> lore = new ArrayList<String>();
        if (hasJob) {
            lore.add("&7Click to leave this job");
            lore.add("");
            lore.add("&c&lWARNING:");
            lore.add("&cYou will lose all progress!");
        } else {
            lore.add("&7Click to join this job");
        }
        return MenuItemUtils.createMenuItemConfig(material, displayName, lore, action, false);
    }

    public static MenuItemConfig createActionsButton() {
        List<String> lore = Arrays.asList("&7View all available actions", "&7and their rewards for this job", "", "&e\u25b6 Click to open actions menu");
        return MenuItemUtils.createMenuItemConfig("DIAMOND_PICKAXE", "&6&lActions & Rewards", lore, "open_actions", false);
    }

    public static MenuItemConfig createRankingsButton() {
        List<String> lore = Arrays.asList("&7View global job rankings", "&7and see top players", "", "&e\u25b6 Click to open rankings");
        return MenuItemUtils.createMenuItemConfig("GOLD_INGOT", "&6&lGlobal Rankings", lore, "open_rankings", false);
    }

    public static MenuItemConfig createBackButton(String displayName, String loreText) {
        List<String> lore = Arrays.asList("&7" + loreText);
        return MenuItemUtils.createMenuItemConfig("ARROW", displayName, lore, "back", false);
    }

    public static MenuItemConfig createCloseButton() {
        List<String> lore = Arrays.asList("&7Close this menu");
        return MenuItemUtils.createMenuItemConfig("BARRIER", "&c&lClose", lore, "close", false);
    }

    public static String getActionMaterial(ActionType actionType) {
        return switch (actionType) {
            case ActionType.KILL -> "DIAMOND_SWORD";
            case ActionType.PLACE -> "GRASS_BLOCK";
            case ActionType.BREAK -> "IRON_PICKAXE";
            case ActionType.HARVEST -> "WHEAT";
            case ActionType.BLOCK_INTERACT -> "OAK_BUTTON";
            case ActionType.ENTITY_INTERACT -> "LEAD";
            case ActionType.BREED -> "WHEAT_SEEDS";
            case ActionType.FISH -> "FISHING_ROD";
            case ActionType.CRAFT -> "CRAFTING_TABLE";
            case ActionType.SMELT -> "FURNACE";
            case ActionType.ENCHANT -> "ENCHANTING_TABLE";
            case ActionType.TRADE -> "EMERALD";
            case ActionType.TAME -> "BONE";
            case ActionType.SHEAR -> "SHEARS";
            case ActionType.MILK -> "MILK_BUCKET";
            case ActionType.EAT -> "COOKED_BEEF";
            case ActionType.POTION -> "POTION";
            case ActionType.CUSTOM -> "COMMAND_BLOCK";
            default -> "STONE";
        };
    }

    public static String formatActionName(ActionType actionType) {
        return actionType.name().toLowerCase().replace("_", " ");
    }

    public static Map<String, String> createNavigationPlaceholders(int currentPage, int totalItems, int itemsPerPage) {
        int totalPages = (int)Math.ceil((double)totalItems / (double)itemsPerPage);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("current_page", String.valueOf(currentPage + 1));
        placeholders.put("total_pages", String.valueOf(totalPages));
        placeholders.put("total_items", String.valueOf(totalItems));
        return placeholders;
    }

    public static Map<String, String> createJobPlaceholders(String jobId, String jobName, String jobDescription) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("job_id", jobId);
        placeholders.put("job_name", jobName);
        placeholders.put("job_description", jobDescription);
        return placeholders;
    }

    public static void addNavigationItems(Inventory inventory, Map<String, MenuItemConfig> navItems, int currentPage, boolean hasNextPage, Map<String, String> placeholders, Function<MenuItemConfig, ItemStack> itemCreator) {
        if (navItems.containsKey("previous") && currentPage > 0) {
            MenuItemConfig prevConfig = navItems.get("previous");
            ItemStack prevItem = itemCreator.apply(prevConfig);
            for (int slot : prevConfig.getSlots()) {
                if (slot < 0 || slot >= inventory.getSize()) continue;
                inventory.setItem(slot, prevItem);
            }
        }
        if (navItems.containsKey("next") && hasNextPage) {
            MenuItemConfig nextConfig = navItems.get("next");
            ItemStack nextItem = itemCreator.apply(nextConfig);
            for (int slot : nextConfig.getSlots()) {
                if (slot < 0 || slot >= inventory.getSize()) continue;
                inventory.setItem(slot, nextItem);
            }
        }
        if (navItems.containsKey("back")) {
            MenuItemConfig backConfig = navItems.get("back");
            ItemStack backItem = itemCreator.apply(backConfig);
            for (int slot : backConfig.getSlots()) {
                if (slot < 0 || slot >= inventory.getSize()) continue;
                inventory.setItem(slot, backItem);
            }
        }
        if (navItems.containsKey("close")) {
            MenuItemConfig closeConfig = navItems.get("close");
            ItemStack closeItem = itemCreator.apply(closeConfig);
            for (int slot : closeConfig.getSlots()) {
                if (slot < 0 || slot >= inventory.getSize()) continue;
                inventory.setItem(slot, closeItem);
            }
        }
    }

    public static void addStaticItems(Inventory inventory, Map<String, MenuItemConfig> staticItems, Map<String, String> placeholders, Function<MenuItemConfig, ItemStack> itemCreator) {
        for (Map.Entry<String, MenuItemConfig> entry : staticItems.entrySet()) {
            MenuItemConfig itemConfig = entry.getValue();
            if (!itemConfig.isEnabled()) continue;
            ItemStack item = itemCreator.apply(itemConfig);
            for (int slot : itemConfig.getSlots()) {
                if (slot < 0 || slot >= inventory.getSize() || inventory.getItem(slot) != null) continue;
                inventory.setItem(slot, item);
            }
        }
    }
}

