/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.placeholder;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.bonus.BaseBonus;
import fr.ax_dev.universejobs.bonus.MoneyBonus;
import fr.ax_dev.universejobs.bonus.XpBonus;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class BoostPlaceholder
extends PlaceholderExpansion {
    private final UniverseJobs plugin;

    public BoostPlaceholder(UniverseJobs plugin) {
        this.plugin = plugin;
    }

    public String getIdentifier() {
        return "universejobs";
    }

    public String getAuthor() {
        return this.plugin.getDescription().getAuthors().toString();
    }

    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public String onRequest(OfflinePlayer player, String params) {
        if (params == null) {
            return null;
        }
        String[] args = params.split("_");
        if (args.length < 2) {
            return null;
        }
        if (!args[0].equalsIgnoreCase("boost")) {
            return null;
        }
        String type = args[1];
        switch (type.toLowerCase()) {
            case "count": {
                return this.handleCountPlaceholder(args);
            }
            case "list": {
                return this.handleListPlaceholder(args);
            }
            case "player": {
                return this.handlePlayerBoostPlaceholder(player, args);
            }
            case "global": {
                return this.handleGlobalBoostPlaceholder(args);
            }
        }
        return null;
    }

    private String handleCountPlaceholder(String[] args) {
        if (args.length < 3) {
            return null;
        }
        String countType = args[2];
        switch (countType.toLowerCase()) {
            case "xp": {
                return String.valueOf(this.getActiveXpBoostsCount());
            }
            case "money": {
                return String.valueOf(this.getActiveMoneyBoostsCount());
            }
            case "total": {
                return String.valueOf(this.getActiveXpBoostsCount() + this.getActiveMoneyBoostsCount());
            }
        }
        return null;
    }

    private String handleListPlaceholder(String[] args) {
        if (args.length < 4) {
            return null;
        }
        String listType = args[2];
        try {
            int position = Integer.parseInt(args[3]);
            String info = args.length > 4 ? args[4] : "id";
            switch (listType.toLowerCase()) {
                case "xp": {
                    return this.getXpBoostInfo(position, info);
                }
                case "money": {
                    return this.getMoneyBoostInfo(position, info);
                }
            }
            return null;
        }
        catch (NumberFormatException e) {
            return "Invalid Position";
        }
    }

    private String handlePlayerBoostPlaceholder(OfflinePlayer player, String[] args) {
        if (player == null || args.length < 3) {
            return null;
        }
        String playerType = args[2];
        switch (playerType.toLowerCase()) {
            case "hasxp": {
                return String.valueOf(this.playerHasActiveXpBoost(player.getUniqueId()));
            }
            case "hasmoney": {
                return String.valueOf(this.playerHasActiveMoneyBoost(player.getUniqueId()));
            }
            case "hasany": {
                return String.valueOf(this.playerHasActiveXpBoost(player.getUniqueId()) || this.playerHasActiveMoneyBoost(player.getUniqueId()));
            }
            case "xpcount": {
                return String.valueOf(this.getPlayerActiveXpBoostsCount(player.getUniqueId()));
            }
            case "moneycount": {
                return String.valueOf(this.getPlayerActiveMoneyBoostsCount(player.getUniqueId()));
            }
            case "totalcount": {
                return String.valueOf(this.getPlayerActiveXpBoostsCount(player.getUniqueId()) + this.getPlayerActiveMoneyBoostsCount(player.getUniqueId()));
            }
        }
        return null;
    }

    private String handleGlobalBoostPlaceholder(String[] args) {
        if (args.length < 3) {
            return null;
        }
        String globalType = args[2];
        switch (globalType.toLowerCase()) {
            case "hasxp": {
                return String.valueOf(this.hasGlobalXpBoost());
            }
            case "hasmoney": {
                return String.valueOf(this.hasGlobalMoneyBoost());
            }
            case "hasany": {
                return String.valueOf(this.hasGlobalXpBoost() || this.hasGlobalMoneyBoost());
            }
            case "xpcount": {
                return String.valueOf(this.getGlobalXpBoostsCount());
            }
            case "moneycount": {
                return String.valueOf(this.getGlobalMoneyBoostsCount());
            }
            case "totalcount": {
                return String.valueOf(this.getGlobalXpBoostsCount() + this.getGlobalMoneyBoostsCount());
            }
        }
        return null;
    }

    private int getActiveXpBoostsCount() {
        return this.plugin.getBonusManager().getAllActiveBoostIds().size();
    }

    private int getActiveMoneyBoostsCount() {
        return this.plugin.getMoneyBonusManager().getAllActiveBoostIds().size();
    }

    private String getXpBoostInfo(int position, String info) {
        List boosts = this.plugin.getBonusManager().getAllActiveBoostIds().stream().map(id -> (XpBonus)this.plugin.getBonusManager().getBoostById((String)id)).filter(boost -> boost != null && boost.isActive()).collect(Collectors.toList());
        if (position < 1 || position > boosts.size()) {
            return this.getEmptyBoostValue(info);
        }
        XpBonus boost2 = (XpBonus)boosts.get(position - 1);
        return this.formatBoostInfo(boost2, info);
    }

    private String getMoneyBoostInfo(int position, String info) {
        List boosts = this.plugin.getMoneyBonusManager().getAllActiveBoostIds().stream().map(id -> (MoneyBonus)this.plugin.getMoneyBonusManager().getBoostById((String)id)).filter(boost -> boost != null && boost.isActive()).collect(Collectors.toList());
        if (position < 1 || position > boosts.size()) {
            return this.getEmptyBoostValue(info);
        }
        MoneyBonus boost2 = (MoneyBonus)boosts.get(position - 1);
        return this.formatBoostInfo(boost2, info);
    }

    private String formatBoostInfo(BaseBonus boost, String info) {
        switch (info.toLowerCase()) {
            case "id": {
                return boost.getBoostId();
            }
            case "multiplier": {
                return String.valueOf(boost.getMultiplier());
            }
            case "remainingtime": {
                return boost.getRemainingTimeFormatted();
            }
            case "playername": {
                if (boost.isGlobal()) {
                    return "All Players";
                }
                Player player = Bukkit.getPlayer((UUID)boost.getPlayerId());
                return player != null ? player.getName() : "Unknown";
            }
            case "job": {
                return boost.getJobId() != null ? boost.getJobId() : "All Jobs";
            }
            case "action": {
                return this.formatActionInfo(boost.getActionType(), boost.getActionId());
            }
            case "isglobal": {
                return String.valueOf(boost.isGlobal());
            }
            case "isactive": {
                return String.valueOf(boost.isActive());
            }
        }
        return "Invalid Info";
    }

    private String formatActionInfo(String actionType, String actionId) {
        if (actionType == null) {
            return "All Actions";
        }
        if (actionId == null) {
            return actionType;
        }
        return actionType + ":" + actionId;
    }

    private String getEmptyBoostValue(String info) {
        switch (info.toLowerCase()) {
            case "id": {
                return "No Boost";
            }
            case "multiplier": {
                return "0.0";
            }
            case "remainingtime": {
                return "0s";
            }
            case "playername": {
                return "No Player";
            }
            case "job": {
                return "No Job";
            }
            case "action": {
                return "No Action";
            }
            case "isglobal": 
            case "isactive": {
                return "false";
            }
        }
        return "N/A";
    }

    private boolean playerHasActiveXpBoost(UUID playerId) {
        return this.plugin.getBonusManager().getAllActiveBoostIds().stream().map(id -> (XpBonus)this.plugin.getBonusManager().getBoostById((String)id)).anyMatch(boost -> boost != null && boost.isActive() && (boost.isGlobal() || boost.getPlayerId().equals(playerId)));
    }

    private boolean playerHasActiveMoneyBoost(UUID playerId) {
        return this.plugin.getMoneyBonusManager().getAllActiveBoostIds().stream().map(id -> (MoneyBonus)this.plugin.getMoneyBonusManager().getBoostById((String)id)).anyMatch(boost -> boost != null && boost.isActive() && (boost.isGlobal() || boost.getPlayerId().equals(playerId)));
    }

    private int getPlayerActiveXpBoostsCount(UUID playerId) {
        return (int)this.plugin.getBonusManager().getAllActiveBoostIds().stream().map(id -> (XpBonus)this.plugin.getBonusManager().getBoostById((String)id)).filter(boost -> boost != null && boost.isActive() && (boost.isGlobal() || boost.getPlayerId().equals(playerId))).count();
    }

    private int getPlayerActiveMoneyBoostsCount(UUID playerId) {
        return (int)this.plugin.getMoneyBonusManager().getAllActiveBoostIds().stream().map(id -> (MoneyBonus)this.plugin.getMoneyBonusManager().getBoostById((String)id)).filter(boost -> boost != null && boost.isActive() && (boost.isGlobal() || boost.getPlayerId().equals(playerId))).count();
    }

    private boolean hasGlobalXpBoost() {
        return this.plugin.getBonusManager().getAllActiveBoostIds().stream().map(id -> (XpBonus)this.plugin.getBonusManager().getBoostById((String)id)).anyMatch(boost -> boost != null && boost.isActive() && boost.isGlobal());
    }

    private boolean hasGlobalMoneyBoost() {
        return this.plugin.getMoneyBonusManager().getAllActiveBoostIds().stream().map(id -> (MoneyBonus)this.plugin.getMoneyBonusManager().getBoostById((String)id)).anyMatch(boost -> boost != null && boost.isActive() && boost.isGlobal());
    }

    private int getGlobalXpBoostsCount() {
        return (int)this.plugin.getBonusManager().getAllActiveBoostIds().stream().map(id -> (XpBonus)this.plugin.getBonusManager().getBoostById((String)id)).filter(boost -> boost != null && boost.isActive() && boost.isGlobal()).count();
    }

    private int getGlobalMoneyBoostsCount() {
        return (int)this.plugin.getMoneyBonusManager().getAllActiveBoostIds().stream().map(id -> (MoneyBonus)this.plugin.getMoneyBonusManager().getBoostById((String)id)).filter(boost -> boost != null && boost.isActive() && boost.isGlobal()).count();
    }
}

