/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.placeholder;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.job.JobManager;
import fr.ax_dev.universejobs.job.PlayerJobData;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class GlobalLeaderboardPlaceholder
extends PlaceholderExpansion {
    private static final String TOTAL_LEVELS_KEY = "totallevels";
    private static final String TOTAL_JOBS_KEY = "totaljobs";
    private static final String TOTAL_XP_KEY = "totalxp";
    private static final String PLAYER_KEY = "player";
    private static final String FORMATTED_KEY = "formatted";
    private static final String INVALID_POSITION_MSG = "Invalid Position";
    private final UniverseJobs plugin;
    private final JobManager jobManager;
    private final Map<String, List<GlobalLeaderboardEntry>> cachedGlobalLeaderboards = new ConcurrentHashMap<String, List<GlobalLeaderboardEntry>>();
    private final Map<String, Long> lastCacheUpdate = new ConcurrentHashMap<String, Long>();
    private static final long CACHE_DURATION = 60000L;

    public GlobalLeaderboardPlaceholder(UniverseJobs plugin) {
        this.plugin = plugin;
        this.jobManager = plugin.getJobManager();
    }

    public String getIdentifier() {
        return "universejobs";
    }

    public String getAuthor() {
        return this.plugin.getDescription().getAuthors().toString();
    }

    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public String onRequest(OfflinePlayer player, String params) {
        if (params == null) {
            return null;
        }
        String[] args = params.split("_");
        if (args.length < 2) {
            return null;
        }
        if (!args[0].equalsIgnoreCase("global")) {
            return null;
        }
        String type = args[1];
        String[] newArgs = new String[args.length - 1];
        System.arraycopy(args, 1, newArgs, 0, args.length - 1);
        switch (type.toLowerCase()) {
            case "totallevels": {
                return this.handleTotalLevelsLeaderboard(newArgs);
            }
            case "totaljobs": {
                return this.handleTotalJobsLeaderboard(newArgs);
            }
            case "totalxp": {
                return this.handleTotalXpLeaderboard(newArgs);
            }
            case "player": {
                return this.handleGlobalPlayerStats(player, newArgs);
            }
        }
        return null;
    }

    private String handleTotalLevelsLeaderboard(String[] args) {
        if (args.length < 3) {
            return null;
        }
        try {
            int position = Integer.parseInt(args[1]);
            String info = args.length > 2 ? args[2] : FORMATTED_KEY;
            List<GlobalLeaderboardEntry> leaderboard = this.getGlobalLeaderboard(TOTAL_LEVELS_KEY);
            if (position < 1 || position > leaderboard.size()) {
                return this.getEmptyGlobalValue(info);
            }
            GlobalLeaderboardEntry entry = leaderboard.get(position - 1);
            return this.formatGlobalLeaderboardInfo(entry, info, position, "levels");
        }
        catch (NumberFormatException e) {
            return INVALID_POSITION_MSG;
        }
    }

    private String handleTotalJobsLeaderboard(String[] args) {
        if (args.length < 3) {
            return null;
        }
        try {
            int position = Integer.parseInt(args[1]);
            String info = args.length > 2 ? args[2] : FORMATTED_KEY;
            List<GlobalLeaderboardEntry> leaderboard = this.getGlobalLeaderboard(TOTAL_JOBS_KEY);
            if (position < 1 || position > leaderboard.size()) {
                return this.getEmptyGlobalValue(info);
            }
            GlobalLeaderboardEntry entry = leaderboard.get(position - 1);
            return this.formatGlobalLeaderboardInfo(entry, info, position, "jobs");
        }
        catch (NumberFormatException e) {
            return INVALID_POSITION_MSG;
        }
    }

    private String handleTotalXpLeaderboard(String[] args) {
        if (args.length < 3) {
            return null;
        }
        try {
            int position = Integer.parseInt(args[1]);
            String info = args.length > 2 ? args[2] : FORMATTED_KEY;
            List<GlobalLeaderboardEntry> leaderboard = this.getGlobalLeaderboard(TOTAL_XP_KEY);
            if (position < 1 || position > leaderboard.size()) {
                return this.getEmptyGlobalValue(info);
            }
            GlobalLeaderboardEntry entry = leaderboard.get(position - 1);
            return this.formatGlobalLeaderboardInfo(entry, info, position, "XP");
        }
        catch (NumberFormatException e) {
            return INVALID_POSITION_MSG;
        }
    }

    private String handleGlobalPlayerStats(OfflinePlayer player, String[] args) {
        if (player == null || args.length < 2) {
            return null;
        }
        String stat = args[1];
        PlayerJobData playerData = this.jobManager.getPlayerData(player.getUniqueId());
        switch (stat.toLowerCase()) {
            case "totallevels": {
                return String.valueOf(this.calculateTotalLevels(playerData));
            }
            case "totaljobs": {
                return String.valueOf(playerData.getJobs().size());
            }
            case "totalxp": {
                return String.format("%.1f", this.calculateTotalXp(playerData));
            }
            case "rank": {
                if (args.length < 3) {
                    return null;
                }
                String rankType = args[2];
                return String.valueOf(this.getGlobalPlayerRank(player.getUniqueId(), rankType));
            }
            case "avgLevel": {
                return String.format("%.1f", this.calculateAverageLevel(playerData));
            }
        }
        return null;
    }

    private List<GlobalLeaderboardEntry> getGlobalLeaderboard(String type) {
        String cacheKey = type;
        Long lastUpdate = this.lastCacheUpdate.get(cacheKey);
        long currentTime = System.currentTimeMillis();
        if (lastUpdate != null && currentTime - lastUpdate < 60000L) {
            return this.cachedGlobalLeaderboards.getOrDefault(cacheKey, new ArrayList());
        }
        List<GlobalLeaderboardEntry> leaderboard = this.calculateGlobalLeaderboard(type);
        this.cachedGlobalLeaderboards.put(cacheKey, leaderboard);
        this.lastCacheUpdate.put(cacheKey, currentTime);
        return leaderboard;
    }

    private List<GlobalLeaderboardEntry> calculateGlobalLeaderboard(String type) {
        ArrayList<GlobalLeaderboardEntry> entries = new ArrayList<GlobalLeaderboardEntry>();
        File dataFolder = new File(this.plugin.getDataFolder(), "data");
        if (!dataFolder.exists()) {
            return entries;
        }
        File[] dataFiles = dataFolder.listFiles((dir, name) -> name.endsWith(".yml"));
        if (dataFiles == null) {
            return entries;
        }
        for (File dataFile : dataFiles) {
            try {
                String uuidString = dataFile.getName().replace(".yml", "");
                UUID playerUuid = UUID.fromString(uuidString);
                PlayerJobData playerData = this.jobManager.getPlayerData(playerUuid);
                if (playerData.getJobs().isEmpty()) continue;
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)playerUuid);
                String playerName = offlinePlayer.getName();
                if (playerName == null) {
                    playerName = "Unknown Player";
                }
                double value = 0.0;
                switch (type) {
                    case "totallevels": {
                        value = this.calculateTotalLevels(playerData);
                        break;
                    }
                    case "totaljobs": {
                        value = playerData.getJobs().size();
                        break;
                    }
                    case "totalxp": {
                        value = this.calculateTotalXp(playerData);
                        break;
                    }
                    default: {
                        value = 0.0;
                    }
                }
                entries.add(new GlobalLeaderboardEntry(playerUuid, playerName, value));
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error processing global data file: " + dataFile.getName());
            }
        }
        entries.sort((a, b) -> Double.compare(b.value, a.value));
        return entries;
    }

    private int calculateTotalLevels(PlayerJobData playerData) {
        int totalLevels = 0;
        for (String jobId : playerData.getJobs()) {
            totalLevels += playerData.getLevel(jobId);
        }
        return totalLevels;
    }

    private double calculateTotalXp(PlayerJobData playerData) {
        double totalXp = 0.0;
        for (String jobId : playerData.getJobs()) {
            totalXp += playerData.getXp(jobId);
        }
        return totalXp;
    }

    private double calculateAverageLevel(PlayerJobData playerData) {
        Set<String> jobs = playerData.getJobs();
        if (jobs.isEmpty()) {
            return 0.0;
        }
        int totalLevels = this.calculateTotalLevels(playerData);
        return (double)totalLevels / (double)jobs.size();
    }

    private String formatGlobalLeaderboardInfo(GlobalLeaderboardEntry entry, String info, int position, String unit) {
        switch (info.toLowerCase()) {
            case "player": 
            case "name": {
                return entry.playerName;
            }
            case "value": {
                if ("XP".equals(unit)) {
                    return String.format("%.1f", entry.value);
                }
                return String.valueOf((int)entry.value);
            }
            case "position": 
            case "rank": {
                return String.valueOf(position);
            }
            case "formatted": {
                if ("XP".equals(unit)) {
                    return String.format("#%d %s - %.1f %s", position, entry.playerName, entry.value, unit);
                }
                return String.format("#%d %s - %d %s", position, entry.playerName, (int)entry.value, unit);
            }
        }
        return "Invalid Info";
    }

    private String getEmptyGlobalValue(String info) {
        switch (info.toLowerCase()) {
            case "player": 
            case "name": {
                return "No Player";
            }
            case "value": {
                return "0";
            }
            case "position": 
            case "rank": {
                return "0";
            }
            case "formatted": {
                return "No player in ranking";
            }
        }
        return "N/A";
    }

    private int getGlobalPlayerRank(UUID playerUuid, String rankType) {
        List<GlobalLeaderboardEntry> leaderboard = this.getGlobalLeaderboard(rankType);
        for (int i = 0; i < leaderboard.size(); ++i) {
            if (!leaderboard.get((int)i).playerUuid.equals(playerUuid)) continue;
            return i + 1;
        }
        return 0;
    }

    public void clearCache() {
        this.cachedGlobalLeaderboards.clear();
        this.lastCacheUpdate.clear();
    }

    private static class GlobalLeaderboardEntry {
        final UUID playerUuid;
        final String playerName;
        final double value;

        GlobalLeaderboardEntry(UUID playerUuid, String playerName, double value) {
            this.playerUuid = playerUuid;
            this.playerName = playerName;
            this.value = value;
        }
    }
}

