/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.placeholder;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.placeholder.BoostPlaceholder;
import fr.ax_dev.universejobs.placeholder.GlobalLeaderboardPlaceholder;
import fr.ax_dev.universejobs.placeholder.JobsLeaderboardPlaceholder;
import org.bukkit.Bukkit;

public class PlaceholderManager {
    private final UniverseJobs plugin;
    private JobsLeaderboardPlaceholder jobsLeaderboardPlaceholder;
    private GlobalLeaderboardPlaceholder globalLeaderboardPlaceholder;
    private BoostPlaceholder boostPlaceholder;
    private boolean placeholderApiEnabled = false;

    public PlaceholderManager(UniverseJobs plugin) {
        this.plugin = plugin;
    }

    public void initialize() {
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            try {
                this.jobsLeaderboardPlaceholder = new JobsLeaderboardPlaceholder(this.plugin);
                this.globalLeaderboardPlaceholder = new GlobalLeaderboardPlaceholder(this.plugin);
                this.boostPlaceholder = new BoostPlaceholder(this.plugin);
                this.jobsLeaderboardPlaceholder.register();
                this.globalLeaderboardPlaceholder.register();
                this.boostPlaceholder.register();
                this.placeholderApiEnabled = true;
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to initialize PlaceholderAPI integration: " + e.getMessage());
            }
        } else {
            this.plugin.getLogger().warning("PlaceholderAPI not found. Placeholder features will be disabled.");
        }
    }

    public void shutdown() {
        if (this.placeholderApiEnabled) {
            try {
                if (this.jobsLeaderboardPlaceholder != null) {
                    this.jobsLeaderboardPlaceholder.unregister();
                }
                if (this.globalLeaderboardPlaceholder != null) {
                    this.globalLeaderboardPlaceholder.unregister();
                }
                if (this.boostPlaceholder != null) {
                    this.boostPlaceholder.unregister();
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error while disabling PlaceholderAPI integration: " + e.getMessage());
            }
        }
    }

    public void clearCache() {
        if (this.placeholderApiEnabled) {
            if (this.jobsLeaderboardPlaceholder != null) {
                this.jobsLeaderboardPlaceholder.clearCache();
            }
            if (this.globalLeaderboardPlaceholder != null) {
                this.globalLeaderboardPlaceholder.clearCache();
            }
            this.plugin.getLogger().info("Placeholder cache cleared.");
        }
    }

    public void clearJobCache(String jobId) {
        if (this.placeholderApiEnabled && this.jobsLeaderboardPlaceholder != null) {
            this.jobsLeaderboardPlaceholder.clearJobCache(jobId);
            this.plugin.getLogger().info("Placeholder cache cleared for job: " + jobId);
        }
    }

    public boolean isPlaceholderApiEnabled() {
        return this.placeholderApiEnabled;
    }

    public JobsLeaderboardPlaceholder getJobsLeaderboardPlaceholder() {
        return this.jobsLeaderboardPlaceholder;
    }

    public GlobalLeaderboardPlaceholder getGlobalLeaderboardPlaceholder() {
        return this.globalLeaderboardPlaceholder;
    }

    public BoostPlaceholder getBoostPlaceholder() {
        return this.boostPlaceholder;
    }
}

