/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.reward.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;

public class GuiConfig {
    private final String title;
    private final int size;
    private final Map<String, GuiItem> items;
    private final List<Integer> rewardSlots;
    private final NavigationConfig navigation;
    private final Map<String, Object> fillItems;

    public GuiConfig(ConfigurationSection config) {
        this.title = config.getString("title", "&6Rewards");
        this.size = config.getInt("size", 54);
        this.items = new HashMap<String, GuiItem>();
        this.rewardSlots = new ArrayList<Integer>();
        this.navigation = new NavigationConfig(config.getConfigurationSection("navigation"));
        this.fillItems = new HashMap<String, Object>();
        this.loadItems(config);
        this.loadRewardSlots(config);
        this.loadFillItems(config);
    }

    private void loadItems(ConfigurationSection config) {
        ConfigurationSection itemsSection = config.getConfigurationSection("items");
        if (itemsSection != null) {
            for (String key : itemsSection.getKeys(false)) {
                ConfigurationSection itemConfig = itemsSection.getConfigurationSection(key);
                if (itemConfig == null) continue;
                GuiItem item = new GuiItem(itemConfig);
                this.items.put(key, item);
            }
        }
    }

    private void loadRewardSlots(ConfigurationSection config) {
        List slots = config.getIntegerList("reward-slots");
        if (!slots.isEmpty()) {
            this.rewardSlots.addAll(slots);
        } else {
            for (int i = 9; i < 45; ++i) {
                this.rewardSlots.add(i);
            }
        }
    }

    private void loadFillItems(ConfigurationSection config) {
        ConfigurationSection fillSection = config.getConfigurationSection("fill-items");
        if (fillSection == null) {
            fillSection = config.getConfigurationSection("fill");
        }
        if (fillSection != null) {
            this.fillItems.put("enabled", fillSection.getBoolean("enabled", false));
            this.fillItems.put("material", fillSection.getString("material", "GRAY_STAINED_GLASS_PANE"));
            this.fillItems.put("name", fillSection.getString("name", " "));
            this.fillItems.put("slots", fillSection.getIntegerList("slots"));
        }
    }

    public String getTitle() {
        return this.title;
    }

    public int getSize() {
        return this.size;
    }

    public Map<String, GuiItem> getItems() {
        return this.items;
    }

    public List<Integer> getRewardSlots() {
        return this.rewardSlots;
    }

    public NavigationConfig getNavigation() {
        return this.navigation;
    }

    public Map<String, Object> getFillItems() {
        return this.fillItems;
    }

    public static class NavigationConfig {
        private final GuiItem previousPage;
        private final GuiItem nextPage;
        private final GuiItem close;
        private final GuiItem refresh;
        private final GuiItem info;

        public NavigationConfig(ConfigurationSection config) {
            if (config != null) {
                this.previousPage = config.contains("previous-page") ? new GuiItem(config.getConfigurationSection("previous-page")) : null;
                this.nextPage = config.contains("next-page") ? new GuiItem(config.getConfigurationSection("next-page")) : null;
                this.close = config.contains("close") ? new GuiItem(config.getConfigurationSection("close")) : null;
                this.refresh = config.contains("refresh") ? new GuiItem(config.getConfigurationSection("refresh")) : null;
                this.info = config.contains("info") ? new GuiItem(config.getConfigurationSection("info")) : null;
            } else {
                this.previousPage = null;
                this.nextPage = null;
                this.close = null;
                this.refresh = null;
                this.info = null;
            }
        }

        public GuiItem getPreviousPage() {
            return this.previousPage;
        }

        public GuiItem getNextPage() {
            return this.nextPage;
        }

        public GuiItem getClose() {
            return this.close;
        }

        public GuiItem getRefresh() {
            return this.refresh;
        }

        public GuiItem getInfo() {
            return this.info;
        }
    }

    public static class GuiItem {
        private final String materialName;
        private final int amount;
        private final String displayName;
        private final List<String> lore;
        private final int customModelData;
        private final Map<Enchantment, Integer> enchantments;
        private final List<Integer> slots;
        private final String action;
        private final boolean glowing;

        public GuiItem(ConfigurationSection config) {
            this.materialName = config.getString("material", "BARRIER");
            this.amount = config.getInt("amount", 1);
            this.displayName = config.getString("display-name", config.getString("name", ""));
            this.lore = config.getStringList("lore");
            this.customModelData = config.getInt("custom-model-data", -1);
            this.enchantments = this.loadEnchantments(config);
            this.slots = config.getIntegerList("slots");
            this.action = config.getString("action", "");
            this.glowing = config.getBoolean("glowing", false);
        }

        private Map<Enchantment, Integer> loadEnchantments(ConfigurationSection config) {
            HashMap<Enchantment, Integer> enchants = new HashMap<Enchantment, Integer>();
            ConfigurationSection enchSection = config.getConfigurationSection("enchantments");
            if (enchSection != null) {
                for (String enchName : enchSection.getKeys(false)) {
                    try {
                        Enchantment enchant = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)enchName.toLowerCase()));
                        if (enchant == null) continue;
                        enchants.put(enchant, enchSection.getInt(enchName));
                    }
                    catch (Exception exception) {}
                }
            }
            return enchants;
        }

        public String getMaterialName() {
            return this.materialName;
        }

        public int getAmount() {
            return this.amount;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public List<String> getLore() {
            return this.lore;
        }

        public int getCustomModelData() {
            return this.customModelData;
        }

        public Map<Enchantment, Integer> getEnchantments() {
            return this.enchantments;
        }

        public List<Integer> getSlots() {
            return this.slots;
        }

        public String getAction() {
            return this.action;
        }

        public boolean isGlowing() {
            return this.glowing;
        }
    }
}

