/*
 * Decompiled with CFR 0.152.
 */
package purplecreate.tramways.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import purplecreate.tramways.config.MessageConfig;
import purplecreate.tramways.config.TrainMessageType;

public class TrainConfig {
    private String announcer = null;
    private Map<TrainMessageType, List<MessageConfig>> messages = null;

    public static TrainConfig getInitial() {
        TrainConfig trainConfig = new TrainConfig();
        trainConfig.announcer = trainConfig.getAnnouncer();
        trainConfig.messages = new HashMap<TrainMessageType, List<MessageConfig>>();
        for (TrainMessageType type : (TrainMessageType[])TrainMessageType.class.getEnumConstants()) {
            trainConfig.messages.put(type, trainConfig.getMessages(type));
        }
        return trainConfig;
    }

    public String getAnnouncer() {
        if (Objects.isNull(this.announcer)) {
            return "en-GB-SoniaNeural";
        }
        return this.announcer;
    }

    public List<MessageConfig> getMessages(TrainMessageType type) {
        if (Objects.isNull(this.messages)) {
            return List.of(MessageConfig.simple(type.defaultString));
        }
        List<MessageConfig> msgs = this.messages.getOrDefault((Object)type, List.of());
        if (msgs.isEmpty()) {
            return List.of(MessageConfig.simple(type.defaultString));
        }
        return msgs;
    }

    public MessageConfig getRandomMessage(TrainMessageType type) {
        List<MessageConfig> msgs = this.getMessages(type);
        return msgs.get(new Random().nextInt(msgs.size()));
    }
}

