/*
 * Decompiled with CFR 0.152.
 */
package purplecreate.tramways.content.announcements;

import com.simibubi.create.AllDisplaySources;
import com.simibubi.create.api.behaviour.display.DisplayTarget;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import com.simibubi.create.content.trains.display.GlobalTrainDisplayData;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import purplecreate.tramways.TNetworking;
import purplecreate.tramways.Tramways;
import purplecreate.tramways.config.StationMessageType;
import purplecreate.tramways.content.announcements.info.StationInfo;
import purplecreate.tramways.content.announcements.network.PlayVoiceS2CPacket;

public class SpeakerDisplayTarget
extends DisplayTarget {
    private static final int windowMin = 200;
    private static final int windowMax = 900;
    private final Set<UUID> announced = new HashSet<UUID>();

    private static String getPlatform(String filter, GlobalTrainDisplayData.TrainDeparturePrediction prediction) {
        String platform = "";
        if (filter.contains("*")) {
            platform = prediction.destination;
            for (String string : filter.split("\\*")) {
                if (string.isEmpty()) continue;
                platform = platform.replace(string, "");
            }
        }
        return platform;
    }

    public void acceptText(int i, List<MutableComponent> list, DisplayLinkContext context) {
        CompoundTag config = context.sourceConfig();
        String id = config.m_128461_("Id");
        String filter = config.m_128461_("Filter");
        if (id.equals(AllDisplaySources.STATION_SUMMARY.getId().toString())) {
            List predictions = GlobalTrainDisplayData.prepare((String)filter, (int)5);
            for (GlobalTrainDisplayData.TrainDeparturePrediction prediction : predictions) {
                if (!this.announced.contains(prediction.train.id) && !prediction.destination.contains("*") && prediction.ticks >= 200 && prediction.ticks <= 900) {
                    this.announced.add(prediction.train.id);
                    StationInfo stationInfo = StationInfo.fromFilter(filter);
                    Map<String, String> props = stationInfo.getProperties(prediction.train, SpeakerDisplayTarget.getPlatform(filter, prediction));
                    StationMessageType type = filter.contains("*") ? StationMessageType.WITH_PLATFORM : StationMessageType.WITHOUT_PLATFORM;
                    TNetworking.sendToNear(new PlayVoiceS2CPacket(stationInfo.getAnnouncer(), stationInfo.getString(type).applyProperties(props), context.getTargetPos()), context.getTargetPos().m_252807_(), 50, (ResourceKey<Level>)context.level().m_46472_());
                    continue;
                }
                if (prediction.ticks >= 200) continue;
                this.announced.remove(prediction.train.id);
            }
        }
    }

    public DisplayTargetStats provideStats(DisplayLinkContext displayLinkContext) {
        return new DisplayTargetStats(1, 1, (DisplayTarget)this);
    }

    public Component getLineOptionText(int line) {
        return Tramways.translatable("display_target.speaker", new Object[0]);
    }
}

