/*
 * Decompiled with CFR 0.152.
 */
package purplecreate.tramways.content.announcements.info;

import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.Schedule;
import com.simibubi.create.content.trains.schedule.ScheduleEntry;
import com.simibubi.create.content.trains.schedule.ScheduleRuntime;
import com.simibubi.create.content.trains.schedule.destination.DestinationInstruction;
import com.simibubi.create.content.trains.schedule.destination.ScheduleInstruction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.createmod.catnip.data.Couple;
import net.minecraft.resources.ResourceLocation;
import purplecreate.tramways.config.Config;
import purplecreate.tramways.config.MessageConfig;
import purplecreate.tramways.config.TrainMessageType;
import purplecreate.tramways.content.announcements.info.StationInfo;
import purplecreate.tramways.util.ListUtil;

public class TrainInfo {
    private final Train train;
    private static Map<String, PropertyGetter> propertyGetters = new HashMap<String, PropertyGetter>();

    private TrainInfo(Train train) {
        this.train = train;
    }

    public static TrainInfo fromTrain(Train train) {
        return new TrainInfo(train);
    }

    public boolean travellingToWaypoint(int i) {
        ScheduleRuntime rt = this.train.runtime;
        Schedule schedule = rt.getSchedule();
        if (schedule == null) {
            return false;
        }
        return this.travellingToWaypoint(((ScheduleEntry)schedule.entries.get((int)i)).instruction);
    }

    public boolean travellingToWaypoint(ScheduleInstruction instruction) {
        return instruction.getId().equals((Object)new ResourceLocation("railways", "waypoint_destination"));
    }

    private List<StationInfo> getCallingAt() {
        return this.getCallingAt(this.train.runtime.currentEntry);
    }

    private List<StationInfo> getCallingAt(int startAt) {
        ScheduleRuntime rt = this.train.runtime;
        Schedule schedule = rt.getSchedule();
        ArrayList<StationInfo> callingAt = new ArrayList<StationInfo>();
        if (schedule == null) {
            return callingAt;
        }
        ArrayList<ScheduleEntry> entries = new ArrayList<ScheduleEntry>(schedule.entries);
        if (schedule.cyclic) {
            entries.add(ListUtil.getFirst(entries, e -> e.instruction instanceof DestinationInstruction));
        }
        for (int i = startAt; i < entries.size(); ++i) {
            DestinationInstruction instruction;
            ScheduleInstruction scheduleInstruction = ((ScheduleEntry)entries.get((int)i)).instruction;
            if (!(scheduleInstruction instanceof DestinationInstruction) || this.travellingToWaypoint((ScheduleInstruction)(instruction = (DestinationInstruction)scheduleInstruction))) continue;
            StationInfo destination = StationInfo.fromFilter(instruction.getFilter());
            if (schedule.cyclic && callingAt.stream().anyMatch(e -> Objects.equals(e.getAlias(), destination.getAlias()))) break;
            callingAt.add(destination);
        }
        return callingAt;
    }

    private Couple<StationInfo> getTermini() {
        List<StationInfo> callingAt = this.getCallingAt(0);
        if (callingAt.isEmpty()) {
            return Couple.create(null, null);
        }
        return Couple.create((Object)callingAt.get(0), (Object)callingAt.get(callingAt.size() - 1));
    }

    public String getAnnouncer() {
        return Config.getInstance().findTrain(this.train.name.getString()).getAnnouncer();
    }

    public MessageConfig getString(TrainMessageType type) {
        return Config.getInstance().findTrain(this.train.name.getString()).getRandomMessage(type);
    }

    public Map<String, String> getProperties() {
        return this.getProperties(true);
    }

    public Map<String, String> getProperties(boolean fixEnd) {
        List<StationInfo> callingAt = this.getCallingAt();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("train_name", this.train.name.getString());
        props.put("train_length", "" + this.train.carriages.size());
        if (callingAt.isEmpty()) {
            return props;
        }
        StationInfo end = callingAt.get(callingAt.size() - 1);
        if (fixEnd) {
            for (StationInfo terminus : this.getTermini()) {
                if (!Objects.equals(callingAt.get(0).getAlias(), terminus.getAlias())) continue;
                end = terminus;
                break;
            }
        }
        props.put("end", end.getAlias());
        props.put("end_extra", end.getExtra());
        if (this.train.runtime.state == ScheduleRuntime.State.POST_TRANSIT) {
            StationInfo current = callingAt.get(0);
            props.put("current", current.getAlias());
            props.put("current_extra", current.getExtra());
            StationInfo next = callingAt.get(callingAt.size() > 1 ? 1 : 0);
            props.put("next", next.getAlias());
            props.put("next_extra", next.getExtra());
        } else {
            StationInfo next = callingAt.get(0);
            props.put("next", next.getAlias());
            props.put("next_extra", next.getExtra());
        }
        propertyGetters.forEach((prefix, getter) -> getter.getProperties(this.train).forEach((pk, pv) -> props.put(prefix + ":" + pk, (String)pv)));
        return props;
    }

    public static void registerPropertyGetter(String prefix, PropertyGetter getter) {
        if (propertyGetters.containsKey(prefix)) {
            throw new AssertionError((Object)("Already registered a property getter with the prefix " + prefix));
        }
        propertyGetters.put(prefix, getter);
    }

    public static interface PropertyGetter {
        public Map<String, String> getProperties(Train var1);
    }
}

