/*
 * Decompiled with CFR 0.152.
 */
package purplecreate.tramways.content.announcements.network;

import com.mojang.blaze3d.audio.OggAudioStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.sounds.AudioStream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import purplecreate.tramways.Tramways;
import purplecreate.tramways.config.MessageConfig;
import purplecreate.tramways.content.announcements.sound.FragmentAudioStream;
import purplecreate.tramways.content.announcements.sound.MP3AudioStream;
import purplecreate.tramways.content.announcements.util.TTSFileManager;

public class PacketHandler {
    public static AudioStream getAudioStream(String voice, MessageConfig content) {
        switch (content.getType()) {
            case "tts": {
                InputStream stream = TTSFileManager.instance.cachedStream(voice, content.getMessage().get(0));
                try {
                    return new MP3AudioStream(stream);
                }
                catch (IOException e) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    File file = TTSFileManager.instance.getFile(voice, content.getMessage().get(0));
                    if (file.delete()) {
                        Tramways.LOGGER.warn("{}: {} Successfully deleted rogue file. ({})", new Object[]{e.getClass().getName(), e.getLocalizedMessage(), file.getName()});
                    } else {
                        file.deleteOnExit();
                        Tramways.LOGGER.warn("{}: {} Could not delete rogue file. Deletion queued for when VM terminates. ({})", new Object[]{e.getClass().getName(), e.getLocalizedMessage(), file.getName()});
                    }
                    return null;
                }
            }
            case "files": {
                ResourceManager manager = Minecraft.m_91087_().m_91098_();
                ArrayList<AudioStream> streams = new ArrayList<AudioStream>();
                for (String part : content.getMessage()) {
                    List resources = manager.m_213829_(new ResourceLocation(part));
                    if (resources.isEmpty()) continue;
                    try {
                        InputStream resourceStream = ((Resource)resources.get(0)).m_215507_();
                        if (part.endsWith(".mp3")) {
                            streams.add(new MP3AudioStream(resourceStream));
                            continue;
                        }
                        if (!part.endsWith(".ogg")) continue;
                        streams.add((AudioStream)new OggAudioStream(resourceStream));
                    }
                    catch (IOException iOException) {}
                }
                return new FragmentAudioStream(streams);
            }
        }
        return null;
    }
}

