/*
 * Decompiled with CFR 0.152.
 */
package purplecreate.tramways.content.announcements.network;

import com.simibubi.create.Create;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Train;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.AudioStream;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import purplecreate.tramways.Tramways;
import purplecreate.tramways.config.MessageConfig;
import purplecreate.tramways.content.announcements.network.PacketHandler;
import purplecreate.tramways.content.announcements.sound.MinimalSoundEngine;
import purplecreate.tramways.content.announcements.sound.MovingVoiceSoundInstance;
import purplecreate.tramways.util.S2CPacket;

public class PlayMovingVoiceS2CPacket
implements S2CPacket {
    final String voice;
    final MessageConfig content;
    final BlockPos localPos;
    final UUID trainId;
    final int carriageId;

    public PlayMovingVoiceS2CPacket(String voice, MessageConfig content, BlockPos localPos, Carriage carriage) {
        this(voice, content, localPos, carriage.train.id, carriage.train.carriages.indexOf(carriage));
    }

    public PlayMovingVoiceS2CPacket(String voice, MessageConfig content, BlockPos localPos, UUID trainId, int carriageId) {
        this.voice = voice;
        this.content = content;
        this.localPos = localPos;
        this.trainId = trainId;
        this.carriageId = carriageId;
    }

    public static PlayMovingVoiceS2CPacket read(FriendlyByteBuf buffer) {
        String voice = buffer.m_130277_();
        MessageConfig content = MessageConfig.readBytes(buffer);
        BlockPos localPos = buffer.m_130135_();
        UUID trainId = buffer.m_130259_();
        int carriageId = buffer.m_130242_();
        return new PlayMovingVoiceS2CPacket(voice, content, localPos, trainId, carriageId);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.voice);
        this.content.writeBytes(buffer);
        buffer.m_130064_(this.localPos);
        buffer.m_130077_(this.trainId);
        buffer.m_130130_(this.carriageId);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(Minecraft mc) {
        ClientLevel level = mc.f_91073_;
        Train train = (Train)Create.RAILWAYS.sided((LevelAccessor)level).trains.get(this.trainId);
        if (train == null) {
            Tramways.LOGGER.warn("Couldn't play voice: Requested train is null");
            return;
        }
        Carriage carriage = (Carriage)train.carriages.get(this.carriageId);
        if (carriage == null) {
            Tramways.LOGGER.warn("Couldn't play voice: Requested carriage is null");
            return;
        }
        AudioStream audioStream = PacketHandler.getAudioStream(this.voice, this.content);
        if (audioStream != null) {
            MinimalSoundEngine.play((SoundInstance)MovingVoiceSoundInstance.create(audioStream, carriage, this.localPos));
        }
    }
}

