/*
 * Decompiled with CFR 0.152.
 */
package purplecreate.tramways.content.announcements.network;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.AudioStream;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import purplecreate.tramways.config.MessageConfig;
import purplecreate.tramways.content.announcements.network.PacketHandler;
import purplecreate.tramways.content.announcements.sound.MinimalSoundEngine;
import purplecreate.tramways.content.announcements.sound.VoiceSoundInstance;
import purplecreate.tramways.util.S2CPacket;

public class PlayVoiceS2CPacket
implements S2CPacket {
    final String voice;
    final MessageConfig content;
    final BlockPos pos;

    public PlayVoiceS2CPacket(String voice, MessageConfig content, BlockPos pos) {
        this.voice = voice;
        this.content = content;
        this.pos = pos;
    }

    public static PlayVoiceS2CPacket read(FriendlyByteBuf buffer) {
        String voice = buffer.m_130277_();
        MessageConfig content = MessageConfig.readBytes(buffer);
        BlockPos pos = buffer.m_130135_();
        return new PlayVoiceS2CPacket(voice, content, pos);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.voice);
        this.content.writeBytes(buffer);
        buffer.m_130064_(this.pos);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(Minecraft mc) {
        AudioStream audioStream = PacketHandler.getAudioStream(this.voice, this.content);
        if (audioStream != null) {
            MinimalSoundEngine.play((SoundInstance)VoiceSoundInstance.create(audioStream, this.pos));
        }
    }
}

