/*
 * Decompiled with CFR 0.152.
 */
package purplecreate.tramways.content.announcements.sound;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import net.minecraft.client.sounds.AudioStream;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import purplecreate.tramways.javazoom.jl.decoder.Bitstream;
import purplecreate.tramways.javazoom.jl.decoder.BitstreamException;
import purplecreate.tramways.javazoom.jl.decoder.Decoder;
import purplecreate.tramways.javazoom.jl.decoder.Header;
import purplecreate.tramways.javazoom.jl.decoder.SampleBuffer;

public class MP3AudioStream
extends InputStream
implements AudioStream {
    private final ByteBuffer buffer = ByteBuffer.allocate(4608).order(ByteOrder.LITTLE_ENDIAN);
    private final Decoder decoder = new Decoder();
    private final InputStream input;
    private final Bitstream bitstream;
    private SampleBuffer output;
    private AudioFormat format;
    int divider;

    public MP3AudioStream(InputStream input) throws IOException {
        this.input = input;
        this.bitstream = new Bitstream(input);
        if (this.readFrame()) {
            throw new IOException("Could not find header.");
        }
    }

    private boolean readFrame() throws IOException {
        this.buffer.clear();
        try {
            Header header = this.bitstream.readFrame();
            if (header == null) {
                this.buffer.flip();
                return true;
            }
            if (this.output == null) {
                int channels = header.mode() == 3 ? 1 : 2;
                this.output = new SampleBuffer(header.sample_frequency(), channels);
                this.decoder.setOutputBuffer(this.output);
                this.format = new AudioFormat(header.frequency(), 16, channels, true, false);
                this.divider = 1;
                if (header.frequency() < 44100) {
                    this.divider *= 2;
                }
                if (channels == 1) {
                    this.divider *= 2;
                }
            }
            if (this.decoder.decodeFrame(header, this.bitstream) != this.output) {
                throw new IllegalStateException("Output buffers are different.");
            }
        }
        catch (ArrayIndexOutOfBoundsException header) {
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        short[] pcm = this.output.getBuffer();
        for (int i = 0; i < pcm.length / this.divider; ++i) {
            this.buffer.putShort(pcm[i]);
        }
        this.buffer.flip();
        this.bitstream.closeFrame();
        return false;
    }

    @Override
    public int read() throws IOException {
        if (!this.buffer.hasRemaining() && this.readFrame()) {
            return -1;
        }
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int read(byte @NotNull [] bytes, int offset, int length) throws IOException {
        int count;
        for (count = 0; count < length; count += BufferUtils.read(this.buffer, bytes, offset + count, length, count)) {
            if (this.buffer.hasRemaining() || !this.readFrame()) continue;
            return count > 0 ? count : -1;
        }
        return count;
    }

    @Override
    public int available() throws IOException {
        return this.input.available();
    }

    @Override
    public void close() throws IOException {
        try {
            this.bitstream.close();
        }
        catch (BitstreamException e) {
            throw new IOException(e);
        }
    }

    @NotNull
    public AudioFormat m_6206_() {
        return this.format;
    }

    public ByteBuffer m_7118_(int size) throws IOException {
        byte[] data = new byte[size];
        int count = IOUtils.read((InputStream)this, (byte[])data);
        ByteBuffer dest = ByteBuffer.allocateDirect(count);
        dest.order(ByteOrder.nativeOrder());
        ByteBuffer src = ByteBuffer.wrap(size != count ? Arrays.copyOf(data, count) : data);
        src.order(ByteOrder.LITTLE_ENDIAN);
        ShortBuffer destShort = dest.asShortBuffer();
        ShortBuffer srcShort = src.asShortBuffer();
        while (srcShort.hasRemaining()) {
            destShort.put(srcShort.get());
        }
        dest.rewind();
        return dest;
    }

    static class BufferUtils {
        BufferUtils() {
        }

        public static int read(ByteBuffer buffer, byte[] bytes, int offset, int length, int count) {
            length = Math.min(buffer.remaining(), length - count);
            buffer.get(bytes, offset, length);
            return length;
        }
    }
}

