/*
 * Decompiled with CFR 0.152.
 */
package purplecreate.tramways.content.announcements.sound;

import com.mojang.blaze3d.audio.Channel;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.client.sounds.AudioStream;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import purplecreate.tramways.content.announcements.sound.forge.MinimalSoundEngineImpl;
import purplecreate.tramways.mixins.ChannelMixin;

public class MinimalSoundEngine {
    private static List<Instance> records = new ArrayList<Instance>();

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static CompletableFuture<AudioStream> getStream(SoundInstance instance) {
        return MinimalSoundEngineImpl.getStream(instance);
    }

    private static float getSourceVolume(SoundSource category) {
        return category != null && category != SoundSource.MASTER ? Minecraft.m_91087_().f_91066_.m_92147_(category) : 1.0f;
    }

    private static void setPosition(SoundInstance instance, Channel channel) {
        Vec3 pos = new Vec3(instance.m_7772_(), instance.m_7780_(), instance.m_7778_());
        channel.m_83654_(pos);
    }

    public static void play(SoundInstance instance) {
        instance.m_6775_(Minecraft.m_91087_().m_91106_());
        Channel channel = ChannelMixin.createChannel();
        Sound sound = instance.m_5891_();
        float volumeMultiplier = instance.m_7769_();
        float linearAttenuation = Math.max(volumeMultiplier, 1.0f) * (float)sound.m_119798_();
        float pitch = Mth.m_14036_((float)instance.m_7783_(), (float)0.5f, (float)2.0f);
        float volume = Mth.m_14036_((float)(volumeMultiplier * MinimalSoundEngine.getSourceVolume(instance.m_8070_())), (float)0.0f, (float)1.0f);
        channel.m_83650_(pitch);
        channel.m_83666_(volume);
        channel.m_83673_(linearAttenuation);
        channel.m_83663_(false);
        MinimalSoundEngine.setPosition(instance, channel);
        channel.m_83670_(instance.m_7796_());
        MinimalSoundEngine.getStream(instance).thenAccept(stream -> {
            channel.m_83658_(stream);
            channel.m_83672_();
        });
        records.add(new Instance(instance, channel));
    }

    public static void tick() {
        ListIterator<Instance> iter = records.listIterator();
        while (iter.hasNext()) {
            Instance rec = iter.next();
            SoundInstance instance = rec.instance;
            Channel channel = rec.channel;
            channel.m_83682_();
            if (channel.m_83680_()) {
                iter.remove();
                continue;
            }
            if (!(instance instanceof TickableSoundInstance)) continue;
            TickableSoundInstance tickable = (TickableSoundInstance)instance;
            if (tickable.m_7801_()) {
                iter.remove();
                channel.m_83679_();
                continue;
            }
            tickable.m_7788_();
            MinimalSoundEngine.setPosition(instance, channel);
        }
    }

    public static void pauseAll() {
        for (Instance rec : records) {
            rec.channel.m_83677_();
        }
    }

    public static void resumeAll() {
        for (Instance rec : records) {
            rec.channel.m_83678_();
        }
    }

    public static void stopAll() {
        for (Instance rec : records) {
            rec.channel.m_83679_();
        }
    }

    record Instance(SoundInstance instance, Channel channel) {
    }
}

