/*
 * Decompiled with CFR 0.152.
 */
package purplecreate.tramways.content.announcements.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HexFormat;
import net.minecraft.client.Minecraft;
import purplecreate.tramways.content.announcements.util.Hash;
import purplecreate.tramways.content.announcements.util.TTS;

public class TTSFileManager {
    public static final TTSFileManager instance = new TTSFileManager();
    private final File folder;

    private TTSFileManager() {
        this.folder = new File(Minecraft.m_91087_().f_91069_, "tramways_voice");
        this.folder.mkdirs();
    }

    public InputStream cachedStream(String voice, String content) {
        FileOutputStream fileOutput;
        File file = this.getFile(voice, content);
        if (file.exists()) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            fileOutput = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        final InputStream stream = TTS.stream(voice, content);
        return new InputStream(){

            @Override
            public int read() throws IOException {
                int i = stream.read();
                if (i == -1) {
                    fileOutput.close();
                } else {
                    fileOutput.write(i);
                }
                return i;
            }

            @Override
            public void close() throws IOException {
                stream.close();
                fileOutput.close();
            }
        };
    }

    private String getFileName(String voice, String content) {
        String contentHash = HexFormat.of().formatHex(Hash.getSha256().digest(content.getBytes(StandardCharsets.UTF_8)));
        return voice + "-" + contentHash + ".mp3";
    }

    public File getFile(String voice, String content) {
        return new File(this.folder, this.getFileName(voice, content));
    }
}

