/*
 * Decompiled with CFR 0.152.
 */
package purplecreate.tramways.content.requestStop;

import com.simibubi.create.content.trains.entity.Train;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import purplecreate.tramways.TNetworking;
import purplecreate.tramways.content.requestStop.network.StoppingBroadcastS2CPacket;

public class RequestStopServer {
    private static final Map<Train, Float> countdowns = new HashMap<Train, Float>();
    private static final Set<Train> stopping = new HashSet<Train>();

    public static void request(Train train) {
        if (stopping.contains(train) || !countdowns.containsKey(train)) {
            return;
        }
        stopping.add(train);
        countdowns.remove(train);
        RequestStopServer.notifyPassengers(train);
    }

    public static void removeRequest(Train train) {
        if (!stopping.contains(train)) {
            return;
        }
        stopping.remove(train);
        RequestStopServer.notifyPassengers(train);
    }

    public static void updateCountdown(Train train, float countdown) {
        countdowns.put(train, Float.valueOf(countdown));
        RequestStopServer.notifyPassengers(train);
    }

    public static void removeCountdown(Train train) {
        if (!countdowns.containsKey(train)) {
            return;
        }
        countdowns.remove(train);
        RequestStopServer.notifyPassengers(train);
    }

    public static boolean shouldStop(Train train) {
        return stopping.contains(train);
    }

    private static void notifyPassengers(Train train) {
        train.carriages.forEach(carriage -> carriage.forEachPresentEntity(cce -> cce.m_146897_().forEach(entity -> {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                RequestStopServer.notifyPassenger(train, player);
            }
        })));
    }

    private static void notifyPassenger(Train train, Player player) {
        if (player instanceof ServerPlayer) {
            StoppingBroadcastS2CPacket.Type type;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            float progress = 0.0f;
            if (stopping.contains(train)) {
                type = StoppingBroadcastS2CPacket.Type.SHOW_STOPPING;
            } else if (countdowns.containsKey(train)) {
                type = StoppingBroadcastS2CPacket.Type.UPDATE_COUNTDOWN;
                progress = countdowns.get(train).floatValue();
            } else {
                type = StoppingBroadcastS2CPacket.Type.REMOVE;
            }
            TNetworking.sendToPlayer(new StoppingBroadcastS2CPacket(type, progress, train.navigation.destination == null ? "?" : train.navigation.destination.name), serverPlayer);
        }
    }
}

