/*
 * Decompiled with CFR 0.152.
 */
package purplecreate.tramways.content.requestStop.network;

import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import purplecreate.tramways.content.requestStop.RequestStopClient;
import purplecreate.tramways.util.Env;
import purplecreate.tramways.util.S2CPacket;

public class StoppingBroadcastS2CPacket
implements S2CPacket {
    public final Type type;
    public final float progress;
    public final String stationName;

    public StoppingBroadcastS2CPacket(Type type, float progress, String stationName) {
        this.type = type;
        this.progress = progress;
        this.stationName = stationName;
    }

    public static StoppingBroadcastS2CPacket read(FriendlyByteBuf buf) {
        int typeOrdinal = buf.m_130242_();
        float progress = buf.readFloat();
        String stationName = buf.m_130277_();
        for (Type type : (Type[])Type.class.getEnumConstants()) {
            if (type.ordinal() != typeOrdinal) continue;
            return new StoppingBroadcastS2CPacket(type, progress, stationName);
        }
        return new StoppingBroadcastS2CPacket(Type.REMOVE, progress, stationName);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130130_(this.type.ordinal());
        buf.writeFloat(this.progress);
        buf.m_130070_(this.stationName);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(Minecraft mc) {
        Env.unsafeRunWhenOn(Env.CLIENT, () -> () -> RequestStopClient.handleBroadcast(mc, this));
    }

    public static enum Type {
        UPDATE_COUNTDOWN,
        SHOW_STOPPING,
        REMOVE;

    }
}

