/*
 * Decompiled with CFR 0.152.
 */
package purplecreate.tramways.content.requestStop.station;

import com.simibubi.create.api.equipment.goggles.IHaveHoveringInformation;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import purplecreate.tramways.Tramways;
import purplecreate.tramways.content.announcements.info.TrainInfo;
import purplecreate.tramways.content.requestStop.station.RequestStopButtonBlock;

public class RequestStopButtonBlockEntity
extends SmartBlockEntity
implements IHaveHoveringInformation {
    private BlockPos linkedStation;
    private boolean nearestTrain;
    private Component nearestTrainName;
    private String nearestTrainTerminus;

    public RequestStopButtonBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public GlobalStation getLinkedStation() {
        BlockEntity blockEntity;
        if (this.f_58857_ != null && this.linkedStation != null && (blockEntity = this.f_58857_.m_7702_(this.linkedStation)) instanceof StationBlockEntity) {
            StationBlockEntity sbe = (StationBlockEntity)blockEntity;
            return sbe.getStation();
        }
        return null;
    }

    public void addBehaviours(List<BlockEntityBehaviour> list) {
    }

    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.getLinkedStation() == null || this.getLinkedStation().getNearestTrain() == null) {
            if (this.nearestTrain) {
                this.notifyUpdate();
            }
            this.nearestTrain = false;
            if (((Boolean)this.m_58900_().m_61143_((Property)RequestStopButtonBlock.f_51045_)).booleanValue()) {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)RequestStopButtonBlock.f_51045_, (Comparable)Boolean.valueOf(false)), 3);
            }
            return;
        }
        Train train = this.getLinkedStation().getNearestTrain();
        TrainInfo trainInfo = TrainInfo.fromTrain(train);
        Map<String, String> props = trainInfo.getProperties();
        boolean changed = !this.nearestTrain || this.nearestTrainName != train.name || !Objects.equals(this.nearestTrainTerminus, props.get("end"));
        this.nearestTrain = true;
        this.nearestTrainName = train.name;
        this.nearestTrainTerminus = props.get("end");
        if (changed) {
            this.notifyUpdate();
        }
    }

    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (!this.nearestTrain) {
            new LangBuilder("tramways").add(Tramways.translatable("request_stop.next_train.no_trains", new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY})).forGoggles(tooltip);
            return true;
        }
        new LangBuilder("tramways").add(Tramways.translatable("request_stop.next_train.title", new Object[0]).m_130940_(ChatFormatting.AQUA)).forGoggles(tooltip);
        new LangBuilder("tramways").add(Tramways.translatable("request_stop.next_train.info", this.nearestTrainName, this.nearestTrainTerminus).m_130940_(ChatFormatting.RESET)).forGoggles(tooltip);
        return true;
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.linkedStation = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("LinkedStation"));
        this.nearestTrain = tag.m_128471_("NearestTrain");
        this.nearestTrainName = Component.Serializer.m_130701_((String)tag.m_128461_("NearestTrainName"));
        this.nearestTrainTerminus = tag.m_128461_("NearestTrainTerminus");
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (this.linkedStation != null) {
            tag.m_128365_("LinkedStation", (Tag)NbtUtils.m_129224_((BlockPos)this.linkedStation));
        }
        tag.m_128379_("NearestTrain", this.nearestTrain);
        tag.m_128359_("NearestTrainName", Component.Serializer.m_130703_((Component)(this.nearestTrain && this.nearestTrainName != null ? this.nearestTrainName : Component.m_237119_())));
        tag.m_128359_("NearestTrainTerminus", this.nearestTrain && this.nearestTrainTerminus != null ? this.nearestTrainTerminus : "");
    }
}

