/*
 * Decompiled with CFR 0.152.
 */
package purplecreate.tramways.content.signs;

import com.simibubi.create.AllShapes;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import net.createmod.catnip.gui.ScreenOpener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import purplecreate.tramways.TBlockEntities;
import purplecreate.tramways.content.signs.TramSignBlockEntity;
import purplecreate.tramways.content.signs.TramSignSettingsScreen;

public class TramSignBlock
extends HorizontalDirectionalBlock
implements IBE<TramSignBlockEntity>,
IWrenchable {
    public final SignType signType;

    private TramSignBlock(SignType signType, BlockBehaviour.Properties properties) {
        super(properties);
        this.signType = signType;
    }

    public static TramSignBlock newTramSign(BlockBehaviour.Properties properties) {
        return new TramSignBlock(SignType.TRAM, properties);
    }

    public static TramSignBlock newRailwaySign(BlockBehaviour.Properties properties) {
        return new TramSignBlock(SignType.RAILWAY, properties);
    }

    public static TramSignBlock newAuxiliarySign(BlockBehaviour.Properties properties) {
        return new TramSignBlock(SignType.AUXILIARY, properties);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        if (state == null) {
            return null;
        }
        return (BlockState)state.m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return AllShapes.EIGHT_VOXEL_POLE.get(Direction.Axis.Y);
    }

    @OnlyIn(value=Dist.CLIENT)
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        TramSignBlockEntity be = (TramSignBlockEntity)this.getBlockEntity((BlockGetter)context.m_43725_(), context.m_8083_());
        if (be != null) {
            ScreenOpener.open((Screen)new TramSignSettingsScreen(be));
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
    }

    public Class<TramSignBlockEntity> getBlockEntityClass() {
        return TramSignBlockEntity.class;
    }

    public BlockEntityType<? extends TramSignBlockEntity> getBlockEntityType() {
        return (BlockEntityType)TBlockEntities.TRAM_SIGN.get();
    }

    public static enum SignType {
        TRAM,
        RAILWAY,
        AUXILIARY;

    }
}

