/*
 * Decompiled with CFR 0.152.
 */
package purplecreate.tramways.content.signs;

import com.simibubi.create.api.contraption.transformable.TransformableBlockEntity;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.trains.signal.SignalBlockEntity;
import com.simibubi.create.content.trains.track.TrackTargetingBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import purplecreate.tramways.TExtras;
import purplecreate.tramways.Tramways;
import purplecreate.tramways.content.signs.TramSignBlock;
import purplecreate.tramways.content.signs.TramSignPoint;
import purplecreate.tramways.content.signs.demands.SignDemand;

public class TramSignBlockEntity
extends SmartBlockEntity
implements TransformableBlockEntity {
    TrackTargetingBehaviour<TramSignPoint> edgePoint;
    private static final ResourceLocation DEFAULT_DEMAND_ID = Tramways.rl("speed");
    private static final ResourceLocation DEFAULT_AUX_DEMAND_ID = Tramways.rl("advance_warning_aux");
    private SignDemand demand = SignDemand.demands.get(this.getSignType() == TramSignBlock.SignType.AUXILIARY ? DEFAULT_AUX_DEMAND_ID : DEFAULT_DEMAND_ID);
    private CompoundTag demandExtra = new CompoundTag();
    private SignalBlockEntity.OverlayState overlay;

    public TramSignBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.demand.setDefaultSettings(this.demandExtra);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.edgePoint = new TrackTargetingBehaviour((SmartBlockEntity)this, TExtras.EdgePointTypes.TRAM_SIGN);
        behaviours.add((BlockEntityBehaviour)this.edgePoint);
    }

    public void transform(BlockEntity be, StructureTransform transform) {
        this.edgePoint.transform(be, transform);
    }

    public SignDemand getDemand() {
        return this.demand;
    }

    public CompoundTag getDemandExtra() {
        return this.demandExtra;
    }

    public TramSignBlock.SignType getSignType() {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof TramSignBlock) {
            return ((TramSignBlock)block).signType;
        }
        return TramSignBlock.SignType.TRAM;
    }

    public SignalBlockEntity.OverlayState getOverlay() {
        return this.overlay;
    }

    public void setDemand(ResourceLocation id) {
        ResourceLocation lastId = this.demand != null ? this.demand.id : null;
        this.demand = SignDemand.demands.get(SignDemand.demands.containsKey(id) ? id : DEFAULT_DEMAND_ID);
        if (!this.demand.id.equals((Object)lastId)) {
            this.demandExtra = new CompoundTag();
            this.demand.setDefaultSettings(this.demandExtra);
        }
        this.notifyUpdate();
        this.updatePoint();
    }

    public void setDemandExtra(CompoundTag received) {
        if (this.demand == null) {
            return;
        }
        CompoundTag disk = new CompoundTag();
        this.demand.validateSettings(received, disk);
        this.demandExtra = disk;
        this.notifyUpdate();
        this.updatePoint();
    }

    private void updatePoint() {
        TramSignPoint point = (TramSignPoint)this.edgePoint.getEdgePoint();
        if (point != null) {
            point.updateSignData(this.f_58858_, this.demand, this.demandExtra);
        }
    }

    public void setOverlay(SignalBlockEntity.OverlayState overlay) {
        if (this.overlay == overlay) {
            return;
        }
        this.overlay = overlay;
        this.notifyUpdate();
    }

    public void tick() {
        super.tick();
        if (this.f_58857_.f_46443_) {
            return;
        }
        TramSignPoint point = (TramSignPoint)this.edgePoint.getEdgePoint();
        if (point == null) {
            this.setOverlay(SignalBlockEntity.OverlayState.RENDER);
            return;
        }
        this.setOverlay(point.getOverlayFor(this.f_58858_));
        TramSignPoint.SignData data = point.getSignData(this.f_58858_);
        if (data.demand != this.demand || data.demandExtra != this.demandExtra) {
            this.demand = data.demand;
            this.demandExtra = data.demandExtra;
            this.notifyUpdate();
        }
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.overlay = (SignalBlockEntity.OverlayState)NBTHelper.readEnum((CompoundTag)tag, (String)"Overlay", SignalBlockEntity.OverlayState.class);
        if (tag.m_128441_("Demand")) {
            this.demand = SignDemand.demands.get(NBTHelper.readResourceLocation((CompoundTag)tag, (String)"Demand"));
        }
        if (tag.m_128441_("DemandExtra")) {
            this.demandExtra = tag.m_128469_("DemandExtra");
        } else {
            this.demandExtra = new CompoundTag();
            this.demand.setDefaultSettings(this.demandExtra);
        }
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        NBTHelper.writeEnum((CompoundTag)tag, (String)"Overlay", (Enum)(this.overlay == null ? SignalBlockEntity.OverlayState.SKIP : this.overlay));
        if (this.demand != null) {
            NBTHelper.writeResourceLocation((CompoundTag)tag, (String)"Demand", (ResourceLocation)this.demand.id);
        }
        if (this.demandExtra != null) {
            tag.m_128365_("DemandExtra", (Tag)this.demandExtra);
        }
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.f_58858_, this.edgePoint.getGlobalPosition()).m_82400_(2.0);
    }
}

