/*
 * Decompiled with CFR 0.152.
 */
package purplecreate.tramways.content.signs;

import com.simibubi.create.Create;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.graph.DimensionPalette;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackNode;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.signal.SignalBlockEntity;
import com.simibubi.create.content.trains.signal.SignalPropagator;
import com.simibubi.create.content.trains.signal.TrackEdgePoint;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import purplecreate.tramways.TBlockEntities;
import purplecreate.tramways.Tramways;
import purplecreate.tramways.content.signs.TramSignBlockEntity;
import purplecreate.tramways.content.signs.demands.SignDemand;

public class TramSignPoint
extends TrackEdgePoint {
    private Couple<Set<SignData>> sides = Couple.create(HashSet::new);
    private final Couple<Map<Train, Double>> queue = Couple.create(HashMap::new);

    public void updateTrain(Train train, TrackNode node, double distance) {
        ((Map)this.queue.get(this.isPrimary(node))).put(train, distance);
    }

    public void removeTrain(Train train, TrackNode node) {
        ((Map)this.queue.get(this.isPrimary(node))).remove(train);
    }

    public SignData getSignData(BlockPos pos) {
        for (boolean front : Iterate.trueAndFalse) {
            for (SignData sign : (Set)this.sides.get(front)) {
                if (!sign.pos.equals((Object)pos)) continue;
                return sign;
            }
        }
        return null;
    }

    public void updateSignData(BlockPos pos, SignDemand demand, CompoundTag demandExtra) {
        for (boolean front : Iterate.trueAndFalse) {
            for (SignData sign : (Set)this.sides.get(front)) {
                if (!sign.pos.equals((Object)pos)) continue;
                sign.shouldMigrate = false;
                sign.demand = demand;
                sign.demandExtra = demandExtra;
                return;
            }
        }
    }

    public void iterateQueue(Level level) {
        for (boolean front : Iterate.trueAndFalse) {
            if (((TrackNodeLocation)this.edgeLocation.get((boolean)front)).dimension != level.m_46472_()) continue;
            for (SignData sign : new HashSet((Collection)this.sides.get(front))) {
                if (sign.shouldMigrate) {
                    sign.shouldMigrate = false;
                    level.m_141902_(sign.pos, (BlockEntityType)TBlockEntities.TRAM_SIGN.get()).ifPresentOrElse(be -> {
                        sign.demand = be.getDemand();
                        sign.demandExtra = be.getDemandExtra();
                        Tramways.LOGGER.info("Successfully migrated tram sign at {}", (Object)sign.pos);
                    }, () -> {
                        Tramways.LOGGER.info("Couldn't migrate tram sign at {}", (Object)sign.pos);
                        this.invalidateAt((LevelAccessor)level, sign.pos);
                        ((Set)this.sides.get(front)).remove(sign);
                    });
                    continue;
                }
                ((Map)this.queue.get(front)).forEach((train, distance) -> sign.demand.execute(sign.demandExtra, (Train)train, (double)distance));
            }
        }
    }

    public SignalBlockEntity.OverlayState getOverlayFor(BlockPos pos) {
        for (boolean front : Iterate.trueAndFalse) {
            Iterator iterator = ((Set)this.sides.get(front)).iterator();
            if (!iterator.hasNext()) continue;
            SignData sign = (SignData)iterator.next();
            if (sign.pos.equals((Object)pos)) {
                return ((Set)this.sides.get(!front)).isEmpty() ? SignalBlockEntity.OverlayState.RENDER : SignalBlockEntity.OverlayState.DUAL;
            }
            return SignalBlockEntity.OverlayState.SKIP;
        }
        return SignalBlockEntity.OverlayState.SKIP;
    }

    public boolean canMerge() {
        return true;
    }

    public void invalidate(LevelAccessor level) {
        this.sides.forEach(side -> side.forEach(sign -> this.invalidateAt(level, sign.pos)));
    }

    public boolean canCoexistWith(EdgePointType<?> otherType, boolean front) {
        return otherType == this.getType();
    }

    public void blockEntityAdded(BlockEntity blockEntity, boolean front) {
        SignData sign = SignData.of(blockEntity);
        if (sign != null) {
            ((Set)this.sides.get(front)).add(sign);
            this.notifyTrains(blockEntity.m_58904_());
        }
    }

    public void blockEntityRemoved(BlockPos blockPos, boolean f) {
        this.sides.forEach(side -> side.removeIf(sign -> sign.pos.equals((Object)blockPos)));
        if (this.sides.both(Set::isEmpty)) {
            this.removeFromAllGraphs();
        }
    }

    private void notifyTrains(Level level) {
        TrackGraph graph = Create.RAILWAYS.sided((LevelAccessor)level).getGraph((LevelAccessor)level, (TrackNodeLocation)this.edgeLocation.getFirst());
        if (graph == null) {
            return;
        }
        TrackEdge edge = graph.getConnection(this.edgeLocation.map(arg_0 -> ((TrackGraph)graph).locateNode(arg_0)));
        if (edge == null) {
            return;
        }
        SignalPropagator.notifyTrains((TrackGraph)graph, (TrackEdge[])new TrackEdge[]{edge});
    }

    public void read(CompoundTag tag, boolean migration, DimensionPalette dimensions) {
        super.read(tag, migration, dimensions);
        if (migration) {
            return;
        }
        this.sides = Couple.create(HashSet::new);
        for (boolean front : Iterate.trueAndFalse) {
            ListTag posList = tag.m_128437_("Side" + (front ? 1 : 0), 10);
            ListTag dataList = tag.m_128437_("DemandData" + (front ? 1 : 0), 10);
            for (int i = 0; i < posList.size(); ++i) {
                CompoundTag posTag = posList.m_128728_(i);
                CompoundTag dataTag = dataList.m_128728_(i);
                SignData sign = new SignData();
                sign.read(posTag, dataTag);
                ((Set)this.sides.get(front)).add(sign);
            }
        }
    }

    public void write(CompoundTag tag, DimensionPalette dimensions) {
        super.write(tag, dimensions);
        for (boolean front : Iterate.trueAndFalse) {
            ListTag posList = new ListTag();
            ListTag dataList = new ListTag();
            for (SignData sign : (Set)this.sides.get(front)) {
                CompoundTag posTag = new CompoundTag();
                CompoundTag dataTag = new CompoundTag();
                sign.write(posTag, dataTag);
                posList.add((Object)posTag);
                dataList.add((Object)dataTag);
            }
            tag.m_128365_("Side" + (front ? 1 : 0), (Tag)posList);
            tag.m_128365_("DemandData" + (front ? 1 : 0), (Tag)dataList);
        }
    }

    public static class SignData {
        boolean shouldMigrate = false;
        BlockPos pos;
        SignDemand demand;
        CompoundTag demandExtra;

        SignData() {
            this(null, null, null);
        }

        SignData(BlockPos pos, SignDemand demand, CompoundTag demandExtra) {
            this.pos = pos;
            this.demand = demand;
            this.demandExtra = demandExtra;
        }

        public static SignData of(BlockEntity be) {
            SignData signData;
            if (be instanceof TramSignBlockEntity) {
                TramSignBlockEntity sbe = (TramSignBlockEntity)be;
                signData = new SignData(sbe.m_58899_(), sbe.getDemand(), sbe.getDemandExtra());
            } else {
                signData = null;
            }
            return signData;
        }

        public void read(CompoundTag posTag, CompoundTag dataTag) {
            this.pos = NbtUtils.m_129239_((CompoundTag)posTag);
            if (dataTag.m_128456_()) {
                Tramways.LOGGER.info("Going to try migrating tram sign at {}", (Object)this.pos);
                this.shouldMigrate = true;
                return;
            }
            if (dataTag.m_128441_("Demand")) {
                this.demand = SignDemand.demands.get(NBTHelper.readResourceLocation((CompoundTag)dataTag, (String)"Demand"));
            }
            if (dataTag.m_128441_("DemandExtra")) {
                this.demandExtra = dataTag.m_128469_("DemandExtra");
            }
        }

        public void write(CompoundTag posTag, CompoundTag dataTag) {
            posTag.m_128391_(NbtUtils.m_129224_((BlockPos)this.pos));
            if (this.demand != null) {
                NBTHelper.writeResourceLocation((CompoundTag)dataTag, (String)"Demand", (ResourceLocation)this.demand.id);
            }
            if (this.demandExtra != null) {
                dataTag.m_128365_("DemandExtra", (Tag)this.demandExtra);
            }
        }
    }
}

