/*
 * Decompiled with CFR 0.152.
 */
package purplecreate.tramways.content.signs.demands;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import purplecreate.tramways.TPartialModels;
import purplecreate.tramways.content.signs.TramSignBlock;

public abstract class SignDemand {
    public static final Map<ResourceLocation, SignDemand> demands = new HashMap<ResourceLocation, SignDemand>();
    public ResourceLocation id;

    public static void register(ResourceLocation location, SignDemand demand) {
        demand.id = location;
        demands.put(location, demand);
    }

    public static boolean isManual(Train train) {
        return train.runtime.getSchedule() == null || train.runtime.paused;
    }

    public static void renderTextInCenter(String text, int color, float scale, PoseStack ms, MultiBufferSource buffer, int light) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        float x = (float)fontRenderer.m_92895_(text) / -2.0f;
        Objects.requireNonNull(fontRenderer);
        float y = 9.0f / -2.0f;
        ms.m_85836_();
        ms.m_85837_(0.5, 0.5, 0.0);
        ms.m_85841_(scale, scale, scale);
        ms.m_85841_(1.0f, -1.0f, 1.0f);
        ms.m_85837_(0.5, 0.5, 0.0);
        fontRenderer.m_271703_(text, x, y, color, false, ms.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, light);
        ms.m_85849_();
    }

    public boolean isAuxiliary() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract ItemStack getIcon();

    @OnlyIn(value=Dist.CLIENT)
    public PartialModel getSignFace(TramSignBlock.SignType signType) {
        if (signType == TramSignBlock.SignType.RAILWAY) {
            return TPartialModels.RED_RAILWAY_FACE;
        }
        return TPartialModels.TRAM_FACE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initSettingsGUI(ModularGuiLineBuilder builder) {
    }

    public void validateSettings(CompoundTag received, CompoundTag disk) {
    }

    public void setDefaultSettings(CompoundTag tag) {
    }

    public void execute(CompoundTag tag, Train train, double distance) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(TramSignBlock.SignType signType, CompoundTag tag, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
    }
}

